/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dnd;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditDocumentContainerAdapter;
import com.arcway.cockpit.documentmodule.client.gui.dnd.FileAndURLDropHelper;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.RefreshDataViewRunnable;
import com.arcway.cockpit.documentmodule.client.messages.RefreshFileLinkThread;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import com.arcway.lib.eclipse.transfer.old.URLTransfer;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class FileAndURLDropHandler
implements IDropHandler,
IModuleProjectSwitchListener,
IActiveProjectProvider {
    private TreeItem currentItem = null;
    private IModelController modelController;

    public DropTarget getDropTarget() {
        HashSet<Object> transferTypes = new HashSet<Object>();
        transferTypes.add(FileTransfer.getInstance());
        transferTypes.add(URLTransfer.getInstance());
        return new DropTarget(21, transferTypes, (IDropHandler)this, (IClientFunctionLicenseType2)ClientFunctionLicenseTypeDCMModifyItems.getInstance(), (IProjectAgentProvider)DocumentModulePlugin.getDefault().getProjectManager(), (IActiveProjectProvider)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parameters) {
        TransferData dataType;
        this.currentItem = (TreeItem)event.item;
        if (!this.checkDropPosition(event)) {
            return false;
        }
        if (event.detail == 16) {
            if ((event.operations & 4) != 0) {
                parameters.requestedOperation = 4;
            } else {
                if ((event.operations & 1) == 0) return false;
                parameters.requestedOperation = 1;
            }
        } else {
            if (event.detail != 4 && event.detail != 1) return false;
            parameters.requestedOperation = event.detail;
        }
        boolean supportedTypeAvailable = false;
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            dataType = transferDataArray[n2];
            if (FileTransfer.getInstance().isSupportedType(dataType)) {
                parameters.requestedTransferType = dataType;
                supportedTypeAvailable = true;
                if (parameters.requestedOperation == 4) break;
                return false;
            }
            ++n2;
        }
        if (!supportedTypeAvailable) {
            transferDataArray = event.dataTypes;
            n = event.dataTypes.length;
            n2 = 0;
            while (n2 < n) {
                dataType = transferDataArray[n2];
                if (URLTransfer.getInstance().isSupportedType(dataType)) {
                    parameters.requestedTransferType = dataType;
                    supportedTypeAvailable = true;
                    break;
                }
                ++n2;
            }
        }
        if (!supportedTypeAvailable) {
            return false;
        }
        parameters.requestedFeedbackTypes = 25;
        return true;
    }

    private boolean checkDropPosition(DropTargetEvent event) {
        if (event.item == null) {
            return false;
        }
        Object target = event.item.getData();
        return target != null && target instanceof DocumentContainer || target instanceof Category;
    }

    public boolean performDrop(final DropTargetEvent event, int location, final Control targetControl) {
        final boolean[] successful = new boolean[1];
        targetControl.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!(event.data instanceof String[]) && !(event.data instanceof URLTransfer.URLType)) {
                    successful[0] = false;
                    return;
                }
                IModuleData element = (IModuleData)event.item.getData();
                DocumentContainer container = null;
                if (element instanceof DocumentContainer) {
                    container = (DocumentContainer)element;
                } else if (element instanceof Category) {
                    Category category = (Category)element;
                    IModelController modelController_ = FileAndURLDropHandler.this.retrieveModelController(category.getProjectUID());
                    ModuleLockManager lockMgr = (ModuleLockManager)modelController_.getLockMgr();
                    LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)category);
                    if (!lock.hasLock()) {
                        lock.releaseLocks();
                        successful[0] = false;
                        return;
                    }
                    EditDocumentContainerAdapter dialogProvider = new EditDocumentContainerAdapter(category);
                    ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.documentcontainer", modelController_, Messages.getString("EditDocumentContainerDialog.EnterDCAttributes"));
                    container = new DocumentContainer();
                    container.setProjectUID(modelController_.getProjectUID());
                    container.getName().setValueViaDisplayStringRepresentation(FileAndURLDropHelper.getNameSuggestionForContainer(event));
                    boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{container}, new IModuleData[0]);
                    if (!creationPossible) {
                        lock.releaseLocks();
                        successful[0] = false;
                        return;
                    }
                    if (new WizardDialog(targetControl.getShell(), (IWizard)wizard).open() != 0) {
                        successful[0] = false;
                        return;
                    }
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Drop should not have been enabled/possible");
                    }
                    successful[0] = false;
                    return;
                }
                final IModelController modelController_ = FileAndURLDropHandler.this.retrieveModelController(container.getProjectUID());
                final DocumentContainer containerFinal = container;
                boolean linkCreationSuccessful = modelController_.getProjectAgent().getLockManager().doWithBlockOfflineModeProjectLock(new Runnable(){

                    @Override
                    public void run() {
                        modelController_.executeTransaction(new Runnable(){

                            @Override
                            public void run() {
                                if (event.data instanceof String[]) {
                                    String[] files;
                                    String[] stringArray = files = (String[])event.data;
                                    int n = files.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String file = stringArray[n2];
                                        RLFileSystemLink fileLink = new RLFileSystemLink();
                                        fileLink.setProjectUID(modelController_.getProjectUID());
                                        fileLink.getURL().setValue(file);
                                        fileLink.calculateLocalURLs(0, (IProjectAgent)modelController_.getProjectAgent());
                                        new RefreshFileLinkThread(fileLink, new RefreshDataViewRunnable(Display.getCurrent(), fileLink, DocumentModulePlugin.getDefault().getProjectManager().getProjectAgent(modelController_.getProjectUID()).getPropertyChangesProviderManager())).start();
                                        modelController_.addItem((IModuleData)fileLink);
                                        modelController_.createLink(containerFinal.getUID(), (IModuleData)fileLink, "FilelinkDocumentContainer");
                                        ++n2;
                                    }
                                }
                                if (event.data instanceof URLTransfer.URLType) {
                                    URLTransfer.URLType url = (URLTransfer.URLType)event.data;
                                    FileAndURLDropHandler.this.currentItem.getParent().setSelection(new TreeItem[]{FileAndURLDropHandler.this.currentItem});
                                    RLWebLink webLink = new RLWebLink();
                                    webLink.setProjectUID(modelController_.getProjectUID());
                                    webLink.getURL().setValue(url.getUrl());
                                    modelController_.addItem((IModuleData)webLink);
                                    modelController_.createLink(containerFinal.getUID(), (IModuleData)webLink, "WeblinkDocumentContainer");
                                }
                            }
                        });
                    }
                });
                if (!linkCreationSuccessful) {
                    MessageDialog.openError((Shell)targetControl.getShell(), (String)Messages.getString("FileAndURLDropHandler.ExclusiveProjectLockMessage.Title"), (String)Messages.getString("FileAndURLDropHandler.ExclusiveProjectLockMessage.Message"));
                    successful[0] = false;
                    return;
                }
                successful[0] = true;
            }
        });
        return successful[0];
    }

    private IModelController retrieveModelController(String projectUID) {
        return DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.retrieveModelController(projectUID);
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }
}

