/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.description.RLWebLinkDescription;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EditWebLinkAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private RLWebLink webLink = null;
    private DocumentContainer parentContainer;
    private IModelController model = null;
    private UIETextField url;
    private LockAccess lock;

    public EditWebLinkAdapter() {
        super(false);
    }

    public EditWebLinkAdapter(DocumentContainer parent) {
        super(true);
        this.parentContainer = parent;
    }

    public String getDataTypeID() {
        return "dcm.weblink";
    }

    public Class getDataClass() {
        return RLWebLink.class;
    }

    public String getPropertyName() {
        return RLWebLink.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("weblink.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DocumentModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        this.setMessageText();
        Composite editArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        editArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        editArea.setLayoutData((Object)gridData);
        this.createCategoryWidget(editArea, 4, (IModuleData)this.webLink);
        Label labelURL = new Label(editArea, 0);
        labelURL.setText(String.valueOf(ResourceLocator.URL_NAME) + ":");
        Control widget = this.url.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 150;
        widget.setLayoutData((Object)gridData);
        this.setWidgetState();
        this.setValues();
        this.url.addModifyListener((ModifyListener)this);
        this.handleModifications(null, false);
        return editArea;
    }

    private void setMessageText() {
        if (this.isCreationDialogue()) {
            String msg = Messages.getString("EditWebLinkDialog.CreateWebLinkDetails");
            this.getCallback().setMessage(msg, 0);
        }
    }

    private void setWidgetState() {
        AbstractPermissionMgr permissionMgr = this.model.getPermissionMgr();
        boolean mayEdit = true;
        if (!this.isCreationDialogue()) {
            mayEdit &= permissionMgr.mayEditItemStructurally((IModuleData)this.webLink, (IModuleData)this.parentContainer);
        }
        if (mayEdit && !this.isCreationDialogue() && !this.lock.hasLock()) {
            mayEdit = false;
        }
        if (mayEdit) {
            this.url.setEditable(true);
        } else {
            this.url.setEditable(false);
        }
        if (mayEdit) {
            this.setCategoryEditable(true);
        } else {
            this.setCategoryEditable(false);
        }
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            this.webLink = (RLWebLink)items[0];
            this.model = DocumentModulePlugin.getDefault().getProjectManager().getModelController(this.webLink.getProjectUID());
            if (!this.isCreationDialogue()) {
                this.parentContainer = (DocumentContainer)this.model.getParent((IModuleData)this.webLink);
            }
            this.internalConstruct(this.model);
            if (!this.isCreationDialogue()) {
                ModuleLockManager lockMgr = (ModuleLockManager)this.model.getLockMgr();
                this.lock = lockMgr.acquireEditLock((ICockpitProjectData)this.webLink);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                } else {
                    this.webLink = (RLWebLink)this.model.getItem("dcm.weblink", this.webLink.getUID());
                    if (this.webLink == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    private void internalConstruct(IModelController modelCtrl) {
        this.url = new UIETextField(Messages.getString("ResourceLocator.URL_NAME"), this.webLink.getURL().getValueRangeHelper());
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return RLWebLinkDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private void setValues() {
        this.url.setValue();
    }

    private void getValues() {
        this.url.getValue();
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e, true);
    }

    private void handleModifications(ModifyEvent e, boolean notAtInitialisation) {
        String checkResult = null;
        checkResult = this.url.checkCurrentValue();
        if (notAtInitialisation) {
            this.getCallback().setErrMsg(checkResult);
            this.getCallback().setChangedStatus(true);
        } else {
            if (checkResult != null) {
                this.getCallback().setCommitable(false);
            }
            this.getCallback().setChangedStatus(false);
        }
    }

    public RLWebLink getWebLink() {
        return this.webLink;
    }

    public void cancelChanges1() {
        if (this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.EMPTY_LIST;
    }

    public void rollbackCommitRequest() {
    }

    protected void doCommitChanges() {
        this.getValues();
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.webLink);
            this.model.createLink(this.parentContainer.getUID(), (IModuleData)this.webLink, "WeblinkDocumentContainer");
        } else {
            this.model.itemPropertiesModified((IModuleData)this.webLink, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return DocumentModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("container_big.gif");
    }
}

