/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui;

import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMSearch;
import com.arcway.cockpit.documentmodule.client.gui.DCMFixColumnDescriptionProvider;
import com.arcway.cockpit.documentmodule.client.gui.DataViewLabelProvider;
import com.arcway.cockpit.documentmodule.client.gui.DocumentFilters;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionDelegateCalculateFileLinkStates;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionDelegateCopy;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionDelegateDelete;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionDelegatePaste;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionManagePathPrefixes;
import com.arcway.cockpit.documentmodule.client.gui.dnd.DocumentsCopyDragNDropSupport;
import com.arcway.cockpit.documentmodule.client.gui.dnd.DocumentsEditorDragSupport;
import com.arcway.cockpit.documentmodule.client.gui.dnd.DocumentsMoveDragNDropSupport;
import com.arcway.cockpit.documentmodule.client.gui.dnd.DocumentsNaturalOrderDragNDropSupport;
import com.arcway.cockpit.documentmodule.client.gui.dnd.FileAndURLDropHandler;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.CategorySearchStringGenerator;
import com.arcway.cockpit.documentmodule.client.messages.ContainerSearchStringGenerator;
import com.arcway.cockpit.documentmodule.client.messages.DCMDataTypesHelper;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLSearchStringGenerator;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.DelegateBasedModuleAction;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.search.ICockpitSearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataView;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForCategories;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForDiscreteValues;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IFixColumnDescriptionProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataView;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewProvider;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ICopyDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.IMoveDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ItemEditorDragSupport;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.java.EitherOr;
import com.arcway.lib.java.collectionmaps.ListMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.KeyListener;

public class DCMDataViewProvider
extends StandardTreeDataViewProvider {
    private ListMap<String, IDiscreteAttributeHandler> attributeHandlers;
    private ActionManagePathPrefixes alignFileLinkPathsAction;
    private DelegateBasedModuleAction calculateFileStatesAction;
    private ActionDelegateDelete actionDelegateDelete;
    private final DocumentsMoveDragNDropSupport moveDnDSupport;
    private final DocumentsEditorDragSupport editorDnDSupport;
    private final DocumentsNaturalOrderDragNDropSupport naturalOrderDnDSupport;
    private final DocumentsCopyDragNDropSupport copyDnDSupport;
    private final ItemEditorDragSupport itemEditorDragSupport;
    private static final IModuleDataTypeDescription[] dataTypesForAttributeHandlers = new IModuleDataTypeDescription[]{DocumentContainer.DATA_TYPE_DESCRIPTION, Category.DATA_TYPE_DESCRIPTION, RLFileSystemLink.DATA_TYPE_DESCRIPTION, RLWebLink.DATA_TYPE_DESCRIPTION};

    public DCMDataViewProvider(StandardTreeDataView dataView, Collection<String> customPropertyFilterDataTypes) {
        super(dataView, customPropertyFilterDataTypes, (IFixColumnDescriptionProvider)new DCMFixColumnDescriptionProvider(), (IModuleFixColumnProvider)new DataViewLabelProvider());
        assert (dataView != null) : "dataView must not be null";
        this.moveDnDSupport = new DocumentsMoveDragNDropSupport(null);
        this.copyDnDSupport = new DocumentsCopyDragNDropSupport(null);
        this.naturalOrderDnDSupport = new DocumentsNaturalOrderDragNDropSupport(null, (TreeDataView)dataView, (IMoveDragNDropExecuter)this.moveDnDSupport, (ICopyDragNDropExecuter)this.copyDnDSupport);
        this.editorDnDSupport = new DocumentsEditorDragSupport(null);
        this.itemEditorDragSupport = new ItemEditorDragSupport((IProjectAgentProvider)DocumentModulePlugin.getDefault().getProjectManager(), null);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.moveDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.copyDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.naturalOrderDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.editorDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.itemEditorDragSupport);
        this.createActions();
        this.createAttributeHandlers();
    }

    public ModuleActionDelegate getDeleteActionDelegate() {
        return this.actionDelegateDelete;
    }

    public DragSource[] createDragSources() {
        DragSource[] allSources = new DragSource[]{this.moveDnDSupport.getDragSource(), this.editorDnDSupport.getDragSource(), this.naturalOrderDnDSupport.getDragSource(), this.copyDnDSupport.getDragSource(), this.itemEditorDragSupport.getDragSource()};
        return allSources;
    }

    public DropTarget[] createDropTargets() {
        DropTarget[] allTargets = new DropTarget[]{this.moveDnDSupport.getDropTarget(), new FileAndURLDropHandler().getDropTarget(), this.naturalOrderDnDSupport.getDropTarget(), this.copyDnDSupport.getDropTarget()};
        return allTargets;
    }

    public List<IFilterItem> createFilterItems() {
        return new DocumentFilters((IModuleProjectSwitchListenerManager)this.dataView).createFilters();
    }

    public void dispose() {
    }

    public KeyListener createKeyListener() {
        return null;
    }

    public List<? extends IAction> getAdditionalToolbarActions() {
        ArrayList<DelegateBasedModuleAction> toolbarActions = new ArrayList<DelegateBasedModuleAction>(super.getAdditionalToolbarActions());
        toolbarActions.add(this.calculateFileStatesAction);
        return toolbarActions;
    }

    public List<EitherOr<IAction, IContributionItem>> getAdditionalViewMenuActions() {
        ArrayList<EitherOr<IAction, IContributionItem>> viewMenuActions = new ArrayList<EitherOr<IAction, IContributionItem>>(super.getAdditionalViewMenuActions());
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Either((Object)this.calculateFileStatesAction));
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Either((Object)this.alignFileLinkPathsAction));
        return viewMenuActions;
    }

    private void createActions() {
        this.calculateFileStatesAction = new DelegateBasedModuleAction((ModuleActionDelegate)new ActionDelegateCalculateFileLinkStates());
        this.calculateFileStatesAction.setText(Messages.getString("DataViewProvider.calculateFileStatesActionName"));
        this.calculateFileStatesAction.setImageDescriptor(DocumentModulePlugin.getImageDescriptor("checkLinks.gif"));
        this.calculateFileStatesAction.setToolTipText(Messages.getString("DataViewProvider.calculateFileStatesActionName"));
        this.alignFileLinkPathsAction = new ActionManagePathPrefixes();
        this.alignFileLinkPathsAction.setText(Messages.getString("DataViewProvider.locallyAlignFilePaths"));
        this.alignFileLinkPathsAction.setImageDescriptor(DocumentModulePlugin.getImageDescriptor("paths.gif"));
        this.alignFileLinkPathsAction.setToolTipText(Messages.getString("DataViewProvider.locallyAlignFilePathsTT"));
        this.actionDelegateDelete = new ActionDelegateDelete();
    }

    public String getHelpContextId() {
        return "com.arcway.cockpit.documentmodule.docmodule_index";
    }

    public String getFilterDialogueTitle() {
        return Messages.getString("DataViewProvider.FilterTitle");
    }

    public String getFilterDialogueDescription() {
        return Messages.getString("DataViewProvider.FilterDescription");
    }

    public boolean hasIncrementalSearch() {
        return true;
    }

    public Map<String, ICockpitSearchStringGenerator<IModuleData>> getSearchStringGenerators() {
        HashMap<String, ICockpitSearchStringGenerator<IModuleData>> searchStringGenerators = new HashMap<String, ICockpitSearchStringGenerator<IModuleData>>(4);
        searchStringGenerators.put("dcm.documentcontainer", (ICockpitSearchStringGenerator<IModuleData>)new ContainerSearchStringGenerator());
        RLSearchStringGenerator rlSearchStringGenerator = new RLSearchStringGenerator();
        searchStringGenerators.put("dcm.filesystemlink", (ICockpitSearchStringGenerator<IModuleData>)rlSearchStringGenerator);
        searchStringGenerators.put("dcm.weblink", (ICockpitSearchStringGenerator<IModuleData>)rlSearchStringGenerator);
        searchStringGenerators.put("dcm.category", (ICockpitSearchStringGenerator<IModuleData>)new CategorySearchStringGenerator());
        return searchStringGenerators;
    }

    public String getFullModuleID() {
        return ModuleIdentification.getModuleID();
    }

    public ModuleActionDelegate getCopyActionDelegate() {
        return new ActionDelegateCopy();
    }

    public ModuleActionDelegate getPasteActionDelegate() {
        return new ActionDelegatePaste();
    }

    public ListMap<String, IDiscreteAttributeHandler> getDiscreteAttributeHandlers() {
        return this.attributeHandlers;
    }

    private void createAttributeHandlers() {
        ProjectMgr pm = DocumentModulePlugin.getDefault().getProjectManager();
        this.attributeHandlers = new ListMap(1);
        IModuleDataTypeDescription[] iModuleDataTypeDescriptionArray = dataTypesForAttributeHandlers;
        int n = dataTypesForAttributeHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleDataTypeDescription dataType = iModuleDataTypeDescriptionArray[n2];
            if (dataType.isSupportingCategories()) {
                this.attributeHandlers.add((Object)dataType.getTypeID(), (Object)new AttributeHandlerForCategories((IModuleProjectSwitchListenerManager)this.dataView, (IModelControllerProvider)pm, dataType.getTypeID(), true));
            }
            ++n2;
        }
        this.attributeHandlers.add((Object)"dcm.documentcontainer", (Object)new AttributeHandlerForDiscreteValues((IModuleProjectSwitchListenerManager)this.dataView, (IModelControllerProvider)pm, "documentcontainer_state", DocumentContainer.STATE_NAME, "dcm.documentcontainer", DocumentContainer.getStateKeys()));
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForSearch() {
        return ClientFunctionLicenseTypeDCMSearch.getInstance();
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForChangeValueActions() {
        return ClientFunctionLicenseTypeDCMModifyItems.getInstance();
    }

    protected boolean isObjectTypeCategoryColumnNeeded() {
        return true;
    }

    protected Collection<Class<?>> getAdditionalClassesThatTriggerRefresh() {
        return Collections.emptySet();
    }

    protected ProjectMgr getProjectAssociationManager() {
        return DocumentModulePlugin.getDefault().getProjectManager();
    }

    protected IDataTypesHelper getDataTypesHelper() {
        return DCMDataTypesHelper.getDefault();
    }
}

