/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.docbook.AbstractDocBookDocumentationWriter;
import com.arcway.cockpit.docgen.writer.docbook.ClientFunctionLicenseTypeReportsDocbook;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.geometry.Dimension;
import de.plans.lib.util.HTMLEncoder;
import de.plans.lib.xml.encoding.EXEncoderException;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;

public class DocBookXMLDocumentationWriter
extends AbstractDocBookDocumentationWriter {
    private static final String REPORT_TYPE_ID = "DOCBOOK_XML";
    private static final double PREFERRED_IMAGE_RESOLUTION = 192.0;
    private static final int PREFERRED_IMAGE_SIZE = 2400;
    private static final String FILES_AND_IMAGES_DIRECTORY_NAME = "files_and_images";

    public DocBookXMLDocumentationWriter() {
        super(true, false);
    }

    @Override
    public String getID() {
        return REPORT_TYPE_ID;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("DocumentationWriter.XMLDocBook");
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getRequiredOutputTemplateTypeID() {
        return null;
    }

    @Override
    public String getOutputFormat(IReportTemplate reportTemplate) {
        return REPORT_TYPE_ID;
    }

    @Override
    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInPixel(new Dimension(2400.0, 2400.0), 192.0);
    }

    @Override
    public String getPreferredImageType() {
        return ".svg";
    }

    @Override
    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        try {
            return this.getDocBookSnippetForExternalFileLink(FILES_AND_IMAGES_DIRECTORY_NAME + File.separator + fileName, HTMLEncoder.encode((String)displayName));
        }
        catch (EXEncoderException e) {
            throw e.toNewRuntimeException("Unable to create DocBookSnippetForExternalFileLink.");
        }
    }

    @Override
    protected void postProcessWithProgress(VelocityReportJob reportJob, IWorkbenchPage workbenchPage, IProgressMonitor progressMonitor) throws ReportGenerationException {
        if (progressMonitor != null) {
            progressMonitor.beginTask(Messages.getString("DocumentationWriter.0"), -1);
            progressMonitor.subTask(Messages.getString("DocumentationWriter.2"));
        }
        File targetDirectory = new File(reportJob.getBaseReportJob().getReportFilename());
        String reportFileName = String.valueOf(targetDirectory.getName()) + ".xml";
        this.copyRawReportToTargetLocation(reportJob, reportFileName);
        File mainFile = new File(targetDirectory, reportFileName);
        reportJob.getBaseReportJob().setReportMainFileName(mainFile.getAbsolutePath());
        this.copyGraphicsAndFilesToTargetLocation(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
    }

    @Override
    protected void postprocessingInterrupted(VelocityReportJob reportJob) {
        this.cleanUpAdditionalDirectory(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
        this.cleanUpReportFile(reportJob);
    }

    @Override
    public IClientFunctionLicenseType getNeededLicenseType() {
        return ClientFunctionLicenseTypeReportsDocbook.getInstance();
    }
}

