/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.IReportTemplateRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IReportTemplateRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IParameterStore;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationItem;
import java.util.ArrayList;
import java.util.List;

public class ParameterStore
implements IReportTemplateRelatedReportProvider,
IParameterStore {
    private DocGenConfigurationItem configurationRoot;
    private static final String INT_ARRAY_SEPERATOR = ";";

    @Override
    public void setup(IReportTemplateRelatedReportContext reportContext) {
        this.configurationRoot = reportContext.getConfiguration();
    }

    @Override
    public void storeStringParameter(String parameterKey, String value) {
        DocGenConfigurationItem item = this.configurationRoot.getChild(parameterKey);
        if (item == null) {
            item = new DocGenConfigurationItem(parameterKey);
            this.configurationRoot.addChild(item);
        }
        item.setValue(value);
    }

    @Override
    public String requestStringParameter(String parameterKey, String defaultValue) {
        DocGenConfigurationItem item = this.configurationRoot.getChild(parameterKey);
        String value = item == null ? defaultValue : item.getStringValue();
        return value;
    }

    @Override
    public void storeIntParameter(String parameterKey, int value) {
        DocGenConfigurationItem item = this.configurationRoot.getChild(parameterKey);
        if (item == null) {
            item = new DocGenConfigurationItem(parameterKey);
            this.configurationRoot.addChild(item);
        }
        item.setValue(value);
    }

    @Override
    public int requestIntParameter(String parameterKey, int defaultValue) {
        int value;
        DocGenConfigurationItem item = this.configurationRoot.getChild(parameterKey);
        if (item == null) {
            value = defaultValue;
        } else {
            try {
                value = item.getIntValue();
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    @Override
    public void storeIntegerListParameter(String parameterKey, List<Integer> valueList) {
        DocGenConfigurationItem item = this.configurationRoot.getChild(parameterKey);
        if (item == null) {
            item = new DocGenConfigurationItem(parameterKey);
            this.configurationRoot.addChild(item);
        }
        StringBuffer stringValue = new StringBuffer();
        boolean first = true;
        for (Integer value : valueList) {
            if (first) {
                first = false;
            } else {
                stringValue.append(INT_ARRAY_SEPERATOR);
            }
            stringValue.append(value);
        }
        item.setValue(stringValue.toString());
    }

    @Override
    public List<Integer> requestIntegerListParameter(String parameterKey, List<Integer> defaultValueList) {
        List<Integer> valueList;
        DocGenConfigurationItem item = this.configurationRoot.getChild(parameterKey);
        if (item == null) {
            valueList = defaultValueList;
        } else {
            String valuesString = item.getStringValue();
            String[] stringArray = valuesString.split(INT_ARRAY_SEPERATOR);
            valueList = new ArrayList<Integer>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String stringValue = stringArray2[n2];
                try {
                    Integer value = new Integer(Integer.parseInt(stringValue));
                    valueList.add(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return valueList;
    }
}

