/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.graphicsandfiles.FileInReportDescription;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IDataModelProvider;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoriesManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationNEW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.ValueRangeDefinerEnumeration;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;

public class DataModelProvider
implements IProjectRelatedReportProvider,
IDataModelProvider {
    private static final ILogger logger = Logger.getLogger(DataModelProvider.class);
    private IProjectRelatedReportContext reportContext;
    private Locale projectLocale;

    @Override
    public void setup(IProjectRelatedReportContext reportContext) {
        this.reportContext = reportContext;
        this.projectLocale = new Locale(reportContext.getProjectAgent().getLanguageID());
    }

    @Override
    public boolean hasCustomProperties(String objectTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                return !attributeTypes.isEmpty();
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return false;
        }
        assert (false);
        return false;
    }

    @Override
    public boolean hasCustomProperty(String objectTypeID, String propertyTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                IAttributeType attributeType = DataModelProvider.getAttributeTypeByHumanreadableID(attributeTypes, propertyTypeID);
                if (attributeType != null) {
                    return true;
                }
                logger.error("Property " + propertyTypeID + " does not exist!");
                return false;
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return false;
        }
        assert (false);
        return false;
    }

    public static List<String> getCustomPropertyIdsForObjectType(IFrameProjectAgent projectAgent, String objectTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = projectAgent.getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getSortedAttributeTypes(cockpitTypeID);
                ArrayList<String> listOfHumanReadableIDsOfCustomProperties = new ArrayList<String>();
                for (IAttributeType attributeType : attributeTypes) {
                    listOfHumanReadableIDsOfCustomProperties.add(attributeType.getHumanReadableID());
                }
                return listOfHumanReadableIDsOfCustomProperties;
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return Collections.singletonList(NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID));
        }
        assert (false);
        return null;
    }

    @Override
    public List<String> getCustomPropertyIdsForObjectType(String objectTypeID) {
        return DataModelProvider.getCustomPropertyIdsForObjectType((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent(), objectTypeID);
    }

    @Override
    public String getDisplaynameOfProperty(String objectTypeID, String propertyTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                IAttributeType attributeType = DataModelProvider.getAttributeTypeByHumanreadableID(attributeTypes, propertyTypeID);
                if (attributeType != null) {
                    return HTMLEncoder.encode((String)attributeType.getDisplayName());
                }
                logger.error("Property " + propertyTypeID + " does not exist!");
                return String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2");
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID);
        }
        assert (false);
        return null;
    }

    public static String getDatatypeIDOfProperty(IFrameProjectAgent projectAgent, String objectTypeID, String propertyTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = projectAgent.getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                IAttributeType attributeType = DataModelProvider.getAttributeTypeByHumanreadableID(attributeTypes, propertyTypeID);
                if (attributeType != null) {
                    return HTMLEncoder.encode((String)attributeType.getDataType().getID());
                }
                logger.error("Property " + propertyTypeID + " does not exist!");
                return String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2");
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID);
        }
        assert (false);
        return null;
    }

    @Override
    public String getDatatypeIDOfProperty(String objectTypeID, String propertyTypeID) {
        return DataModelProvider.getDatatypeIDOfProperty((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent(), objectTypeID, propertyTypeID);
    }

    @Override
    public String getDatatypeDisplaynameOfProperty(String objectTypeID, String propertyTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                IAttributeType attributeType = DataModelProvider.getAttributeTypeByHumanreadableID(attributeTypes, propertyTypeID);
                if (attributeType != null) {
                    return HTMLEncoder.encode((String)attributeType.getDataType().getDisplayName(this.projectLocale));
                }
                logger.error("Property " + propertyTypeID + " does not exist!");
                return String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2");
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID);
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isFileCustomProperty(String objectTypeID, String propertyTypeID) {
        return this.isCustomPropertyOfGivenType(objectTypeID, propertyTypeID, AbstractDataTypeWithFile.class);
    }

    @Override
    public boolean isEnumerationCustomProperty(String objectTypeID, String propertyTypeID) {
        return this.isCustomPropertyOfGivenType(objectTypeID, propertyTypeID, DataTypeEnumerationNEW.class);
    }

    private boolean isCustomPropertyOfGivenType(String objectTypeID, String propertyTypeID, Class<? extends IAttributeTypeDataType> type) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                IAttributeType attributeType = DataModelProvider.getAttributeTypeByHumanreadableID(attributeTypes, propertyTypeID);
                if (attributeType != null) {
                    return type.isAssignableFrom(attributeType.getDataType().getClass());
                }
                logger.error("Property " + propertyTypeID + " does not exist!");
                return false;
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return false;
        }
        assert (false);
        return false;
    }

    @Override
    public List<String> getAllowedValuesOfCustomProperty(String objectTypeID, String propertyTypeID) {
        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        if (userDefinedAttributeTypesProvider != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List attributeTypes = userDefinedAttributeTypesProvider.getAllUserDefinedAttributeTypes(cockpitTypeID);
                IAttributeType attributeType = DataModelProvider.getAttributeTypeByHumanreadableID(attributeTypes, propertyTypeID);
                if (attributeType != null) {
                    IAttributeTypeDataType dataType = attributeType.getDataType();
                    if (dataType instanceof DataTypeEnumerationNEW) {
                        DataTypeEnumerationNEW enumDataType = (DataTypeEnumerationNEW)dataType;
                        ValueRangeDefinerEnumeration valueRangeHelper = enumDataType.getValueRangeHelper();
                        List valueRangeEntries = valueRangeHelper.getAllowedValues(attributeType.getValueRange());
                        ArrayList<String> values = new ArrayList<String>();
                        for (EnumerationEntry valueRangeEntry : valueRangeEntries) {
                            values.add(HTMLEncoder.encode((String)valueRangeEntry.getValue().toString()));
                        }
                        return values;
                    }
                    return null;
                }
                logger.error("Property " + propertyTypeID + " does not exist!");
                return Collections.singletonList(String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2"));
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return Collections.singletonList(NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID));
        }
        assert (false);
        return null;
    }

    @Override
    public List<String> getCategoryIDsForObjectType(String objectTypeID) {
        ObjectTypeCategoriesManager categoriesManager = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getObjectTypeCategoriesManager();
        if (categoriesManager != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                List allCategories = categoriesManager.getAllCategoriesForObjectTypeSorted(cockpitTypeID);
                ArrayList<String> listOfHumanReadableIDsOfCategories = new ArrayList<String>(allCategories.size());
                for (ObjectTypeCategory singleCategory : allCategories) {
                    listOfHumanReadableIDsOfCategories.add(singleCategory.getHumanReadableID());
                }
                return listOfHumanReadableIDsOfCategories;
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return Collections.singletonList(NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID));
        }
        assert (false);
        return null;
    }

    @Override
    public String getDisplaynameOfCategory(String objectTypeID, String categoryID) {
        if (categoryID != null) {
            ObjectTypeCategoriesManager categoriesManager = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getObjectTypeCategoriesManager();
            if (categoriesManager != null) {
                String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
                if (cockpitTypeID != null) {
                    ObjectTypeCategory foundCategory = categoriesManager.getCategoryByHumanreadableID(cockpitTypeID, categoryID);
                    if (foundCategory != null) {
                        return HTMLEncoder.encode((String)foundCategory.getDisplayName());
                    }
                    return HTMLEncoder.encode((String)NLS.bind((String)Messages.getString("DataModelProvider.UnknownCategory"), (Object)categoryID));
                }
                logger.error("Object type " + objectTypeID + " does not exist!");
                return HTMLEncoder.encode((String)NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID));
            }
            assert (false);
            return null;
        }
        return ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY;
    }

    @Override
    public String getIconOfCategory(String objectTypeID, String categoryID) {
        if (categoryID != null) {
            ObjectTypeCategoriesManager categoriesManager = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getObjectTypeCategoriesManager();
            if (categoriesManager != null) {
                String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
                if (cockpitTypeID != null) {
                    ObjectTypeCategory foundCategory = categoriesManager.getCategoryByHumanreadableID(cockpitTypeID, categoryID);
                    if (foundCategory != null) {
                        FileID fileID = foundCategory.getIcon();
                        if (fileID != null && !fileID.equals((Object)FileID.NO_FILE)) {
                            ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(this.reportContext.getProjectAgent().getProjectUID());
                            FileInReportDescription fileInReportDescription = this.reportContext.getGraphicsProvider().createFileObject(this.reportContext.getProjectAgent().getFileDataType(), fileID, (IFrameProjectAgent)projectAgent_);
                            return this.reportContext.getGraphicsProvider().getSnippetForFileInRawReportFormat(fileInReportDescription, 0.0, 0.0);
                        }
                        return "";
                    }
                    return HTMLEncoder.encode((String)NLS.bind((String)Messages.getString("DataModelProvider.UnknownCategory"), (Object)categoryID));
                }
                logger.error("Object type " + objectTypeID + " does not exist!");
                return HTMLEncoder.encode((String)NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID));
            }
            assert (false);
            return null;
        }
        return "";
    }

    @Override
    public boolean hasNonDefaultCategories(String objectTypeID) {
        ObjectTypeCategoriesManager categoriesManager = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getObjectTypeCategoriesManager();
        if (categoriesManager != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                return categoriesManager.hasObjectTypeCategories(cockpitTypeID);
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return false;
        }
        assert (false);
        return false;
    }

    @Override
    public boolean hasCategory(String objectTypeID, String categoryID) {
        if (categoryID == null) {
            return true;
        }
        ObjectTypeCategoriesManager categoriesManager = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getObjectTypeCategoriesManager();
        if (categoriesManager != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                if (DataModelProvider.isTypeSupportingCategories(cockpitTypeID)) {
                    return categoriesManager.getCategoryByHumanreadableID(cockpitTypeID, categoryID) != null;
                }
                return false;
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return false;
        }
        assert (false);
        return false;
    }

    @Override
    public List<String> getCustomPropertiesForObjectTypeCategory(String objectTypeID, String categoryID) {
        ObjectTypeCategoriesManager categoriesManager = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getObjectTypeCategoriesManager();
        if (categoriesManager != null) {
            String cockpitTypeID = DataModelProvider.translateReportObjectTypeID2CockpitTypeID(objectTypeID);
            if (cockpitTypeID != null) {
                if (categoryID != null && DataModelProvider.isTypeSupportingCategories(cockpitTypeID)) {
                    ObjectTypeCategory foundCategory = categoriesManager.getCategoryByHumanreadableID(cockpitTypeID, categoryID);
                    if (foundCategory != null) {
                        IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesProvider = ((IFrameProjectAgent)this.reportContext.getProjectAgent().getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
                        ArrayList<String> attributeIDsOfCategory = new ArrayList<String>(foundCategory.getAttributeList().size());
                        ArrayList<IAttributeType> attributeTypesOfCategory = new ArrayList<IAttributeType>(foundCategory.getAttributeList().size());
                        List allSortedAttributeTypes = userDefinedAttributeTypesProvider.getSortedAttributeTypes(cockpitTypeID);
                        for (IAttributeTypeID attributeID : foundCategory.getAttributeList()) {
                            IAttributeType attribute = userDefinedAttributeTypesProvider.getUserDefinedAttributeType(attributeID);
                            if (attribute == null) continue;
                            attributeTypesOfCategory.add(attribute);
                        }
                        allSortedAttributeTypes.retainAll(attributeTypesOfCategory);
                        for (IAttributeType singleAttributeType : allSortedAttributeTypes) {
                            attributeIDsOfCategory.add(singleAttributeType.getHumanReadableID());
                        }
                        return attributeIDsOfCategory;
                    }
                    return Collections.singletonList(NLS.bind((String)Messages.getString("DataModelProvider.UnknownCategory"), (Object)categoryID));
                }
                return this.getCustomPropertyIdsForObjectType(objectTypeID);
            }
            logger.error("Object type " + objectTypeID + " does not exist!");
            return Collections.singletonList(NLS.bind((String)Messages.getString("AbstractCockpitDataWrapper.unknown_objecttype"), (Object)objectTypeID));
        }
        assert (false);
        return null;
    }

    private static IAttributeType getAttributeTypeByHumanreadableID(Collection<IAttributeType> attributeTypes, String humanreadableID) {
        for (IAttributeType attributeType : attributeTypes) {
            if (!attributeType.getHumanReadableID().equals(humanreadableID)) continue;
            return attributeType;
        }
        return null;
    }

    private static boolean isTypeSupportingCategories(String cockpitTypeID) {
        for (ICockpitDataType cockpitType : FrameDataTypes.getDataTypesWithObjectTypeCategories()) {
            if (!cockpitType.getCockpitDataTypeID().equals(cockpitTypeID)) continue;
            return true;
        }
        return false;
    }

    private static String translateReportObjectTypeID2CockpitTypeID(String reportObjectTypeID) {
        if (reportObjectTypeID.equalsIgnoreCase("project")) {
            return "frame.project";
        }
        if (reportObjectTypeID.equalsIgnoreCase("folder")) {
            return "com.arcway.cockpit.section";
        }
        if (reportObjectTypeID.equalsIgnoreCase("plan")) {
            return "com.arcway.cockpit.plan";
        }
        if (reportObjectTypeID.equalsIgnoreCase("uniqueElement") || reportObjectTypeID.equalsIgnoreCase("modelElement")) {
            return "com.arcway.cockpit.uniqueelement";
        }
        if (reportObjectTypeID.equalsIgnoreCase("stakeholder")) {
            return "com.arcway.cockpit.stakeholder";
        }
        if (reportObjectTypeID.equalsIgnoreCase("stakeholderRole")) {
            return "com.arcway.cockpit.stakeholderrole";
        }
        if (reportObjectTypeID.equalsIgnoreCase("reportTemplateFolder")) {
            return FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER;
        }
        if (reportObjectTypeID.equalsIgnoreCase("reportTemplate")) {
            return FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE;
        }
        if (reportObjectTypeID.equalsIgnoreCase("reportOutputTemplate")) {
            return FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE;
        }
        if (reportObjectTypeID.equalsIgnoreCase("ucm.useCaseSet")) {
            return "ucm.category";
        }
        if (reportObjectTypeID.equalsIgnoreCase("ucm.useCase")) {
            return "ucm.useCase";
        }
        if (reportObjectTypeID.equalsIgnoreCase("ucm.scenario")) {
            return "ucm.Scenario";
        }
        if (reportObjectTypeID.equalsIgnoreCase("ucm.actionStep")) {
            return "ucm.ActionStep";
        }
        if (reportObjectTypeID.equalsIgnoreCase("dcm.documentContainerSet")) {
            return "dcm.category";
        }
        if (reportObjectTypeID.equalsIgnoreCase("dcm.documentContainer")) {
            return "dcm.documentcontainer";
        }
        if (reportObjectTypeID.equalsIgnoreCase("dcm.resourceLocator")) {
            return "";
        }
        if (reportObjectTypeID.equalsIgnoreCase("dcm.webLink")) {
            return "dcm.weblink";
        }
        if (reportObjectTypeID.equalsIgnoreCase("dcm.fileSystemLink")) {
            return "dcm.filesystemlink";
        }
        if (reportObjectTypeID.equalsIgnoreCase("ppm.projectPlan")) {
            return "ppm2.projectplan";
        }
        if (reportObjectTypeID.equalsIgnoreCase("ppm.task")) {
            return "ppm2.task";
        }
        if (reportObjectTypeID.equalsIgnoreCase("ppm.workItem")) {
            return "ppm2.workitem";
        }
        if (reportObjectTypeID.startsWith("gm.")) {
            String[] moduleIDAndObjectID = reportObjectTypeID.substring(3).split("\\.");
            return "com.arcway.cockpit.genericmodule." + moduleIDAndObjectID[0] + "." + moduleIDAndObjectID[1];
        }
        return null;
    }
}

