/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.ExtensionMgr;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.ConfiguredServerConnection;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.docgen.provider.RootDataProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredProject;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredServerConnection;
import com.arcway.cockpit.docgen.provider.interfaces.IPermission;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ConfiguredProject
implements IConfiguredProject {
    private static final ILogger logger = Logger.getLogger(ConfiguredProject.class);
    private final RootDataProvider rootDataProvider;
    private final IFrameProjectAgent frameProjectAgent;
    private IDocGeneratorProjectAgent docGenProjectAgent = null;
    private Map<String, IProjectRelatedReportProvider> projectRelatedReportDataProviders = null;
    private final IWorkbenchPage currentPage;

    public ConfiguredProject(RootDataProvider rootDataProvider, IFrameProjectAgent frameProjectAgent, IWorkbenchPage currentPage) {
        this.rootDataProvider = rootDataProvider;
        this.frameProjectAgent = frameProjectAgent;
        this.currentPage = currentPage;
    }

    public ConfiguredProject(RootDataProvider rootDataProvider, IDocGeneratorProjectAgent docGenProjectAgent, Map<String, IProjectRelatedReportProvider> projectRelatedReportDataProviders, IWorkbenchPage currentPage) {
        this.rootDataProvider = rootDataProvider;
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        this.frameProjectAgent = projectMgr.getProjectAgent(docGenProjectAgent.getProjectUID());
        if (this.frameProjectAgent == null) {
            throw new RuntimeException("Project " + docGenProjectAgent.getProjectName() + " (" + docGenProjectAgent.getProjectUID() + ") is unknown.");
        }
        this.docGenProjectAgent = docGenProjectAgent;
        this.projectRelatedReportDataProviders = projectRelatedReportDataProviders;
        this.currentPage = currentPage;
    }

    @Override
    public IConfiguredServerConnection getServerConnection() {
        String serverID = this.frameProjectAgent.getServerID();
        Map<String, IConfiguredServerConnection> configuredServerConnections = this.rootDataProvider.getConfiguredServerConnections();
        IConfiguredServerConnection serverConnection = configuredServerConnections.get(serverID);
        return serverConnection;
    }

    @Override
    public String getProjectUID() {
        return this.frameProjectAgent.getProjectUID();
    }

    @Override
    public String getProjectName() {
        return this.frameProjectAgent.getProjectName();
    }

    @Override
    public boolean isOpen() {
        return this.frameProjectAgent.isOpened();
    }

    @Override
    public boolean open() {
        boolean success;
        try {
            boolean triggerUserOnOpenActions = false;
            success = this.frameProjectAgent.open(false, triggerUserOnOpenActions, EclipseSWTHelper.getWorkbenchPage(null));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            success = false;
        }
        return success;
    }

    @Override
    public void close() {
        this.frameProjectAgent.close(null);
    }

    @Override
    public synchronized Map<String, IProjectRelatedReportProvider> getProjectRelatedReportDataProviders() {
        if (!this.isOpen()) {
            throw new RuntimeException("Project " + this.frameProjectAgent.getProjectName() + " (" + this.frameProjectAgent.getProjectUID() + ") is not open.");
        }
        if (this.docGenProjectAgent == null) {
            this.docGenProjectAgent = new DocGeneratorProjectAgent(this.frameProjectAgent);
        }
        if (this.projectRelatedReportDataProviders == null) {
            GraphicsAndFilesHelper graphicsAndFilesHelper = this.rootDataProvider.getGraphicsProvider();
            PresentationContext presentationContext = this.rootDataProvider.getPresentationContext();
            Map<String, Collection<AbstractFilter>> filterCollection = this.rootDataProvider.getFilterCollection();
            boolean includingGlobalProviders = false;
            this.projectRelatedReportDataProviders = ExtensionMgr.createProjectRelatedReportDataProviders(graphicsAndFilesHelper, filterCollection, presentationContext, this.docGenProjectAgent, includingGlobalProviders, this.currentPage);
        }
        return this.projectRelatedReportDataProviders;
    }

    @Override
    public Map<String, IProjectRelatedReportProvider> getProjectRelatedReportDataProvidersWithoutFilter() {
        if (!this.isOpen()) {
            throw new RuntimeException("Project " + this.frameProjectAgent.getProjectName() + " (" + this.frameProjectAgent.getProjectUID() + ") is not open.");
        }
        if (this.docGenProjectAgent == null) {
            this.docGenProjectAgent = new DocGeneratorProjectAgent(this.frameProjectAgent);
        }
        if (this.projectRelatedReportDataProviders == null) {
            GraphicsAndFilesHelper graphicsAndFilesHelper = this.rootDataProvider.getGraphicsProvider();
            PresentationContext presentationContext = this.rootDataProvider.getPresentationContext();
            Map<String, Collection<AbstractFilter>> filterCollection = Collections.emptyMap();
            boolean includingGlobalProviders = false;
            this.projectRelatedReportDataProviders = ExtensionMgr.createProjectRelatedReportDataProviders(graphicsAndFilesHelper, filterCollection, presentationContext, this.docGenProjectAgent, includingGlobalProviders, this.currentPage);
        }
        return this.projectRelatedReportDataProviders;
    }

    @Override
    public boolean hasChanges() {
        return this.frameProjectAgent.isOpened() && this.frameProjectAgent.getCommitMgr().areModificationsPresent();
    }

    @Override
    public boolean isCommittable() {
        return this.frameProjectAgent.isOpened() && this.frameProjectAgent.isCommitable() && this.frameProjectAgent.isInMemoryStateConsistent() && this.frameProjectAgent.getFrameServerProxy().concurrentWorkPossible() && this.frameProjectAgent.isDiskStateInSynchWithInMemoryState();
    }

    @Override
    public boolean commit(String modificationComment) {
        boolean success;
        if (!this.frameProjectAgent.isInMemoryStateConsistent() || this.frameProjectAgent.getFrameServerProxy().concurrentWorkPossible() && !this.frameProjectAgent.isDiskStateInSynchWithInMemoryState()) {
            throw new ReportDataProviderException("The client state is inconsistent or can not be saved permanently in the work space. In this condition, commiting the local changes is not possible.", true);
        }
        if (this.frameProjectAgent.isOpened()) {
            Shell shell = this.currentPage == null ? null : this.currentPage.getWorkbenchWindow().getShell();
            try {
                success = this.frameProjectAgent.commitProject(modificationComment, false, true, shell);
            }
            catch (Exception e) {
                String serverID = this.frameProjectAgent.getServerID();
                IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
                String descriptionOfConsequence = projectMgrServerProxy.getVersionDependendDescription("commitfailed");
                Throwable t = e instanceof ExPrematureEndOfTransfer && e.getCause() != null ? e.getCause() : e;
                throw new RuntimeException(descriptionOfConsequence, t);
            }
        } else {
            success = false;
        }
        return success;
    }

    @Override
    public void discard() {
        if (!this.frameProjectAgent.isInMemoryStateConsistent() || !this.frameProjectAgent.isDiskStateInSynchWithInMemoryState()) {
            throw new ReportDataProviderException("The client state is inconsistent or can not be saved permanently in the work space. In this condition, discarding the local changes is not possible.", true);
        }
        if (this.frameProjectAgent.isOpened()) {
            IProjectManagerServerProxy projectManagerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.frameProjectAgent.getServerID());
            try {
                projectManagerServerProxy.reloadProject(this.frameProjectAgent, false, this.currentPage, false);
                this.projectRelatedReportDataProviders = null;
            }
            catch (Exception e) {
                String serverID = this.frameProjectAgent.getServerID();
                IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
                String humanReadableDescriptionOfConsequence = projectMgrServerProxy.getVersionDependendDescription("reloadfailed");
                throw new RuntimeException(humanReadableDescriptionOfConsequence, e);
            }
        } else {
            throw new RuntimeException("Cannot discard changes as project " + this.getProjectName() + " is not open.");
        }
    }

    @Override
    public void deleteFromClient() {
        if (this.hasChanges()) {
            throw new RuntimeException("Cannot delete project " + this.getProjectUID() + " / " + this.getProjectName() + " from client: Project has local modificatoins.");
        }
        boolean askUser = false;
        IWorkbenchWindow workbenchWindow = this.currentPage == null ? null : this.currentPage.getWorkbenchWindow();
        Shell parentShell = workbenchWindow == null ? null : workbenchWindow.getShell();
        ProjectMgr.getProjectMgr().deleteProjectOnClient(this.frameProjectAgent, askUser, parentShell);
    }

    @Deprecated
    public Collection<IPermission> getServerPermissions() {
        return this.getProjectPermissions();
    }

    @Override
    public Collection<IPermission> getProjectPermissions() {
        IFrameServerProxy frameServerProxy = this.frameProjectAgent.getFrameServerProxy();
        List eoPermissions = frameServerProxy.getAllPermissions();
        Collection<IPermission> permissions = ConfiguredServerConnection.convertPermissions(eoPermissions);
        return permissions;
    }
}

