/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.core.ProjectRelatedReportContext;
import com.arcway.cockpit.docgen.core.ReportRelatedReportContext;
import com.arcway.cockpit.docgen.core.ReportTemplateRelatedReportContext;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.IReportTemplateRelatedReportProvider;
import com.arcway.cockpit.docgen.writer.IDocumentationWriter;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.extensiontemplates.IBuiltInReportOutputTemplate;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.extensiontemplates.IBuiltInReportTemplate;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.extensiontemplates.IReportTemplateProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationItem;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbenchPage;

public class ExtensionMgr {
    private static final ILogger logger = Logger.getLogger(ExtensionMgr.class);
    private static IExtensionRegistry registry = Platform.getExtensionRegistry();
    private static final String DOCUMENTATION_WRITER_EXTENSION_POINT_ID = "DocGenDocumentationWriter";
    private static final String DOCGEN_WRITER_ELEMENT_NAME = "DocumentationWriter";
    private static final String DOCGEN_WRITER_ATTRIBUTE = "DocumentationWriter";
    private static final String REPORT_DATA_PROVIDER_EXTENSION_POINT_ID = "ReportDataProvider";
    private static final String REPORT_DATA_PROVIDER_REPORT_RELATED_ELEMENT = "ReportRelatedReportDataProvider";
    private static final String REPORT_DATA_PROVIDER_REPORT_TEMPLATE_RELATED_ELEMENT = "ReportTemplateRelatedReportDataProvider";
    private static final String REPORT_DATA_PROVIDER_PROJECT_RELATED_ELEMENT = "ProjectRelatedReportDataProvider";
    private static final String REPORT_DATA_PROVIDER_POTENTIONALLY_PROJECT_RELATED_ELEMENT = "PotentionallyProjectRelatedReportDataProvider";
    private static final String REPORT_DATA_PROVIDER_ATTRIBUTE = "provider";
    private static final String REPORT_DATA_PROVIDER_CONTEXT_ATTRIBUTE = "contextKey";
    private static final String REPORT_TEMPLATE_PROVIDER_EXTENSION_POINT_ID = "ReportTemplateProvider";
    private static final String REPORT_TEMPLATE_PROVIDER_ELEMENT = "ReportTemplateProvider";
    private static final String REPORT_TEMPLATE_PROVIDER_ATTRIBUTE = "class";
    private static Map<String, IDocumentationWriter> documentationWriters = null;
    private static ListMap<Locale, IReportTemplate> reportTemplates = null;
    private static Map<String, ListMap<Locale, IReportOutputTemplate>> reportOutputTemplates = null;

    public static List<IDocumentationWriter> getDocumentationWriters() {
        if (documentationWriters == null) {
            ExtensionMgr.readDocumentationWriterExtensions();
        }
        return new ArrayList<IDocumentationWriter>(documentationWriters.values());
    }

    public static IDocumentationWriter getDocumentationWriter(String id) {
        if (documentationWriters == null) {
            ExtensionMgr.readDocumentationWriterExtensions();
        }
        return documentationWriters.get(id);
    }

    public static HashMap<String, IReportRelatedReportProvider> createReportRelatedReportDataProviders(Map<String, Collection<AbstractFilter>> filters, PresentationContext presentationContext, GraphicsAndFilesHelper graphicsProvider, boolean includingGlobalProviders, IWorkbenchPage currentPage) {
        IExtension[] extensions;
        ReportRelatedReportContext reportContext = new ReportRelatedReportContext(filters, presentationContext, graphicsProvider, currentPage);
        HashMap<String, IReportRelatedReportProvider> reportRelatedReportDataProvider = new HashMap<String, IReportRelatedReportProvider>();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.cockpit.docgen", REPORT_DATA_PROVIDER_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (REPORT_DATA_PROVIDER_REPORT_RELATED_ELEMENT.equals(currentConfigElement.getName()) || includingGlobalProviders && REPORT_DATA_PROVIDER_POTENTIONALLY_PROJECT_RELATED_ELEMENT.equals(currentConfigElement.getName())) {
                    try {
                        String contextKey = currentConfigElement.getAttribute(REPORT_DATA_PROVIDER_CONTEXT_ATTRIBUTE);
                        IReportRelatedReportProvider reportProvider = (IReportRelatedReportProvider)currentConfigElement.createExecutableExtension(REPORT_DATA_PROVIDER_ATTRIBUTE);
                        reportProvider.setup(reportContext);
                        reportRelatedReportDataProvider.put(contextKey, reportProvider);
                    }
                    catch (CoreException e) {
                        logger.error("Unable to instantiate registered Report data provider", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return new HashMap<String, IReportRelatedReportProvider>(reportRelatedReportDataProvider);
    }

    public static HashMap<String, IReportTemplateRelatedReportProvider> createReportTemplateRelatedReportDataProviders(DocGenConfigurationItem velocityConfigurationItem, Map<String, Collection<AbstractFilter>> filters, PresentationContext presentationContext, GraphicsAndFilesHelper graphicsProvider, IWorkbenchPage currentPage) {
        IExtension[] extensions;
        ReportTemplateRelatedReportContext reportContext = new ReportTemplateRelatedReportContext(velocityConfigurationItem, filters, presentationContext, graphicsProvider, currentPage);
        HashMap<String, IReportTemplateRelatedReportProvider> reportTemplateRelatedReportDataProvider = new HashMap<String, IReportTemplateRelatedReportProvider>();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.cockpit.docgen", REPORT_DATA_PROVIDER_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (REPORT_DATA_PROVIDER_REPORT_TEMPLATE_RELATED_ELEMENT.equals(currentConfigElement.getName())) {
                    try {
                        String contextKey = currentConfigElement.getAttribute(REPORT_DATA_PROVIDER_CONTEXT_ATTRIBUTE);
                        IReportTemplateRelatedReportProvider reportProvider = (IReportTemplateRelatedReportProvider)currentConfigElement.createExecutableExtension(REPORT_DATA_PROVIDER_ATTRIBUTE);
                        reportProvider.setup(reportContext);
                        reportTemplateRelatedReportDataProvider.put(contextKey, reportProvider);
                    }
                    catch (CoreException e) {
                        logger.error("Unable to instantiate registered Report data provider", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return new HashMap<String, IReportTemplateRelatedReportProvider>(reportTemplateRelatedReportDataProvider);
    }

    public static HashMap<String, IProjectRelatedReportProvider> createProjectRelatedReportDataProviders(GraphicsAndFilesHelper graphicsProvider, Map<String, Collection<AbstractFilter>> filters, PresentationContext presentationContext, IDocGeneratorProjectAgent projectAgent, boolean includingGlobalProviders, IWorkbenchPage currentPage) {
        IExtension[] extensions;
        ProjectRelatedReportContext reportContext = new ProjectRelatedReportContext(graphicsProvider, filters, presentationContext, projectAgent, currentPage);
        HashMap<String, IProjectRelatedReportProvider> projectRelatedReportDataProvider = new HashMap<String, IProjectRelatedReportProvider>();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.cockpit.docgen", REPORT_DATA_PROVIDER_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (REPORT_DATA_PROVIDER_PROJECT_RELATED_ELEMENT.equals(currentConfigElement.getName()) || includingGlobalProviders && REPORT_DATA_PROVIDER_POTENTIONALLY_PROJECT_RELATED_ELEMENT.equals(currentConfigElement.getName())) {
                    try {
                        String contextKey = currentConfigElement.getAttribute(REPORT_DATA_PROVIDER_CONTEXT_ATTRIBUTE);
                        IProjectRelatedReportProvider reportProvider = (IProjectRelatedReportProvider)currentConfigElement.createExecutableExtension(REPORT_DATA_PROVIDER_ATTRIBUTE);
                        reportProvider.setup(reportContext);
                        projectRelatedReportDataProvider.put(contextKey, reportProvider);
                    }
                    catch (CoreException e) {
                        logger.error("Unable to instantiate registered Report data provider", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        HashMap<String, IProjectRelatedReportProvider> projectRelatedReportDataProviders = new HashMap<String, IProjectRelatedReportProvider>(projectRelatedReportDataProvider);
        reportContext.setup(projectRelatedReportDataProviders);
        return projectRelatedReportDataProviders;
    }

    public static List<IReportTemplate> getReportTemplates(Locale locale) {
        if (reportTemplates == null) {
            ExtensionMgr.readTemplateProviderExtensions();
        }
        return new ArrayList<IReportTemplate>(reportTemplates.get((Object)locale));
    }

    public static List<IReportOutputTemplate> getReportOutputTemplates(String outputTemplateTypeID, Locale locale) {
        ListMap<Locale, IReportOutputTemplate> outputTemplatesOfType;
        if (reportOutputTemplates == null) {
            ExtensionMgr.readTemplateProviderExtensions();
        }
        if ((outputTemplatesOfType = reportOutputTemplates.get(outputTemplateTypeID)) != null) {
            return new ArrayList<IReportOutputTemplate>(outputTemplatesOfType.get((Object)locale));
        }
        return Collections.emptyList();
    }

    private static void readDocumentationWriterExtensions() {
        IExtension[] extensions;
        documentationWriters = new HashMap<String, IDocumentationWriter>();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.cockpit.docgen", DOCUMENTATION_WRITER_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if ("DocumentationWriter".equals(currentConfigElement.getName())) {
                    try {
                        IDocumentationWriter writer = (IDocumentationWriter)currentConfigElement.createExecutableExtension("DocumentationWriter");
                        documentationWriters.put(writer.getID(), writer);
                    }
                    catch (CoreException e) {
                        logger.error("Unable to create registered Documentation Writer Extension", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void readTemplateProviderExtensions() {
        reportTemplates = new ListMap();
        reportOutputTemplates = new HashMap<String, ListMap<Locale, IReportOutputTemplate>>();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.cockpit.docgen", "ReportTemplateProvider");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = currentExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if ("ReportTemplateProvider".equals(currentConfigElement.getName())) {
                    try {
                        IReportTemplateProvider templateProvider = (IReportTemplateProvider)currentConfigElement.createExecutableExtension(REPORT_TEMPLATE_PROVIDER_ATTRIBUTE);
                        for (IBuiltInReportTemplate reportTemplate : templateProvider.getReportTemplates()) {
                            reportTemplates.add((Object)reportTemplate.getLanguage(), (Object)reportTemplate);
                        }
                        for (IBuiltInReportOutputTemplate reportOutputTemplate : templateProvider.getOutputTemplates()) {
                            ListMap outputTemplatesOfType = reportOutputTemplates.get(reportOutputTemplate.getReportOutputTemplateTypeID());
                            if (outputTemplatesOfType == null) {
                                outputTemplatesOfType = new ListMap();
                                reportOutputTemplates.put(reportOutputTemplate.getReportOutputTemplateTypeID(), (ListMap<Locale, IReportOutputTemplate>)outputTemplatesOfType);
                            }
                            outputTemplatesOfType.add((Object)reportOutputTemplate.getLanguage(), (Object)reportOutputTemplate);
                        }
                    }
                    catch (CoreException e) {
                        logger.error("Unable to instantiate registered report template provider", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

