/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.html;

import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.docbook.AbstractDocBookDocumentationWriter;
import com.arcway.cockpit.docgen.writer.html.DocBook2HTMLTransformator;
import com.arcway.cockpit.docgen.writer.html.Messages;
import com.arcway.cockpit.docgen.writer.html.ModulePlugin;
import com.arcway.cockpit.docgen.writer.html.preferences.IDocBook2HTMLConfigurator;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.platformurl.PlatformURLHelper;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.HTMLEncoder;
import de.plans.lib.xml.encoding.EXEncoderException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;

public class AbstractHTMLDocumentationWriter
extends AbstractDocBookDocumentationWriter {
    private static final ILogger logger = Logger.getLogger(AbstractHTMLDocumentationWriter.class);
    private static final double HTML_DPI = 192.0;
    private static final int PREFERRED_IMAGE_SIZE = 2400;
    public static final String MAIN_HTML_FILENAME = "index.html";
    public static final String JUMP_HTML_FILENAME = "jump.html";
    private static final String FILES_AND_IMAGES_DIRECTORY_NAME = "files_and_images";
    public static final String STYLESHEET_TARGET_FILENAME = "default.css";
    private static final Set<String> imageFileTypes = new HashSet<String>();
    private final IDocBook2HTMLConfigurator configurator;

    public AbstractHTMLDocumentationWriter(IDocBook2HTMLConfigurator configurator) {
        super(true, false);
        imageFileTypes.add("PNG");
        imageFileTypes.add("GIF");
        imageFileTypes.add("JPG");
        imageFileTypes.add("JPEG");
        imageFileTypes.add("BMP");
        imageFileTypes.add("SVG");
        this.configurator = configurator;
    }

    public String getID() {
        return this.configurator.getFormatID();
    }

    public String getDisplayName() {
        return this.configurator.getDisplayName();
    }

    public String getDescription() {
        return this.configurator.getDescription();
    }

    public String getRequiredOutputTemplateTypeID() {
        return this.configurator.getRequiredOutputTemplateTypeID();
    }

    public String getOutputFormat(IReportTemplate reportTemplate) {
        return this.configurator.getOutputFormat(reportTemplate);
    }

    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInPixel((Dimension)new Dimension(2400.0, 2400.0), (double)192.0);
    }

    public String getPreferredImageType() {
        String format = this.configurator.getSelectedImageFormat();
        if (format == null || format.length() == 0) {
            logger.debug("No image format preference for html available - default value used");
            format = ".svg";
        }
        return format;
    }

    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        try {
            if (imageFileTypes.contains(format.toUpperCase())) {
                return this.getDocBookSnippetForEmbeddedMediaObject("files_and_images/" + fileName, displayName, format, width_mm, height_mm, true);
            }
            return this.getDocBookSnippetForExternalFileLink("files_and_images/" + fileName, HTMLEncoder.encode((String)displayName));
        }
        catch (EXEncoderException e) {
            throw e.toNewRuntimeException("Unable to create DocBookSnippetForExternalFileLink.");
        }
    }

    protected void postProcessWithProgress(VelocityReportJob reportJob, IWorkbenchPage workbenchPage, IProgressMonitor progressMonitor) throws ReportGenerationException {
        if (progressMonitor != null) {
            progressMonitor.beginTask(Messages.getString("DocumentationWriter.4"), -1);
        }
        this.copyGraphicsAndFilesToTargetLocation(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
        if (logger.isDebugEnabled()) {
            logger.debug("createDocument() - Construction plan images were created and saved into the image directory");
        }
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(this.configurator.getBeginGenerationTaskText(), -1);
                progressMonitor.subTask(this.configurator.getBeginGenerationSubTaskText());
            }
            File reportDir = new File(reportJob.getBaseReportJob().getReportFilename());
            File mainTargetFile = new File(reportDir, MAIN_HTML_FILENAME);
            reportJob.getBaseReportJob().setReportMainFileName(mainTargetFile.getAbsolutePath());
            SessionTempDirectoryManager.SessionTempDirectory dcb2HtmTempDir = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"dcb2htm");
            DocBook2HTMLTransformator docGen = new DocBook2HTMLTransformator(this.configurator);
            docGen.convert(reportJob.getRawReportFile(), (File)dcb2HtmTempDir);
            Collection createdCopies = FileHelper.copyDirectoryContent((File)dcb2HtmTempDir, (File)reportDir, (IFileValidator)new IFileValidator(){

                public boolean isValid(File file) {
                    return true;
                }
            });
            reportJob.getBaseReportJob().registerReportResultFiles(createdCopies);
            File[] htmlFiles = dcb2HtmTempDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getAbsolutePath().endsWith(".html");
                }
            });
            Map<String, List<String>> anchorOccurences = AbstractHTMLDocumentationWriter.assembleGlobalAnchorIndex(htmlFiles);
            Collection<File> createdIndexFiles = this.generateJsAnchorIndexFiles(anchorOccurences, reportDir);
            reportJob.getBaseReportJob().registerReportResultFiles(createdIndexFiles);
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("HTMLDocumentationWriter.PostProcessingFailed.Title"), Messages.getString("HTMLDocumentationWriter.PostProcessingFailed.Message"), (Throwable)e);
        }
        if (progressMonitor != null) {
            progressMonitor.subTask(Messages.getString("DocumentationWriter.3"));
        }
        this.copyAdditionalFileToTargetLocation(reportJob, reportJob.getBaseReportJob().getOutputTemplateFile(), STYLESHEET_TARGET_FILENAME);
        if (logger.isDebugEnabled()) {
            logger.debug("createDocument() - Stylesheet file successfully copied");
        }
    }

    private static Map<String, List<String>> assembleGlobalAnchorIndex(File[] htmlFiles) throws JvmExternalResourceInteractionException {
        Pattern startTagAPattern = Pattern.compile("<[ \\t]*a\\s");
        Pattern nameIntroPattern = Pattern.compile("name\\s*=\\s*\"");
        HashMap<String, List<String>> anchorOccurences = new HashMap<String, List<String>>();
        File[] fileArray = htmlFiles;
        int n = htmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File htmlFile = fileArray[n2];
            long length = htmlFile.length();
            if (length > 0x3200000L) {
                logger.warn("Trying to create an index for a unusual large HTML File of " + length + " bytes. This may cause problems.");
            }
            String htmlFileName = htmlFile.getName();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)length);
            DataCopyHelper.copyFile((File)htmlFile, (OutputStream)byteArrayOutputStream, (boolean)true);
            String htmlString = byteArrayOutputStream.toString();
            String[] htmlFractions = startTagAPattern.split(htmlString);
            int i = 1;
            while (i < htmlFractions.length) {
                String fraction = htmlFractions[i];
                int gtIndex = fraction.indexOf(">");
                if (gtIndex != -1) {
                    String substring = fraction.substring(0, gtIndex);
                    String[] split = nameIntroPattern.split(substring);
                    if (split.length == 2 || split.length == 1 && split[0].length() < substring.length()) {
                        int endDoubleQuotePos = split[1].indexOf(34);
                        if (endDoubleQuotePos > 0) {
                            String anchorName = new String(split[1].substring(0, endDoubleQuotePos));
                            ArrayList<String> occurences = (ArrayList<String>)anchorOccurences.get(anchorName);
                            if (occurences == null) {
                                occurences = new ArrayList<String>(1);
                                anchorOccurences.put(anchorName, occurences);
                            }
                            occurences.add(htmlFileName);
                        } else assert (false);
                    }
                } else assert (false);
                ++i;
            }
            ++n2;
        }
        return anchorOccurences;
    }

    private void debugPrintGlobalAnchorIndex(Map<String, List<String>> anchorOccurences) {
        Map.Entry[] anchorOccurencesArray = anchorOccurences.entrySet().toArray(new Map.Entry[anchorOccurences.size()]);
        Arrays.sort(anchorOccurencesArray, new Comparator<Map.Entry<String, List<String>>>(){

            @Override
            public int compare(Map.Entry<String, List<String>> o1, Map.Entry<String, List<String>> o2) {
                int result = o1.getValue().size() - o2.getValue().size();
                if (result == 0) {
                    result = o1.getKey().compareTo(o2.getKey());
                }
                return result;
            }
        });
        System.out.println();
        System.out.println("Found " + anchorOccurencesArray.length + " anchors:");
        Map.Entry[] entryArray = anchorOccurencesArray;
        int n = anchorOccurencesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry anchorOccurencesEntry = entryArray[n2];
            StringBuilder reportline = new StringBuilder();
            reportline.append(((List)anchorOccurencesEntry.getValue()).size());
            reportline.append(", ");
            reportline.append((String)anchorOccurencesEntry.getKey());
            reportline.append(", ");
            boolean isFirst = true;
            for (String htmlFileName : (List)anchorOccurencesEntry.getValue()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    reportline.append("; ");
                }
                reportline.append(htmlFileName);
            }
            System.out.println(reportline.toString());
            ++n2;
        }
    }

    private Collection<File> generateJsAnchorIndexFiles(Map<String, List<String>> anchorOccurences, File reportTargetDir) throws JvmExternalResourceInteractionException, IOException {
        String urlencodingUTF8 = "UTF-8";
        Pattern PlusPattern = Pattern.compile("\\+");
        String P20 = "%20";
        HashMap partitionedAnchorIndex = new HashMap();
        int numPartitions = 256;
        int initialPartitionMapCapacity = Math.max(16, 2 * (anchorOccurences.size() / 256));
        int i = 0;
        while (i < 256) {
            partitionedAnchorIndex.put(this.get2HexDigitsForUnsignedByteValue(i), new HashMap(initialPartitionMapCapacity));
            ++i;
        }
        HashSet<String> ambiguousAnchorNames = new HashSet<String>();
        for (Map.Entry<String, List<String>> anchorOccurencesEntry : anchorOccurences.entrySet()) {
            String[] anchorNameEncodings;
            int size = anchorOccurencesEntry.getValue().size();
            String urlencodedAnchorNameLowerCase1 = URLEncoder.encode(anchorOccurencesEntry.getKey(), "UTF-8").toLowerCase();
            if (urlencodedAnchorNameLowerCase1.indexOf(43) == -1) {
                anchorNameEncodings = new String[]{urlencodedAnchorNameLowerCase1};
            } else {
                String urlencodedAnchorNameLowerCase2 = PlusPattern.matcher(urlencodedAnchorNameLowerCase1).replaceAll("%20");
                anchorNameEncodings = new String[]{urlencodedAnchorNameLowerCase1, urlencodedAnchorNameLowerCase2};
            }
            String[] stringArray = anchorNameEncodings;
            int n = anchorNameEncodings.length;
            int n2 = 0;
            while (n2 < n) {
                String urlencodedAnchorNameLowerCase = stringArray[n2];
                if (size == 1) {
                    Map.Entry<String, List<String>> replacedEntry;
                    String jsAnchorHashcode = this.calulate2HexDigitsAnchorHashcode(urlencodedAnchorNameLowerCase);
                    HashMap partitionMap = (HashMap)partitionedAnchorIndex.get(jsAnchorHashcode);
                    if (!ambiguousAnchorNames.contains(urlencodedAnchorNameLowerCase) && (replacedEntry = partitionMap.put(urlencodedAnchorNameLowerCase, anchorOccurencesEntry)) != null) {
                        partitionMap.remove(urlencodedAnchorNameLowerCase);
                        ambiguousAnchorNames.add(urlencodedAnchorNameLowerCase);
                    }
                } else if (size > 1) {
                    ambiguousAnchorNames.add(urlencodedAnchorNameLowerCase);
                } else assert (false);
                ++n2;
            }
        }
        if (!ambiguousAnchorNames.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Ambiguous anchor names found (after converting all anchor names to lower case). These anchors will not be included in the global index: ");
            boolean isFirst = true;
            for (String anchorNameLowerCase : ambiguousAnchorNames) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    messageBuilder.append(", ");
                }
                messageBuilder.append(anchorNameLowerCase);
            }
            messageBuilder.append(".");
            logger.debug(messageBuilder.toString());
        }
        String indexFileEncoding = "UTF-8";
        ArrayList<File> createdFilesAndDirectories = new ArrayList<File>(300);
        File jsDir = new File(reportTargetDir, "js");
        File dataDir = new File(jsDir, "data");
        File anchorIndicesDir = new File(dataDir, "anchorIndices");
        createdFilesAndDirectories.addAll(FileHelper.ensureDirectoryExistance((File)anchorIndicesDir));
        for (Map.Entry partitionedAnchorIndexEntry : partitionedAnchorIndex.entrySet()) {
            File anchorIndexFile = new File(anchorIndicesDir, "anchorIndex" + (String)partitionedAnchorIndexEntry.getKey() + ".xml");
            try (OutputStream outputStream = FileHelper.fileToOutputStream((File)anchorIndexFile);){
                createdFilesAndDirectories.add(anchorIndexFile);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                outputStreamWriter.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
                outputStreamWriter.append("<anchorindex>\n");
                outputStreamWriter.append("<![CDATA[\n");
                for (Map.Entry anchorIndexEntry : ((HashMap)partitionedAnchorIndexEntry.getValue()).entrySet()) {
                    String encodedAnchorName = PlusPattern.matcher(URLEncoder.encode((String)((Map.Entry)anchorIndexEntry.getValue()).getKey(), "UTF-8")).replaceAll("%20");
                    outputStreamWriter.write("\t{");
                    outputStreamWriter.write((String)anchorIndexEntry.getKey());
                    outputStreamWriter.write("}/");
                    outputStreamWriter.write((String)((List)((Map.Entry)anchorIndexEntry.getValue()).getValue()).get(0));
                    outputStreamWriter.write("#");
                    outputStreamWriter.write(encodedAnchorName);
                    outputStreamWriter.write(";\n");
                }
                outputStreamWriter.append("]]>\n");
                outputStreamWriter.append("</anchorindex>");
                outputStreamWriter.flush();
            }
        }
        String bundleSymbolicName = ModulePlugin.getDefault().getBundle().getSymbolicName();
        URL cockpitIndexJsSourceURL = PlatformURLHelper.createPlatformPluginURL((String)bundleSymbolicName, (String)"htmlindex/js/cockpit-index.js");
        File cockpitIndexJsFile = new File(jsDir, "cockpit-index.js");
        DataCopyHelper.copyFile((InputStream)cockpitIndexJsSourceURL.openStream(), (File)cockpitIndexJsFile);
        createdFilesAndDirectories.add(cockpitIndexJsFile);
        URL indexHtml = PlatformURLHelper.createPlatformPluginURL((String)bundleSymbolicName, (String)"htmlindex/jump.html");
        File indexHtmlFile = new File(reportTargetDir, JUMP_HTML_FILENAME);
        DataCopyHelper.copyFile((InputStream)indexHtml.openStream(), (File)indexHtmlFile);
        createdFilesAndDirectories.add(indexHtmlFile);
        return createdFilesAndDirectories;
    }

    private String calulate2HexDigitsAnchorHashcode(String anchorname) {
        String anchornameLowerCase = anchorname.toLowerCase();
        int anchorHashcode = 0;
        int i = 0;
        while (i < anchornameLowerCase.length()) {
            char charCodeAtI = anchornameLowerCase.charAt(i);
            anchorHashcode *= 3;
            anchorHashcode = charCodeAtI > '/' && charCodeAtI < ':' ? (anchorHashcode += charCodeAtI) : (charCodeAtI > '`' && charCodeAtI < '{' ? (anchorHashcode += charCodeAtI) : ++anchorHashcode);
            anchorHashcode %= 256;
            ++i;
        }
        return this.get2HexDigitsForUnsignedByteValue(anchorHashcode);
    }

    private String get2HexDigitsForUnsignedByteValue(int unsignedByteValue) {
        assert (unsignedByteValue >= 0);
        assert (unsignedByteValue < 256);
        String HexDigits = "0123456789ABCDEF";
        return new String(new char[]{HexDigits.charAt(unsignedByteValue / 16 % 16), HexDigits.charAt(unsignedByteValue % 16)});
    }

    protected void postprocessingInterrupted(VelocityReportJob reportJob) {
        this.cleanUpAdditionalDirectory(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
        this.cleanUpAdditionalFile(reportJob, STYLESHEET_TARGET_FILENAME);
        this.cleanUpReportFile(reportJob);
    }

    public IClientFunctionLicenseType getNeededLicenseType() {
        return this.configurator.getNeededLicenseType();
    }
}

