/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.analyse.gui.views.analyseview;

import com.arcway.cockpit.docgen.writer.analyse.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportPerformer;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXInvalidParameter;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXProjectNotOpen;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXProjectUnknown;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXUnknownAction;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXUnknownObject;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITEclipseClientController;
import com.arcway.lib.eclipse.gui.print.PrintSWTControlAction;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.HTMLEncoder;
import java.io.File;
import java.net.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.ImageResource;
import org.eclipse.ui.part.ViewPart;

public class AnalyseView
extends ViewPart {
    public static final String VIEW_ID = "com.arcway.cockpit.docgen.writer.analyseview";
    private Browser browser;
    private Action refreshAction;
    private PrintSWTControlAction printAction;
    private IReportParameters reportParametersOfLastShownContent;

    public void showReportResult(IReportParameters reportParameters, File indexFile) {
        this.reportParametersOfLastShownContent = reportParameters;
        this.updateRefreshAction();
        this.showReportResult(indexFile);
    }

    public void showErrorResult(IReportParameters reportParameters, ReportGenerationException rge) {
        this.reportParametersOfLastShownContent = reportParameters;
        this.updateRefreshAction();
        String message = String.valueOf(rge.getTitle()) + " " + rge.getLocalizedMessage();
        Object e = rge;
        Throwable cause = ((Throwable)e).getCause();
        while (cause != null && e != cause) {
            e = cause;
            cause = ((Throwable)e).getCause();
            message = String.valueOf(message) + " " + ((Throwable)e).getLocalizedMessage();
        }
        this.showMessage(message);
    }

    private void updateRefreshAction() {
        this.refreshAction.setEnabled(this.reportParametersOfLastShownContent != null);
    }

    private void showReportResult(File indexFile) {
        this.navigate(indexFile.getAbsolutePath());
    }

    public void init(IViewSite site, IMemento newMemento) throws PartInitException {
        super.init(site, newMemento);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 4);
        this.createAdditionalToolbarActions(parent);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                URI uri = URI.create(event.location);
                if (ICOCKPITEclipseClientController.INSTANCE.isCockpitURI(uri)) {
                    event.doit = false;
                    try {
                        ICOCKPITEclipseClientController.INSTANCE.processURI(uri);
                    }
                    catch (EXProjectUnknown e) {
                        MessageDialog.openError((Shell)AnalyseView.this.browser.getShell(), (String)Messages.getString("AnalyseView.CouldNotShowObject"), (String)Messages.getString("AnalyseView.ProjectIsUnknown"));
                    }
                    catch (EXProjectNotOpen e) {
                        MessageDialog.openError((Shell)AnalyseView.this.browser.getShell(), (String)Messages.getString("AnalyseView.CouldNotShowObject"), (String)Messages.getString("AnalyseView.ProjectIsClosed"));
                    }
                    catch (EXUnknownObject e) {
                        MessageDialog.openError((Shell)AnalyseView.this.browser.getShell(), (String)Messages.getString("AnalyseView.CouldNotShowObject"), (String)Messages.getString("AnalyseView.ObjectIsUnknown"));
                    }
                    catch (EXUnknownAction e) {
                        MessageDialog.openError((Shell)AnalyseView.this.browser.getShell(), (String)Messages.getString("AnalyseView.CouldNotShowObject"), (String)Messages.getString("AnalyseView.ActionIsUnknown"));
                    }
                    catch (EXInvalidParameter e) {
                        MessageDialog.openError((Shell)AnalyseView.this.browser.getShell(), (String)Messages.getString("AnalyseView.CouldNotShowObject"), (String)Messages.getString("AnalyseView.ParameterIsInvalid"));
                    }
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.browser, "com.arcway.cockpit.frame.help.analyse_view_index");
    }

    private void createAdditionalToolbarActions(Composite parent) {
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new GroupMarker("additions"));
        this.refreshAction = new Action(){

            public void run() {
                AnalyseView.this.refresh();
            }
        };
        this.getViewSite().getActionBars().getToolBarManager().prependToGroup("additions", (IAction)this.refreshAction);
        this.refreshAction.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_REFRESH"));
        this.refreshAction.setToolTipText(Messages.getString("AnalyseView.refresh"));
        this.updateRefreshAction();
        this.printAction = new PrintSWTControlAction();
        this.printAction.setSWTControl((Control)this.browser);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.printAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public void refresh() {
        IReportPerformer reportPerformer = IReportPerformer.GLOBAL_REPORT_PERFOMER;
        if (this.browser != null) {
            String reportFileName = null;
            IModificationProblem modificationProblem = reportPerformer.canPerformReport(this.reportParametersOfLastShownContent, reportFileName);
            if (modificationProblem == null) {
                try {
                    IWorkbenchPage workbenchPage = this.getViewSite().getPage();
                    File resultFile = reportPerformer.performReport(workbenchPage, this.reportParametersOfLastShownContent, reportFileName);
                    if (resultFile != null) {
                        this.showReportResult(resultFile);
                    }
                }
                catch (ReportGenerationException e) {
                    this.showMessage(e.getLocalizedMessage());
                }
                this.browser.refresh();
            } else {
                this.showMessage(String.valueOf(modificationProblem.getHumanReadableDescriptionOfConsequence()) + " " + modificationProblem.getHumanReadableDescriptionOfCause());
            }
        }
    }

    private void showMessage(String message) {
        this.browser.setText("<html><body>" + HTMLEncoder.encode((String)message) + "</body></html>");
    }

    private void navigate(String url) {
        if (this.browser != null) {
            if (url.equals(this.browser.getUrl())) {
                this.browser.refresh();
            } else {
                this.browser.setUrl(url, null, new String[]{"Cache-Control: no-cache"});
            }
        }
    }
}

