/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.dom;

import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.EmphasisWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IEmphasisParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IMediaObjectParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IPhraseParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IUlinkParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ImageObjectWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.MediaObjectWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.PhraseWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.TableWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.UlinkWrapper;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ParagraphWrapper
implements IAnchorParent,
ILinkParent,
ISimpleListParent,
IUlinkParent,
IEmphasisParent,
IMediaObjectParent,
ITableParent,
IPhraseParent {
    private final Node paragraph;
    private final Document document;
    private Node paragraphR = null;
    private Node paragraphT = null;
    private Node paragraphPr = null;
    private final Locale projectLocale;
    private final StyleMap styleMap;

    public ParagraphWrapper(Document document, Node parent, String style, StyleMap styleMap, Locale projectLocale) {
        this.document = document;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
        Element paragraph_ = document.createElement("w:p");
        this.paragraph = parent.appendChild(paragraph_);
        if (style != null && style.length() > 0) {
            String styleID = styleMap.findStyle(style);
            if (styleID == null) {
                styleID = style;
            }
            this.paragraphPr = document.createElement("w:pPr");
            this.paragraphPr = this.paragraph.appendChild(this.paragraphPr);
            Element styleElement = document.createElement("w:pStyle");
            styleElement.setAttribute("w:val", styleID);
            this.paragraphPr.appendChild(styleElement);
        }
    }

    public ParagraphWrapper(Document document, Node parent, Locale projectLocale, StyleMap styleMap) {
        this(document, parent, null, styleMap, projectLocale);
    }

    public void addSectionProperties(Node sectionProperties) {
        if (this.paragraphPr == null) {
            this.paragraphPr = this.document.createElement("w:pPr");
            this.paragraphPr = this.paragraph.appendChild(this.paragraphPr);
        }
        this.paragraphPr.appendChild(sectionProperties);
    }

    public void resetRun() {
        this.paragraphR = this.document.createElement("w:r");
        this.paragraphR = this.paragraph.appendChild(this.paragraphR);
        this.paragraphT = this.document.createElement("w:t");
        this.paragraphT = this.paragraphR.appendChild(this.paragraphT);
    }

    public void setFontSize(String size) {
        this.paragraphR = this.document.createElement("w:r");
        this.paragraphR = this.paragraph.appendChild(this.paragraphR);
        Element runPr = this.document.createElement("w:rPr");
        this.paragraphR.appendChild(runPr);
        Element fontSize = this.document.createElement("w:sz");
        fontSize.setAttribute("w:val", size);
        runPr.appendChild(fontSize);
    }

    public void hideParagraph() {
        Node paraParams = this.document.createElement("w:pPr");
        paraParams = this.paragraph.appendChild(paraParams);
        Element allowEmpty = this.document.createElement("wx:allowEmptyCollapse");
        paraParams.appendChild(allowEmpty);
    }

    public void addText(String text) {
        Text t = this.document.createTextNode(text);
        Node paragraphRun = this.paragraph.getLastChild();
        Node paragraphText = null;
        if (paragraphRun != null) {
            paragraphText = paragraphRun.getLastChild();
        }
        boolean correctRun = false;
        boolean correctText = false;
        if (paragraphRun != null) {
            correctRun = paragraphRun.getNodeName().equals("w:r");
        }
        if (paragraphText != null) {
            correctText = paragraphText.getNodeName().equals("w:t");
        }
        if (correctRun && correctText && paragraphText != null) {
            paragraphText.appendChild(t);
        } else if (correctRun && !correctText && paragraphRun != null) {
            this.paragraphT = this.document.createElement("w:t");
            this.paragraphT = paragraphRun.appendChild(this.paragraphT);
            this.paragraphT.appendChild(t);
        } else {
            this.paragraphR = this.document.createElement("w:r");
            this.paragraphR = this.paragraph.appendChild(this.paragraphR);
            this.paragraphT = this.document.createElement("w:t");
            this.paragraphT = this.paragraphR.appendChild(this.paragraphT);
            this.paragraphT.appendChild(t);
        }
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        return new SimpleListWrapper(this.document, this.paragraph, this.projectLocale);
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        return new AnchorWrapper(this.document, this.paragraph, anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        return new LinkWrapper(this.document, this.paragraph, anchorName, this.projectLocale);
    }

    @Override
    public UlinkWrapper addUlink(String url) {
        return new UlinkWrapper(this.document, this.paragraph, url);
    }

    @Override
    public EmphasisWrapper addEmphasis() {
        return new EmphasisWrapper(this.document, this.paragraph, this.projectLocale);
    }

    @Override
    public PhraseWrapper addPhrase() {
        return new PhraseWrapper(this.document, this.paragraph, this.projectLocale);
    }

    @Override
    public MediaObjectWrapper addMediaObject() {
        return new MediaObjectWrapper(this.document, this.paragraph);
    }

    @Override
    public ImageObjectWrapper addImageObject(String name, String format, float width, float height, boolean newImage, int imageCounter, String filename) {
        return new ImageObjectWrapper(this.document, this.paragraph, name, format, width, height, newImage, imageCounter, filename);
    }

    @Override
    public TableWrapper addTable() {
        return new TableWrapper(this.document, this.paragraph, this.projectLocale, this.styleMap);
    }
}

