/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.dom;

import com.arcway.lib.codec.Base64;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ImageObjectWrapper {
    private static final ILogger logger = Logger.getLogger(ImageObjectWrapper.class);
    private Node pict = null;
    private Document document = null;

    public ImageObjectWrapper(Document document, Node parent, String name, String format, float width, float height, boolean duplicate, int imageCounter, String filename) {
        this.document = document;
        byte[] imageData = null;
        try {
            imageData = this.readImageDataFromFile(filename);
        }
        catch (IOException ex) {
            logger.warn("couldn't read image from file during wordml generation", (Throwable)ex);
            return;
        }
        this.pict = document.createElement("w:pict");
        Node pChild = parent.getLastChild();
        if (pChild != null && pChild.getNodeName().equals("w:r")) {
            this.pict = pChild.appendChild(this.pict);
        } else {
            Node run = document.createElement("w:r");
            run = parent.appendChild(run);
            this.pict = run.appendChild(this.pict);
        }
        if (imageCounter == 0) {
            this.addShapetype();
        }
        String extension = "." + format;
        String title = name.substring(0, name.length() - extension.length());
        String imageName = "wordml://" + title + extension;
        if (!duplicate) {
            Element binDataElement = document.createElement("w:binData");
            binDataElement.setAttribute("w:name", imageName);
            Node binDataNode = this.pict.appendChild(binDataElement);
            byte[] imageDataForWord = Base64.encodeBytes((byte[])imageData, (boolean)true);
            String imageDataForWordAsString = new String(imageDataForWord);
            Text t = document.createTextNode(imageDataForWordAsString);
            binDataNode.appendChild(t);
        }
        Element shapeElement = document.createElement("v:shape");
        String shapeID = "i" + Integer.valueOf(1025 + imageCounter).toString();
        shapeElement.setAttribute("id", "_x0000_" + shapeID);
        shapeElement.setAttribute("type", "#_x0000_t75");
        String widthString = new Float(width).toString();
        String heightString = new Float(height).toString();
        shapeElement.setAttribute("style", "width:" + widthString + "pt;height:" + heightString + "pt");
        Node shapeNode = this.pict.appendChild(shapeElement);
        Element imagedata = document.createElement("v:imagedata");
        imagedata.setAttribute("src", imageName);
        imagedata.setAttribute("o:title", title);
        shapeNode.appendChild(imagedata);
    }

    private Node addShapetype() {
        Element shapetypeElement = this.document.createElement("v:shapetype");
        shapetypeElement.setAttribute("id", "_x0000_t75");
        shapetypeElement.setAttribute("coordsize", "21600,21600");
        shapetypeElement.setAttribute("o:spt", "75");
        shapetypeElement.setAttribute("o:preferrelative", "t");
        shapetypeElement.setAttribute("path", "m@4@5l@4@11@9@11@9@5xe");
        shapetypeElement.setAttribute("filled", "f");
        shapetypeElement.setAttribute("stroked", "f");
        Node shapetypeNode = this.pict.appendChild(shapetypeElement);
        Element stroke = this.document.createElement("v:stroke");
        stroke.setAttribute("joinstyle", "miter");
        shapetypeNode.appendChild(stroke);
        Node formulas = this.document.createElement("v:formulas");
        formulas = shapetypeNode.appendChild(formulas);
        Element f1 = this.document.createElement("v:f");
        f1.setAttribute("eqn", "if lineDrawn pixelLineWidth 0");
        formulas.appendChild(f1);
        Element f2 = this.document.createElement("v:f");
        f2.setAttribute("eqn", "sum @0 1 0");
        formulas.appendChild(f2);
        Element f3 = this.document.createElement("v:f");
        f3.setAttribute("eqn", "sum 0 0 @1");
        formulas.appendChild(f3);
        Element f4 = this.document.createElement("v:f");
        f4.setAttribute("eqn", "prod @2 1 2");
        formulas.appendChild(f4);
        Element f5 = this.document.createElement("v:f");
        f5.setAttribute("eqn", "prod @3 21600 pixelWidth");
        formulas.appendChild(f5);
        Element f6 = this.document.createElement("v:f");
        f6.setAttribute("eqn", "prod @3 21600 pixelHeight");
        formulas.appendChild(f6);
        Element f7 = this.document.createElement("v:f");
        f7.setAttribute("eqn", "sum @0 0 1");
        formulas.appendChild(f7);
        Element f8 = this.document.createElement("v:f");
        f8.setAttribute("eqn", "prod @6 1 2");
        formulas.appendChild(f8);
        Element f9 = this.document.createElement("v:f");
        f9.setAttribute("eqn", "prod @7 21600 pixelWidth");
        formulas.appendChild(f9);
        Element f10 = this.document.createElement("v:f");
        f10.setAttribute("eqn", "sum @8 21600 0");
        formulas.appendChild(f10);
        Element f11 = this.document.createElement("v:f");
        f11.setAttribute("eqn", "prod @7 21600 pixelHeight");
        formulas.appendChild(f11);
        Element f12 = this.document.createElement("v:f");
        f12.setAttribute("eqn", "sum @10 21600 0");
        formulas.appendChild(f12);
        Element path = this.document.createElement("v:path");
        path.setAttribute("o:extrusionok", "f");
        path.setAttribute("gradientshapeok", "t");
        path.setAttribute("o:connecttype", "rect");
        shapetypeNode.appendChild(path);
        Element lock = this.document.createElement("o:lock");
        lock.setAttribute("v:ext", "edit");
        lock.setAttribute("aspectratio", "t");
        shapetypeNode.appendChild(lock);
        return shapetypeNode;
    }

    private byte[] readImageDataFromFile(String filename) throws FileNotFoundException, IOException {
        byte[] imageData = new byte[]{};
        try (FileInputStream imageStream = new FileInputStream(filename);){
            int availableAmountOfData;
            int readData = 0;
            int readDataBefore = 0;
            while ((availableAmountOfData = imageStream.available()) != 0) {
                byte[] tempData = new byte[availableAmountOfData];
                readData = imageStream.read(tempData);
                if (readData == -1) {
                    break;
                }
                byte[] concatenatedData = new byte[readDataBefore + readData];
                System.arraycopy(imageData, 0, concatenatedData, 0, readDataBefore);
                System.arraycopy(tempData, 0, concatenatedData, readDataBefore, readData);
                imageData = concatenatedData;
                readDataBefore += readData;
            }
        }
        return imageData;
    }
}

