/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.dom;

import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ISectionParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.SectionWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.TableWrapper;
import com.arcway.lib.java.dom.DOMHelper;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChapterWrapper
implements ISectionParent,
ITableParent,
IAnchorParent,
ILinkParent,
ISimpleListParent {
    private final Document document;
    private final Node parent;
    private final Locale projectLocale;
    private final StyleMap styleMap;
    private ParagraphWrapper lastParagraph = null;

    public ChapterWrapper(Document document, Node parent, Locale projectLocale, StyleMap styleMap) {
        this.document = document;
        this.parent = parent;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
    }

    public void terminateChapter(int chapterCounter, DocBook2WordMLGenerationContext context) {
        this.addParagraph();
        Node sectionProperties = null;
        sectionProperties = chapterCounter == 0 ? context.getCoverSectionProperties().cloneNode(true) : context.getMainSectionProperties().cloneNode(true);
        if (chapterCounter == 1) {
            Element type = this.document.createElement("w:type");
            type.setAttribute("w:val", "odd-page");
            sectionProperties.appendChild(type);
        }
        if (chapterCounter >= 1) {
            DOMHelper.removeChildren((Node)sectionProperties, (String)"w:hdr");
            DOMHelper.removeChildren((Node)sectionProperties, (String)"w:ftr");
        }
        this.lastParagraph.addSectionProperties(sectionProperties);
    }

    @Override
    public SectionWrapper addSection() {
        this.lastParagraph = null;
        return new SectionWrapper(this.document, this.parent, this.projectLocale, this.styleMap);
    }

    @Override
    public ParagraphWrapper addParagraph() {
        return this.addParagraph(null);
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        this.lastParagraph = new ParagraphWrapper(this.document, this.parent, style, this.styleMap, this.projectLocale);
        return this.lastParagraph;
    }

    @Override
    public TableWrapper addTable() {
        this.lastParagraph = null;
        return new TableWrapper(this.document, this.parent, this.projectLocale, this.styleMap);
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        if (this.lastParagraph == null) {
            this.addParagraph();
        }
        return this.lastParagraph.addAnchor(anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        if (this.lastParagraph == null) {
            this.addParagraph();
        }
        return this.lastParagraph.addLink(anchorName);
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        if (this.lastParagraph == null) {
            this.addParagraph();
        }
        return this.lastParagraph.addSimpleList();
    }
}

