/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.wordML.Messages;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.EmphasisWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.LinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.PhraseWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.UlinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ParagraphWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import java.util.List;

public class ParagraphWriter {
    private static ParagraphWriter writer;

    public static ParagraphWriter getInstance() {
        if (writer == null) {
            writer = new ParagraphWriter();
        }
        return writer;
    }

    private ParagraphWriter() {
    }

    public void write(EOPara para, IParagraphParent parent, DocBook2WordMLGenerationContext context) throws ReportGenerationException {
        ParagraphWrapper p = parent.addParagraph(para.getRole());
        boolean emphasizedRun = false;
        List contentList = para.getContent(context.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                if (emphasizedRun) {
                    p.resetRun();
                    emphasizedRun = false;
                }
                p.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, p, context);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, p, context);
                continue;
            }
            if (obj instanceof EOUlink) {
                UlinkWriter.getInstance().write((EOUlink)obj, p, context);
                continue;
            }
            if (obj instanceof EOMediaObject) {
                MediaObjectWriter.getInstance().write((EOMediaObject)obj, p, context);
                continue;
            }
            if (obj instanceof EOSimpleList) {
                if (emphasizedRun) {
                    p.resetRun();
                    emphasizedRun = false;
                }
                SimpleListWriter.getInstance().write((EOSimpleList)obj, p, context);
                continue;
            }
            if (obj instanceof EOTable) {
                throw new ReportGenerationException(Messages.getString("NoTablesInParagraphs.Title"), Messages.getString("NoTablesInParagraphs.Message"), null);
            }
            if (obj instanceof EOEmphasis) {
                EmphasisWriter.getInstance().write((EOEmphasis)obj, p, context);
                emphasizedRun = true;
                continue;
            }
            if (!(obj instanceof EOPhrase)) continue;
            if (emphasizedRun) {
                p.resetRun();
                emphasizedRun = false;
            }
            PhraseWriter.getInstance().write((EOPhrase)obj, p, context);
        }
    }
}

