/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.writer.odt.ODFManifestManager;
import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.TableStyleManager;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class DocBook2ODTGenerationContext {
    private final ReportJob reportJob;
    private int imageCounter;
    private int anchorCounter;
    private int chapterCounter;
    private final File odxDirectory;
    private final Locale projectLocale;
    private final StyleMap styleMap;
    private final GraphicsAndFilesStore graphicsAndFilesStore;
    private final Set<String> alreadyEmbeddedImages;
    private final ODFManifestManager odfManifestManager;
    private final TableStyleManager tableStyleManager;
    private int maxPageRectHeightInPt;
    private int maxPageRectWidhtInPt;

    public DocBook2ODTGenerationContext(File odxDirectory, ReportJob reportJob, Locale projectLocale, StyleMap styleMap, GraphicsAndFilesStore graphicsAndFilesStore, ODFManifestManager odfManifestManager, TableStyleManager tableStyleManager) {
        this.reportJob = reportJob;
        this.imageCounter = -1;
        this.anchorCounter = -1;
        this.chapterCounter = -1;
        this.odxDirectory = odxDirectory;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
        this.graphicsAndFilesStore = graphicsAndFilesStore;
        this.alreadyEmbeddedImages = new HashSet<String>();
        this.odfManifestManager = odfManifestManager;
        this.tableStyleManager = tableStyleManager;
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    public File getOdxDirectory() {
        return this.odxDirectory;
    }

    public Locale getProjectLocale() {
        return this.projectLocale;
    }

    public StyleMap getStyleMap() {
        return this.styleMap;
    }

    public GraphicsAndFilesStore getGraphicsAndFilesStore() {
        return this.graphicsAndFilesStore;
    }

    public TableStyleManager getTableStyleManager() {
        return this.tableStyleManager;
    }

    public boolean checkWhetherImageIsAlreadyEmbeddedAndAddItToListOfEmbeddedImagesIfNot(String fileName) {
        boolean isAlreadyEmbedded = this.alreadyEmbeddedImages.contains(fileName);
        if (!isAlreadyEmbedded) {
            this.alreadyEmbeddedImages.add(fileName);
        }
        return isAlreadyEmbedded;
    }

    public ODFManifestManager getOdfManifestManager() {
        return this.odfManifestManager;
    }

    public int getNextFreeImageIndex() {
        ++this.imageCounter;
        return this.imageCounter;
    }

    public int getNextFreeAnchorIndex() {
        ++this.anchorCounter;
        return this.anchorCounter;
    }

    public int getNextFreeChapterIndex() {
        ++this.chapterCounter;
        return this.chapterCounter;
    }

    public int getMaxRectHeightInPt() {
        return this.maxPageRectHeightInPt;
    }

    public void setMaxRectHeightInPt(int pageHeight) {
        this.maxPageRectHeightInPt = pageHeight;
    }

    public int getMaxRectWidthInPt() {
        return this.maxPageRectWidhtInPt;
    }

    public void setMaxRectWidthInPt(int pageWidth) {
        this.maxPageRectWidhtInPt = pageWidth;
    }
}

