/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractSubStringValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SubstringFilterItem
extends AbstractFilterItem {
    private String name = null;
    private AbstractSubStringValueFilter filter = null;
    private Text txtSubstring = null;
    private String value;

    public SubstringFilterItem(String name, AbstractSubStringValueFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.value = filter.getFilterValue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        String textSubString = this.txtSubstring.getText();
        if (textSubString != null) {
            return textSubString;
        }
        return null;
    }

    @Override
    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(1, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        Label lbl = new Label((Composite)group, 0);
        lbl.setText(Messages.getString("SubstringFilterItem.0"));
        this.txtSubstring = new Text((Composite)group, 2052);
        this.txtSubstring.setLayoutData((Object)new GridData(768));
        this.txtSubstring.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SubstringFilterItem.this.txtSubstring.selectAll();
            }

            public void focusLost(FocusEvent e) {
                SubstringFilterItem.this.updateFilter();
                SubstringFilterItem.this.fireValueChanged();
            }
        });
        this.refresh();
        return group;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        boolean noValuesSet = true;
        return noValuesSet &= this.txtSubstring.getText().trim().length() == 0;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        boolean allValuesSet = true;
        return allValuesSet &= this.txtSubstring.getText().trim().length() > 0;
    }

    private void updateFilter() {
        this.value = this.txtSubstring.getText().trim();
        this.setSelected(this.value.length() > 0);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setFilterValue(this.value);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.value = this.filter.getFilterValue();
    }

    @Override
    public void refresh() {
        if (this.value != null) {
            this.txtSubstring.setText(this.value);
        } else {
            this.txtSubstring.setText("");
        }
    }

    @Override
    public void filterHasChanged() {
        this.value = this.filter.getFilterValue();
    }
}

