/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractStringListFilter
extends AbstractFilter {
    private HashSet<String> passValues;

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        if (this.passValues == null) {
            return true;
        }
        String keywords = this.getStringAttribute(element);
        if (keywords == null) {
            return true;
        }
        ArrayList words = StringUtil.split((String)keywords, (char)',');
        for (String element2 : words) {
            for (String passValue : this.passValues) {
                if (!StringUtil.containsSubstring((String)element2, (String)passValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract String getStringAttribute(Object var1);

    @Override
    public String getFilterValue() {
        if (this.passValues == null) {
            return "";
        }
        StringBuilder filterValue = new StringBuilder();
        for (String passValue : this.passValues) {
            filterValue.append(passValue);
            filterValue.append(",");
        }
        return filterValue.substring(0, filterValue.length() - 1);
    }

    @Override
    public void setFilterValue(String value) {
        ArrayList values = StringUtil.split((String)value, (char)',');
        this.passValues = new HashSet(values.size() * 2);
        for (String valuesElement : values) {
            this.passValues.add(valuesElement.trim().toLowerCase());
        }
        super.setFilterValue(value);
    }

    public void setPassValues(Collection<String> passValues) {
        this.passValues = new HashSet<String>(passValues);
    }

    public Collection<String> getPassValues() {
        return this.passValues;
    }

    @Override
    public void resetValue() {
        this.setFilterValue("");
    }
}

