/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.IDataHandler;
import com.arcway.cockpit.client.base.datamanager.IObjectKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataCacheMgr<T, T_UID> {
    private final IDataHandler<T, T_UID, ?, ?> dataHandler;
    private final Map<IObjectKey, T> dataItems = new HashMap<IObjectKey, T>();

    public DataCacheMgr(IDataHandler<T, T_UID, ?, ?> dataHandler) {
        this.dataHandler = dataHandler;
    }

    protected T getItem(T_UID itemUID) {
        assert (itemUID != null) : "data UID is null";
        return this.getItem(this.dataHandler.getObjectKeyForUID(itemUID));
    }

    private T getItem(IObjectKey objectKey) {
        assert (objectKey != null) : "object key is null";
        return this.dataItems.get(objectKey);
    }

    protected void addItem(T item) {
        assert (item != null) : "item is null";
        this.dataItems.put(this.dataHandler.getObjectKeyForUID(this.dataHandler.getUIDForItem(item)), item);
    }

    protected void updateItem(T item) {
        assert (item != null) : "item must not be null";
        IObjectKey key = this.dataHandler.getObjectKeyForUID(this.dataHandler.getUIDForItem(item));
        T itemInCache = this.getItem(key);
        if (itemInCache != null) {
            this.dataHandler.copyAllAttributes(item, itemInCache);
        }
    }

    protected T removeItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        return this.dataItems.remove(this.dataHandler.getObjectKeyForUID(itemUID));
    }

    protected boolean containsKey(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        return this.dataItems.containsKey(this.dataHandler.getObjectKeyForUID(itemUID));
    }

    protected List<T> getAllItems() {
        ArrayList<T> items = new ArrayList<T>();
        items.addAll(this.dataItems.values());
        return items;
    }

    protected void clear() {
        this.dataItems.clear();
    }
}

