/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.AccessAgentModificationAccess;
import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.client.base.datamanager.DataCacheMgr;
import com.arcway.cockpit.client.base.datamanager.DataModificationLogMgr;
import com.arcway.cockpit.client.base.datamanager.IDataHandler;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DataAccessAgent<T, T_UID, T_Datatype, T_EO extends EOGenericCockpitDatabaseData> {
    private static final ILogger logger = Logger.getLogger(DataAccessAgent.class);
    private T_Datatype dataTypeId;
    private String usageContext;
    private String nameOfCurrentUser;
    private IDataHandler<T, T_UID, T_Datatype, T_EO> dataHandler;
    private IModificationDiscardCallback<T, T_Datatype> modificationDiscardCallback;
    private DataCacheMgr<T, T_UID> serverCacheManager;
    private DataModificationLogMgr<T, T_UID, T_EO> modLogManager;
    private DataCacheMgr<T, T_UID> clientCacheManager;
    private long lastCreationTime = 0L;

    public void construct(T_Datatype dataTypeId_, String usageContext_, IDataHandler<T, T_UID, T_Datatype, T_EO> dataHandler_, IModificationDiscardCallback<T, T_Datatype> modificationDiscardCallback_, AccessAgentModificationAccess<T, T_UID, T_EO> accessAgentModificationAccess_) {
        this.dataTypeId = dataTypeId_;
        this.usageContext = usageContext_;
        this.nameOfCurrentUser = "";
        this.dataHandler = dataHandler_;
        this.modificationDiscardCallback = modificationDiscardCallback_;
        this.serverCacheManager = new DataCacheMgr<T, T_UID>(dataHandler_);
        this.modLogManager = new DataModificationLogMgr<T, T_UID, T_EO>(dataHandler_, accessAgentModificationAccess_);
        this.clientCacheManager = this.createClientCacheManager();
    }

    protected DataCacheMgr<T, T_UID> createClientCacheManager() {
        return new DataCacheMgr<T, T_UID>(this.dataHandler);
    }

    public void initServerState(String nameOfCurrentUser_, Collection<? extends T> serverItems) {
        assert (serverItems != null) : "server items list is null";
        this.nameOfCurrentUser = nameOfCurrentUser_;
        for (T item : serverItems) {
            this.serverCacheManager.addItem(item);
            this.clientCacheManager.addItem(this.dataHandler.getCloneOfObject(item));
        }
    }

    public void initLocalModifications() throws EXCorruptProjectData {
        T mergedElement;
        T_UID uid;
        List<T> removedItems;
        List<T> updatedItems;
        List<T> addedItems;
        assert (!this.hasModifications());
        try {
            AccessAgentModificationAccess<T, T_UID, T_EO> accessAgentModificationAccess = this.modLogManager.getAccessAgentModificationAccess();
            addedItems = accessAgentModificationAccess.getAllItemsOfModType('a', this.dataHandler);
            updatedItems = accessAgentModificationAccess.getAllItemsOfModType('u', this.dataHandler);
            removedItems = accessAgentModificationAccess.getAllItemsOfModType('r', this.dataHandler);
            accessAgentModificationAccess.discardAllModificationsOfModType('a');
            accessAgentModificationAccess.discardAllModificationsOfModType('u');
            accessAgentModificationAccess.discardAllModificationsOfModType('r');
        }
        catch (AtomicModificationDataAccessor.ModificationBootstrapFailure e) {
            throw new EXCorruptProjectData(e);
        }
        assert (addedItems != null) : "added items list is null";
        assert (updatedItems != null) : "modified items list is null";
        assert (removedItems != null) : "removed items list is null";
        for (Object addedItem : addedItems) {
            uid = this.dataHandler.getUIDForItem(addedItem);
            if (!this.serverCacheManager.containsKey(uid)) {
                this.modLogManager.addAddedItem(addedItem);
                this.clientCacheManager.addItem(addedItem);
                continue;
            }
            T serverItem = this.serverCacheManager.getItem(uid);
            if (this.dataHandler.mergingHasEffect(serverItem, addedItem)) {
                mergedElement = this.dataHandler.merge(serverItem, addedItem);
                this.modLogManager.addUpdatedItem(mergedElement);
                this.clientCacheManager.addItem(mergedElement);
            }
            this.logWarning("initLocalModifications", "Local addition already exists on server", uid);
        }
        for (Object updatedItem : updatedItems) {
            uid = this.dataHandler.getUIDForItem(updatedItem);
            T serverElement = this.serverCacheManager.getItem(uid);
            if (serverElement != null) {
                if (!this.dataHandler.mergingHasEffect(serverElement, updatedItem)) continue;
                mergedElement = this.dataHandler.merge(serverElement, updatedItem);
                this.modLogManager.addUpdatedItem(mergedElement);
                this.clientCacheManager.addItem(mergedElement);
                continue;
            }
            if (this.modLogManager.containsAddedItem(uid)) {
                T addedElement = this.modLogManager.getAddedItem(uid);
                T mergedElement2 = this.dataHandler.merge(addedElement, updatedItem);
                this.modLogManager.addAddedItem(mergedElement2);
                this.clientCacheManager.addItem(mergedElement2);
                this.logWarning("initLocalModifications", "Local update does not exist on server, but as local addition", uid);
                continue;
            }
            this.logWarning("initLocalModifications", "Local update was deleted because item was deleted on server", uid);
        }
        for (Object removedItem : removedItems) {
            uid = this.dataHandler.getUIDForItem(removedItem);
            if (this.serverCacheManager.containsKey(uid)) {
                this.modLogManager.addRemovedItem(removedItem);
                this.clientCacheManager.removeItem(uid);
            } else {
                this.logWarning("initLocalModifications", "Local removal was deleted because element was deleted on server", uid);
            }
            if (this.modLogManager.containsAddedItem(uid)) {
                this.modLogManager.removeAddedItem(uid);
                this.logWarning("initLocalModifications", "Local removal also exists as local addition -> addition has been deleted", uid);
            }
            if (!this.modLogManager.containsUpdatedItem(uid)) continue;
            this.modLogManager.removeUpdatedItem(uid);
            this.logWarning("initLocalModifications", "Local removal also exists as local update -> update has been deleted", uid);
        }
    }

    public void clearLocalModifications() {
        this.modificationDiscardCallback.addedItemsToBeCleared(this.modLogManager.getAllAddedItems());
        this.modificationDiscardCallback.updatedItemsToBeCleared(this.modLogManager.getAllUpdatedItems());
        this.modificationDiscardCallback.removedItemsToBeCleared(this.modLogManager.getAllRemovedItems());
        this.modLogManager.clear();
        this.clientCacheManager.clear();
    }

    public void clear() {
        this.serverCacheManager.clear();
        this.modLogManager.clear();
        this.clientCacheManager.clear();
    }

    public boolean hasModifications() {
        return this.modLogManager.hasModifications();
    }

    public T getItem(T_UID itemUID) {
        assert (itemUID != null) : "data UID is null";
        return this.clientCacheManager.getItem(itemUID);
    }

    public void addItem(T item, boolean setModificationData) {
        assert (item != null) : "item is null";
        if (setModificationData) {
            long currentTime = System.currentTimeMillis();
            long creationTimeStamp = currentTime > this.lastCreationTime ? currentTime : this.lastCreationTime + 1L;
            this.lastCreationTime = creationTimeStamp;
            this.dataHandler.setInitialModificationAttributes(item, creationTimeStamp, this.nameOfCurrentUser);
        }
        this.clientCacheManager.addItem(item);
        this.modLogManager.addAddedItem(item);
    }

    public void modifyItem(T item) {
        assert (item != null) : "item is null";
        this.dataHandler.setNewModificationAttributes(item, System.currentTimeMillis(), this.nameOfCurrentUser);
        T_UID uid = this.dataHandler.getUIDForItem(item);
        if (this.modLogManager.containsAddedItem(uid)) {
            this.clientCacheManager.updateItem(item);
            this.modLogManager.addAddedItem(item);
        } else {
            this.clientCacheManager.updateItem(item);
            this.modLogManager.addUpdatedItem(item);
        }
    }

    public T removeItem(T item) {
        assert (item != null) : "item is null";
        T_UID uid = this.dataHandler.getUIDForItem(item);
        if (this.serverCacheManager.containsKey(uid)) {
            this.modLogManager.removeUpdatedItem(uid);
            this.modLogManager.addRemovedItem(item);
        } else {
            this.modificationDiscardCallback.removedItemsToBeCleared(Collections.singleton(item));
            this.modLogManager.removeAddedItem(uid);
        }
        T removedItem = this.clientCacheManager.removeItem(uid);
        return removedItem;
    }

    public boolean containsItem(T_UID itemUID) {
        assert (itemUID != null) : "itemUID is null";
        return this.clientCacheManager.containsKey(itemUID);
    }

    public List<T> getAllItems() {
        return this.clientCacheManager.getAllItems();
    }

    public List<T> getAddedItems() {
        return this.modLogManager.getAllAddedItems();
    }

    public List<T> getUpdatedItems() {
        return this.modLogManager.getAllUpdatedItems();
    }

    public List<T> getRemovedItems() {
        return this.modLogManager.getAllRemovedItems();
    }

    public boolean isNew(T_UID uid) {
        return this.modLogManager.containsAddedItem(uid);
    }

    public boolean itemExistsOnServer(T_UID uid) {
        return this.serverCacheManager.containsKey(uid);
    }

    public boolean isUpdated(T_UID uid) {
        return this.modLogManager.containsUpdatedItem(uid);
    }

    public boolean isRemoved(T_UID uid) {
        return this.modLogManager.containsRemovedItem(uid);
    }

    public Collection<T> handleCommitOfAddedItems(Collection<T> addedItems) {
        assert (addedItems != null);
        for (T item : addedItems) {
            this.serverCacheManager.addItem(item);
            this.modLogManager.removeAddedItem(this.dataHandler.getUIDForItem(item));
            this.clientCacheManager.updateItem(item);
        }
        List<T> failedList = this.modLogManager.getAllAddedItems();
        if (!failedList.isEmpty()) {
            logger.warn(String.valueOf(failedList.size()) + " added items of type " + this.dataTypeId + " could not be committed. They will be discarded on the client.");
        }
        this.modLogManager.clearAddedItems();
        for (T item : failedList) {
            this.clientCacheManager.removeItem(this.dataHandler.getUIDForItem(item));
        }
        return failedList;
    }

    public Collection<T> handleCommitOfUpdatedItems(Collection<T> updatedItems) {
        assert (updatedItems != null);
        for (T item : updatedItems) {
            this.serverCacheManager.addItem(item);
            this.modLogManager.removeUpdatedItem(this.dataHandler.getUIDForItem(item));
            this.clientCacheManager.updateItem(item);
        }
        this.modificationDiscardCallback.updatedItemsThatHaveBeenCommitted(updatedItems);
        List<T> failedList = this.modLogManager.getAllUpdatedItems();
        if (!failedList.isEmpty()) {
            logger.warn(String.valueOf(failedList.size()) + " updated items of type " + this.dataTypeId + " could not be committed. Updates will be discarded on the client.");
        }
        this.modLogManager.clearUpdatedItems();
        for (T item : failedList) {
            T serverItem = this.serverCacheManager.getItem(this.dataHandler.getUIDForItem(item));
            if (serverItem != null) {
                this.clientCacheManager.addItem(this.dataHandler.getCloneOfObject(item));
                continue;
            }
            this.clientCacheManager.removeItem(this.dataHandler.getUIDForItem(item));
        }
        return failedList;
    }

    protected Collection<T> handleCommitOfRemovedItems(Collection<T> removedItems) {
        assert (removedItems != null);
        for (T item : removedItems) {
            this.serverCacheManager.removeItem(this.dataHandler.getUIDForItem(item));
            this.modLogManager.removeRemovedItem(this.dataHandler.getUIDForItem(item));
        }
        this.modificationDiscardCallback.removedItemsThatHaveBeenCommitted(removedItems);
        List<T> failedList = this.modLogManager.getAllRemovedItems();
        if (!failedList.isEmpty()) {
            logger.warn(String.valueOf(failedList.size()) + " removed items of type " + this.dataTypeId + " could not be committed. Removals will be discarded on the client.");
        }
        this.modLogManager.clearRemovedItems();
        for (T item : failedList) {
            T serverItem = this.serverCacheManager.getItem(this.dataHandler.getUIDForItem(item));
            if (serverItem == null) continue;
            this.clientCacheManager.addItem(this.dataHandler.getCloneOfObject(item));
        }
        return failedList;
    }

    protected void handleAsynchronousUpdateOfAddedItems(Collection<T> addedItems) {
        assert (addedItems != null);
        for (T item : addedItems) {
            this.serverCacheManager.addItem(item);
            this.clientCacheManager.addItem(this.dataHandler.getCloneOfObject(item));
        }
        this.modificationDiscardCallback.asynchronousUpdateHook_post_addedItems(this.dataTypeId, addedItems);
    }

    protected void handleAsynchronousUpdateOfUpdatedItems(Collection<T> updatedItems) {
        assert (updatedItems != null);
        for (T item : updatedItems) {
            T localItem = this.clientCacheManager.getItem(this.dataHandler.getUIDForItem(item));
            if (localItem == null) {
                this.logWarning("handleAsynchronousUpdateOfUpdatedItems", "No local item for updated item", this.dataHandler.getUIDForItem(item));
                this.serverCacheManager.addItem(item);
                this.clientCacheManager.addItem(this.dataHandler.getCloneOfObject(item));
                continue;
            }
            if (this.modLogManager.containsUpdatedItem(this.dataHandler.getUIDForItem(localItem))) {
                if (this.dataHandler.mergingHasEffect(item, localItem)) {
                    T mergedElement = this.dataHandler.merge(item, localItem);
                    this.serverCacheManager.updateItem(item);
                    this.clientCacheManager.updateItem(mergedElement);
                    this.modLogManager.addUpdatedItem(mergedElement);
                    continue;
                }
                this.serverCacheManager.updateItem(item);
                this.clientCacheManager.updateItem(this.dataHandler.getCloneOfObject(item));
                this.modLogManager.removeUpdatedItem(this.dataHandler.getUIDForItem(item));
                continue;
            }
            this.serverCacheManager.updateItem(item);
            this.clientCacheManager.updateItem(this.dataHandler.getCloneOfObject(item));
        }
        this.modificationDiscardCallback.asynchronousUpdateHook_post_modifiedItems(this.dataTypeId, updatedItems);
    }

    protected void handleAsynchronousUpdateOfRemovedItems(Collection<T> removedItems) {
        assert (removedItems != null);
        this.modificationDiscardCallback.asynchronousUpdateHook_pre_removedItems(this.dataTypeId, removedItems);
        for (T element : removedItems) {
            T_UID uid = this.dataHandler.getUIDForItem(element);
            this.serverCacheManager.removeItem(uid);
            this.clientCacheManager.removeItem(uid);
            this.modLogManager.removeUpdatedItem(uid);
            this.modLogManager.removeRemovedItem(uid);
        }
    }

    public T_Datatype getDataTypeId() {
        return this.dataTypeId;
    }

    private void logWarning(String method, String warningMessage, T_UID uid) {
        logger.warn("DataAccessAgent." + method + "()" + " - " + warningMessage + ":" + " element type: " + this.dataTypeId + " element UID: " + uid.toString() + " usage context: " + this.usageContext);
    }

    public static interface IModificationDiscardCallback<T, T_Datatype> {
        public void addedItemsToBeCleared(Collection<T> var1);

        public void addedItemsThatHaveBeenCommitted(Collection<T> var1);

        public void asynchronousUpdateHook_post_addedItems(T_Datatype var1, Collection<T> var2);

        public void updatedItemsToBeCleared(Collection<T> var1);

        public void updatedItemsThatHaveBeenCommitted(Collection<T> var1);

        public void asynchronousUpdateHook_post_modifiedItems(T_Datatype var1, Collection<T> var2);

        public void removedItemsToBeCleared(Collection<T> var1);

        public void removedItemsThatHaveBeenCommitted(Collection<T> var1);

        public void asynchronousUpdateHook_pre_removedItems(T_Datatype var1, Collection<T> var2);
    }
}

