/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String ID_NAME = OS.NSFilenamesPboardType.getString();
    static final int ID = Transfer.registerType(ID_NAME);

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] files = (String[])object;
        int length = files.length;
        NSMutableArray array = NSMutableArray.arrayWithCapacity(length);
        int i = 0;
        while (i < length) {
            String fileName = files[i];
            NSString string = NSString.stringWith(fileName);
            array.addObject(string);
            ++i;
        }
        transferData.data = array;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSArray array = (NSArray)transferData.data;
        if (array.count() == 0L) {
            return null;
        }
        int count = (int)array.count();
        String[] fileNames = new String[count];
        int i = 0;
        while (i < count) {
            NSString string = new NSString(array.objectAtIndex(i));
            fileNames[i] = string.getString();
            ++i;
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{ID};
    }

    protected String[] getTypeNames() {
        return new String[]{ID_NAME};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

