/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.transactions;

import com.arcway.lib.java.Assert;

public abstract class RepositoryTransactionState {
    public static final RepositoryTransactionState OPEN = new RepositoryTransactionState("Open"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == EXECUTING || newState == CLOSED;
        }
    };
    public static final RepositoryTransactionState EXECUTING = new RepositoryTransactionState("Executing"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == OPEN || newState == PARTIAL_ROLLBACK || newState == FAILED;
        }
    };
    public static final RepositoryTransactionState PARTIAL_ROLLBACK = new RepositoryTransactionState("Partial Rollback"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == OPEN || newState == FAILED;
        }
    };
    public static final RepositoryTransactionState CLOSED = new RepositoryTransactionState("Closed"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == ROLLING_BACK;
        }
    };
    public static final RepositoryTransactionState ROLLING_BACK = new RepositoryTransactionState("Rolling back"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == ROLLED_BACK || newState == FAILED;
        }
    };
    public static final RepositoryTransactionState ROLLED_BACK = new RepositoryTransactionState("Rolled back"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == REDOING;
        }
    };
    public static final RepositoryTransactionState REDOING = new RepositoryTransactionState("Redoing"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return newState == CLOSED || newState == FAILED;
        }
    };
    public static final RepositoryTransactionState FAILED = new RepositoryTransactionState("Failed"){

        @Override
        protected boolean isValidSuccessor(RepositoryTransactionState newState) {
            return false;
        }

        @Override
        public RepositoryTransactionState transit(RepositoryTransactionState newState) {
            return this;
        }
    };
    private final String name;

    private RepositoryTransactionState(String str) {
        this.name = str;
    }

    public String toString() {
        return this.name;
    }

    public RepositoryTransactionState transit(RepositoryTransactionState newState) {
        Assert.checkArgument((boolean)this.isValidSuccessor(newState));
        return newState;
    }

    public boolean canActionsBeAppended() {
        return this == OPEN || this == EXECUTING;
    }

    public boolean isExecutionState() {
        return this == EXECUTING || this == PARTIAL_ROLLBACK || this == ROLLING_BACK || this == REDOING;
    }

    protected abstract boolean isValidSuccessor(RepositoryTransactionState var1);

    /* synthetic */ RepositoryTransactionState(String string, RepositoryTransactionState repositoryTransactionState) {
        this(string);
    }
}

