/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjobeditors.automatic;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.importexport.imporT.IImportJobEditor;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObjectType;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObjectTypeCategory;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.util.Collection;

public class AIJEObjectTypeCategoryRecogniser
implements IImportJobEditor {
    private final boolean useUID;
    private final boolean useHumanReadableID;
    private final ISet_<IRepositoryObjectTypeID> objectTypesToBeConsidered;

    public AIJEObjectTypeCategoryRecogniser(boolean useUID, boolean useHumanReadableID) {
        assert (useUID || useHumanReadableID) : "No criterion for object type category matching selected";
        this.useUID = useUID;
        this.useHumanReadableID = useHumanReadableID;
        this.objectTypesToBeConsidered = null;
    }

    public AIJEObjectTypeCategoryRecogniser(Collection<IRepositoryObjectTypeID> objectTypesToBeConsidered, boolean useUID, boolean useHumanReadableID) {
        assert (useUID || useHumanReadableID) : "No criterion for object type category matching selected";
        this.useUID = useUID;
        this.useHumanReadableID = useHumanReadableID;
        this.objectTypesToBeConsidered = new HashSet_(objectTypesToBeConsidered, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    }

    @Override
    public IImportJobEditor.ResultCode editImportJob(IImportJob importJob, IRepositorySnapshotRO snapshot, boolean executionMessagesOccurred) throws EXNotReproducibleSnapshot {
        this.handleObjectTypes(importJob.getImportedObjectTypes(), snapshot);
        return IImportJobEditor.ResultCode.COMPLETED_NOMORECALLS;
    }

    private void handleObjectTypes(Collection<? extends IImportedObjectType> objectTypes, IRepositorySnapshotRO snapshot) {
        HashSet_ handledCategoryDefiningRootObjectTypes = new HashSet_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        for (IImportedObjectType iImportedObjectType : objectTypes) {
            if (this.objectTypesToBeConsidered != null && RepositoryObjectTypes.findMostSpecificSuperObjectType(iImportedObjectType.getObjectType(), this.objectTypesToBeConsidered) == null) continue;
            this.handleObjectType(iImportedObjectType, snapshot, (ISetRW_<IRepositoryObjectTypeID>)handledCategoryDefiningRootObjectTypes);
        }
    }

    private void handleObjectType(IImportedObjectType objectType, IRepositorySnapshotRO snapshot, ISetRW_<IRepositoryObjectTypeID> handledCategoryDefiningRootObjectTypes) {
        IRepositoryObjectType objectTypeDefinition = objectType.getObjectType();
        IRepositoryObjectType objectTypeDefinitionOfCategoryRootType = objectTypeDefinition.getRootTypeForCategoryDefinition();
        if (!handledCategoryDefiningRootObjectTypes.contains((Object)objectTypeDefinitionOfCategoryRootType.getRepositoryObjectTypeID())) {
            HashSet_ setOfObjectTypeCategoryIDs = new HashSet_(IRepositoryObjectTypeCategoryID.IS_EQUAL_OBJECT_TYPE_CATEGORY_ID_HASHER);
            HashMap_ map_humanReadableID_uid = new HashMap_(IHasher_.EQUALS_HASHER);
            IList_<IRepositoryObjectTypeCategory> allObjectTypeCategoriesForObjectType = snapshot.getAllObjectTypeCategoriesForObjectType(objectTypeDefinition);
            for (IRepositoryObjectTypeCategory existingCategory : allObjectTypeCategoriesForObjectType) {
                setOfObjectTypeCategoryIDs.add((Object)existingCategory.getObjectTypeCategoryID());
                map_humanReadableID_uid.put((Object)existingCategory.getHumanReadableID(), (Object)existingCategory.getObjectTypeCategoryID());
            }
            for (IImportedObjectTypeCategory importedCategory : objectType.getObjectTypeCategories()) {
                IRepositoryObjectTypeCategoryID importedCategoryID = importedCategory.getImportedObjectTypeCategory().getObjectTypeCategoryID();
                if (this.useUID && setOfObjectTypeCategoryIDs.contains((Object)importedCategoryID)) {
                    importedCategory.setMatchingObjectTypeCategoryID(importedCategoryID);
                    continue;
                }
                String importedCategoryHumanReadableID = importedCategory.getImportedObjectTypeCategory().getHumanReadableID();
                IRepositoryObjectTypeCategoryID existingCategoryID = (IRepositoryObjectTypeCategoryID)map_humanReadableID_uid.getByKey((Object)importedCategoryHumanReadableID);
                if (this.useHumanReadableID && existingCategoryID != null) {
                    importedCategory.setMatchingObjectTypeCategoryID(existingCategoryID);
                    continue;
                }
                importedCategory.setMatchingObjectTypeCategoryID(null);
            }
            handledCategoryDefiningRootObjectTypes.add((Object)objectTypeDefinitionOfCategoryRootType.getRepositoryObjectTypeID());
        }
    }
}

