/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.object;

import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.lib.generic.AbstractStructuredDataType;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownRepositoryObjectType;
import com.arcway.repository.interFace.data.attributeset.DTRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.declaration.type.data.DTRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.DTRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.importexport.schema.IRepositoryObjectTypeSampleRO;
import com.arcway.repository.interFace.importexport.schema.IRepositorySchemaSampleRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryStructuredDataType;
import com.arcway.repository.lib.high.registration.data.IRepositoryRelatedDataTypeSingletonFactory;
import com.arcway.repository.lib.high.registration.data.RepositoryRelatedDataTypes;

public class DTRepositoryObjectSample
extends AbstractRepositoryStructuredDataType {
    private static final IKey ROLE_OBJECT_TYPE_ID = Key.getCanonicalKeyInstance((String)"objecttypeid");
    private static final IKey ROLE_CATEGORY = Key.getCanonicalKeyInstance((String)"category");
    private static final IKey ROLE_PROPERTIES = Key.getCanonicalKeyInstance((String)"properties");
    private static final IRepositoryRelatedDataTypeSingletonFactory<DTRepositoryObjectSample> INSTANCE_FACTORY_WITHOUT_PORTABLE_LOADING = new IRepositoryRelatedDataTypeSingletonFactory<DTRepositoryObjectSample>(){

        @Override
        public DTRepositoryObjectSample createInstance(IRepositoryTypeManagerRO key) {
            boolean withPortableLoading = false;
            return new DTRepositoryObjectSample(key, withPortableLoading, null);
        }
    };
    private static final IRepositoryRelatedDataTypeSingletonFactory<DTRepositoryObjectSample> INSTANCE_FACTORY_WITH_PORTABLE_LOADING = new IRepositoryRelatedDataTypeSingletonFactory<DTRepositoryObjectSample>(){

        @Override
        public DTRepositoryObjectSample createInstance(IRepositoryTypeManagerRO key) {
            boolean withPortableLoading = true;
            return new DTRepositoryObjectSample(key, withPortableLoading, null);
        }
    };
    private final IRepositoryTypeManagerRO repositoryTypeManager;
    private final boolean withPortableLoading;
    private static IRepositorySchemaSampleRO sourceSchemaForWhichDataTypeCacheIsSetUp = null;
    private static final IMapRW_<IRepositoryObjectTypeID, DTRepositoryPropertySetSample> map_objectType_deserialiser = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    public static final ThreadLocal<IRepositorySchemaSampleRO> CONTEXT_HACK = new ThreadLocal();

    public static synchronized DTRepositoryObjectSample getInstance(IRepositoryTypeManagerRO typeManager, boolean withPortableLoading) {
        return RepositoryRelatedDataTypes.getInstance(DTRepositoryObjectSample.class, typeManager, withPortableLoading ? INSTANCE_FACTORY_WITH_PORTABLE_LOADING : INSTANCE_FACTORY_WITHOUT_PORTABLE_LOADING);
    }

    private DTRepositoryObjectSample(IRepositoryTypeManagerRO repositoryTypeManager, boolean withPortableLoading) {
        super(DTRepositoryObjectSample.class, repositoryTypeManager);
        this.repositoryTypeManager = repositoryTypeManager;
        this.addPropertyType(ROLE_OBJECT_TYPE_ID, (IDataType)DTRepositoryObjectTypeID.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addPropertyType(ROLE_CATEGORY, (IDataType)DTRepositoryObjectTypeCategoryID.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.OPTIONAL_NULLABLE);
        this.addPolymorphPropertyType(ROLE_PROPERTIES, AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        for (IRepositoryObjectType repositoryObjectType : repositoryTypeManager.getAllObjectTypes()) {
            this.registerAtNeededResource(DTRepositoryPropertySetSample.getInstance(repositoryObjectType, withPortableLoading).getListenerManager(), this);
        }
        this.withPortableLoading = withPortableLoading;
    }

    protected IDataType getDataTypeOfPolymorphPropertyOrChildren(Object data, IKey role) {
        IDataType dataType;
        IRepositoryObjectSample typedData = (IRepositoryObjectSample)data;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROPERTIES)) {
            IRepositoryObjectTypeID repositoryObjectTypeID = typedData.getObjectTypeID();
            IRepositoryObjectType repositoryObjectType = this.repositoryTypeManager.findObjectType(repositoryObjectTypeID);
            dataType = this.getDataTypeOfProperties(repositoryObjectType);
        } else {
            dataType = super.getDataTypeOfPolymorphPropertyOrChildren(data, role);
        }
        return dataType;
    }

    private DTRepositoryPropertySetSample getDataTypeOfProperties(IRepositoryObjectType repositoryObjectType) {
        DTRepositoryPropertySetSample dataType = DTRepositoryPropertySetSample.getInstance(repositoryObjectType, this.withPortableLoading);
        return dataType;
    }

    public boolean isSet(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    public Object getProperty(Object data, IKey role) {
        Object propertyData;
        IRepositoryObjectSample typedData = (IRepositoryObjectSample)data;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_OBJECT_TYPE_ID)) {
            propertyData = typedData.getObjectTypeID();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_CATEGORY)) {
            propertyData = typedData.getObjectTypeCategoryID();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROPERTIES)) {
            propertyData = typedData.getPropertySetSample();
        } else {
            throw new IllegalArgumentException();
        }
        return propertyData;
    }

    public IList_<Object> getChildren(Object data, IKey role) {
        throw new UnsupportedOperationException();
    }

    public AbstractStructuredDataType.AbstractStructuredDataFactory createStructuredDataFactory() {
        return new DataFactory();
    }

    /* synthetic */ DTRepositoryObjectSample(IRepositoryTypeManagerRO iRepositoryTypeManagerRO, boolean bl, DTRepositoryObjectSample dTRepositoryObjectSample) {
        this(iRepositoryTypeManagerRO, bl);
    }

    private class DataFactory
    extends AbstractStructuredDataType.AbstractStructuredDataFactory {
        private IRepositoryObjectType repositoryObjectType;
        private IRepositoryObjectTypeCategoryID categoryID;
        private IRepositoryPropertySetSample properties;

        private DataFactory() {
        }

        public void setFlag(IKey role) {
            throw new IllegalArgumentException();
        }

        public void addPropertyOrChild(IKey role, Object propertyOrChild) throws EXDataAssemblingFailed {
            if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_OBJECT_TYPE_ID)) {
                Assert.checkArgumentBeeingNotNull((Object)propertyOrChild);
                IRepositoryObjectTypeID repositoryObjectTypeID = (IRepositoryObjectTypeID)propertyOrChild;
                this.repositoryObjectType = DTRepositoryObjectSample.this.repositoryTypeManager.findObjectType(repositoryObjectTypeID);
                if (this.repositoryObjectType == null) {
                    throw new EXDataAssemblingFailed((Exception)new EXUnknownRepositoryObjectType(repositoryObjectTypeID));
                }
            } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_CATEGORY)) {
                this.categoryID = (IRepositoryObjectTypeCategoryID)propertyOrChild;
            } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROPERTIES)) {
                this.properties = (IRepositoryPropertySetSample)propertyOrChild;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public IDataType getDataTypeOfPolymorphPropertyOrChildren(IKey role) {
            IDataType dataTypeToReturn;
            if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROPERTIES)) {
                if (DTRepositoryObjectSample.this.withPortableLoading) {
                    IRepositorySchemaSampleRO schemaSample = CONTEXT_HACK.get();
                    if (schemaSample != sourceSchemaForWhichDataTypeCacheIsSetUp) {
                        sourceSchemaForWhichDataTypeCacheIsSetUp = schemaSample;
                        map_objectType_deserialiser.clear();
                    }
                    if (schemaSample != null) {
                        IDataType cachedDataType = (IDataType)map_objectType_deserialiser.getByKey((Object)this.repositoryObjectType.getRepositoryObjectTypeID());
                        if (cachedDataType != null) {
                            dataTypeToReturn = cachedDataType;
                        } else {
                            IRepositoryObjectTypeSampleRO objectTypeSample = schemaSample.getObjectTypeSample(this.repositoryObjectType.getRepositoryObjectTypeID());
                            if (objectTypeSample != null) {
                                DTRepositoryPropertySetSample newDataType = new DTRepositoryPropertySetSample(this.repositoryObjectType, objectTypeSample);
                                map_objectType_deserialiser.put((Object)this.repositoryObjectType.getRepositoryObjectTypeID(), (Object)newDataType);
                                dataTypeToReturn = newDataType;
                            } else {
                                dataTypeToReturn = DTRepositoryObjectSample.this.getDataTypeOfProperties(this.repositoryObjectType);
                            }
                        }
                    } else {
                        dataTypeToReturn = DTRepositoryObjectSample.this.getDataTypeOfProperties(this.repositoryObjectType);
                    }
                } else {
                    dataTypeToReturn = DTRepositoryObjectSample.this.getDataTypeOfProperties(this.repositoryObjectType);
                }
            } else {
                dataTypeToReturn = super.getDataTypeOfPolymorphPropertyOrChildren(role);
            }
            return dataTypeToReturn;
        }

        public Object createDataElement() {
            return new RepositoryObjectSample(this.repositoryObjectType.getRepositoryObjectTypeID(), this.categoryID, this.properties);
        }

        public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
            return false;
        }
    }
}

