/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.implementation.registration.type.relation.OccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;

public class RTATMRegisterOccurrenceRelationType
implements IRegistrationAction {
    private final RepositoryTypeManager typeManager;
    private final OccurrenceRepositoryRelationType relationType;

    public RTATMRegisterOccurrenceRelationType(RepositoryTypeManager typeManager, OccurrenceRepositoryRelationType relationType) {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)relationType);
        this.typeManager = typeManager;
        this.relationType = relationType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryRelationTypeID, OccurrenceRepositoryRelationType> allRelationTypes = this.typeManager.allOccurenceRelationTypes;
        IRepositoryRelationTypeID relationTypeID = this.relationType.getRepositoryRelationTypeID();
        Assert.checkState((!allRelationTypes.containsKey((Object)relationTypeID) ? 1 : 0) != 0);
        allRelationTypes.put((Object)relationTypeID, (Object)this.relationType);
    }

    @Override
    public void undo() {
        IRepositoryRelationTypeID relationTypeID = this.relationType.getRepositoryRelationTypeID();
        IMapRW_<IRepositoryRelationTypeID, OccurrenceRepositoryRelationType> allRelationTypes = this.typeManager.allOccurenceRelationTypes;
        Assert.checkState((boolean)allRelationTypes.containsKey((Object)relationTypeID));
        allRelationTypes.removeAsValue((Object)relationTypeID);
    }
}

