/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;

public class RTATMRegisterDataType
implements IRegistrationAction {
    private final RepositoryTypeManager typeManager;
    private final IRepositoryDataType dataType;

    public RTATMRegisterDataType(RepositoryTypeManager typeManager, IRepositoryDataType dataType) {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)dataType);
        this.typeManager = typeManager;
        this.dataType = dataType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryDataTypeID, IRepositoryDataType> dataTypes = this.typeManager.dataTypes;
        IRepositoryDataTypeID dataTypeID = this.dataType.getRepositoryDataTypeID();
        Assert.checkState((!dataTypes.containsKey((Object)dataTypeID) ? 1 : 0) != 0);
        dataTypes.put((Object)dataTypeID, (Object)this.dataType);
    }

    @Override
    public void undo() {
        IRepositoryDataTypeID dataTypeID = this.dataType.getRepositoryDataTypeID();
        IMapRW_<IRepositoryDataTypeID, IRepositoryDataType> dataTypes = this.typeManager.dataTypes;
        Assert.checkState((boolean)dataTypes.containsKey((Object)dataTypeID));
        dataTypes.removeAsEntry((Object)dataTypeID);
    }
}

