/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent;

import com.arcway.planagent.IInternalAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgentController;
import com.arcway.planagent.controllinginterface.planagent.INameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInput;
import com.arcway.planagent.planmodel.PlanModelDirectAccessTool;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.anchoring.IAnchoringContext;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanElementModelWrapper;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.TASetPlanElementNamesAndDescriptions;
import com.arcway.planagent.planmodel.transactions.Transaction;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public class AbstractPlanAgent
implements IInternalAbstractPlanAgent,
IAbstractPlanAgent {
    private PlanAgentInput input;
    private IPlanInfo planInfo;
    private PlanModelMgr planModelManager;
    private IPMPlanRO plan;

    public AbstractPlanAgent(PlanAgentInput input) {
        this.input = input;
        this.planInfo = input.getPlanInfo();
    }

    private void activateResourceCache() {
        if (this.plan != null && !this.plan.isResourceCacheActive()) {
            this.plan.activateResourceCache();
        }
    }

    private void deactivateResourceCache() {
        if (this.plan != null && this.plan.isResourceCacheActive()) {
            this.plan.deactivateResourceCache();
        }
    }

    @Override
    public IPMPlanRO loadPlan(IProgressDisplay progressDisplay) throws EXSetupPlanException {
        if (this.getPlanFile().exists()) {
            this.deactivateResourceCache();
            this.setupPlan();
            this.plan = this.planModelManager.getPlan();
            this.activateResourceCache();
        }
        if (this.plan == null) {
            throw new EXSetupPlanException("plan file " + this.getPlanFile().getAbsolutePath() + " does not exist");
        }
        return this.plan;
    }

    @Override
    public IPMPlanRO createPlan() throws EXSetupPlanException {
        this.deactivateResourceCache();
        this.planModelManager = new PlanModelMgr();
        try {
            this.plan = this.planModelManager.create(this.input.getPlanTypeID());
        }
        catch (EXPlanModelObjectFactoryException e) {
            throw new EXSetupPlanException((Throwable)e);
        }
        catch (CoreException e) {
            throw new EXSetupPlanException((Throwable)e);
        }
        catch (PlugInClassExtensionFactoryException e) {
            throw new EXSetupPlanException((Throwable)e);
        }
        this.activateResourceCache();
        return this.plan;
    }

    @Override
    public void setAccessingMode(int newMode) throws EXWriteAccessDeniedException {
        this.input.getPlanAgentController().setAccessingMode(newMode);
    }

    @Override
    public void savePlan(IProgressDisplay progressDisplay) throws IOException, EXWriteAccessDeniedException {
        if (this.planModelManager != null) {
            this.planModelManager.save(this.input.getPlanFile());
            this.input.getPlanAgentController().planFileChanged();
        }
    }

    @Override
    public void closePlan() {
        this.input.getPlanAgentController().close();
        this.deactivateResourceCache();
    }

    @Override
    public IPlanInfo getPlanInfo() {
        return this.planInfo;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getPlanStructure() {
        return this.plan.getPlanStructure();
    }

    private void setupPlan() throws EXSetupPlanException {
        if (this.input.getPlanFile() == null || !this.input.getPlanFile().exists()) {
            return;
        }
        try {
            BufferedInputStream content = new BufferedInputStream(new FileInputStream(this.input.getPlanFile()));
            this.planModelManager = new PlanModelMgr();
            this.plan = this.planModelManager.load((InputStream)content);
        }
        catch (Exception e) {
            this.planModelManager = null;
            throw new EXSetupPlanException("could not load plan file", (Throwable)e);
        }
        this.initLoadedPlan(this.planModelManager);
    }

    private void initLoadedPlan(PlanModelMgr planModelMangerToInit) {
        String forcedName = this.getPlanInfo().getPlanName();
        String forcedUID = this.input.getPlanUID();
        if (forcedUID != null) {
            PlanModelDirectAccessTool.setPlanUID((IPMPlanRO)this.plan, (String)forcedUID);
        }
        if (forcedName != null) {
            PlanModelDirectAccessTool.setPlanName((IPMPlanRO)this.plan, (String)forcedName);
        }
        ((PMPlan)this.plan).getOuterBounds();
        this.updatePlanElementNames((IPMPlanRO)planModelMangerToInit.getPlan());
    }

    protected final void updatePlanElementNames(IPMPlanRO planToUpdate) {
        IAbstractPlanAgentController controller = this.input.getPlanAgentController();
        HashMap<IPMPlanElementRO, INameAndDescriptionAndCommentAndAspectID> planElement2newNames = new HashMap<IPMPlanElementRO, INameAndDescriptionAndCommentAndAspectID>();
        int i = 0;
        while (i < planToUpdate.getPlanElementCount()) {
            IPMPlanElementRO planElement = planToUpdate.getPlanElementRO(i);
            PlanElementModelWrapper modelWrapper = new PlanElementModelWrapper(planElement);
            INameAndDescriptionAndCommentAndAspectID newName = controller.getPlanElementName((IPlanAgentPlanElement)modelWrapper);
            if (newName != null) {
                planElement2newNames.put(planElement, newName);
            }
            ++i;
        }
        this.overridePlanElementNames(planElement2newNames);
    }

    @Override
    public void notifyOfStructureChanges() {
        this.input.getPlanAgentController().planStructureChanged();
    }

    @Override
    public IPMPlanRO getPlan() {
        return this.plan;
    }

    protected final void overridePlanElementNames(Map<IPMPlanElementRO, ? extends INameAndDescriptionAndCommentAndAspectID> pMPlanElement2newNames) {
        if (!pMPlanElement2newNames.isEmpty()) {
            ActionParameters actionParameters = new ActionParameters(IAnchoringContext.DUMMY, IRoutingParameters.DUMMY);
            TASetPlanElementNamesAndDescriptions setNamesTransaction = new TASetPlanElementNamesAndDescriptions(pMPlanElement2newNames, actionParameters);
            this.executeTransaction((Transaction)setNamesTransaction);
        }
    }

    protected final void overridePlanInfo(IPlanInfo newPlanInfo) {
        assert (newPlanInfo != null);
        this.planInfo = newPlanInfo;
        String forcedName = newPlanInfo.getPlanName();
        if (forcedName != null) {
            PlanModelDirectAccessTool.setPlanName((IPMPlanRO)this.plan, (String)forcedName);
        }
    }

    protected final void overridePlanLocation(File file) {
        assert (file != null);
        this.input = new PlanAgentInput(this.input.getPlanUID(), this.input.getPlanTypeID(), file, this.planInfo, this.input.getPlanAgentController());
    }

    private void executeTransaction(Transaction transaction) {
        if (transaction.isValid()) {
            transaction.dodo();
        }
    }

    @Override
    public IPMPlanRO resetPlan() throws EXPlanCreationException {
        PMPlan oldPlan = (PMPlan)this.plan;
        PlanModelMgr newPlanModelMgr = new PlanModelMgr();
        newPlanModelMgr.copy(oldPlan, null);
        this.planModelManager = newPlanModelMgr;
        this.deactivateResourceCache();
        this.plan = this.planModelManager.getPlan();
        this.activateResourceCache();
        return this.plan;
    }

    @Override
    public void importPlan(File planFile, IProgressDisplay loadProgressDisplay) throws EXWriteAccessDeniedException, EXSetupPlanException {
        File oldPlanFile = this.input.getPlanFile();
        this.overridePlanLocation(planFile);
        this.loadPlan(loadProgressDisplay);
        this.input.getPlanAgentController().setPlanTypeID(this.plan.getType());
        try {
            this.input.getPlanAgentController().createPlanRequest(planFile);
        }
        catch (EXWriteAccessDeniedException e) {
            this.overridePlanLocation(oldPlanFile);
            throw e;
        }
    }

    @Override
    public File getPlanFile() {
        return this.input.getPlanFile();
    }

    public FlowType getFlowType() {
        return this.plan.getFlowType();
    }
}

