/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.outputupdater;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planview.outputupdater.POPlanEditPart;
import com.arcway.planagent.planview.view.PVPlanObject;

public abstract class POPlanObject
extends POPlanEditPart {
    protected IPMPlanObjectRO getPMPlanObjectRO() {
        return (IPMPlanObjectRO)this.getModel();
    }

    protected PVPlanObject getPVPlanObject() {
        return (PVPlanObject)this.getPVPlanViewPart();
    }

    @Override
    public void refreshVisuals(IHighlightHint highlight) {
        PVPlanObject viewFigure = this.getPVPlanObject();
        IPMPlanObjectRO modelPlanObject = this.getPMPlanObjectRO();
        viewFigure.setPoints(modelPlanObject.getPointListRO().getPoints());
        super.refreshVisuals(highlight);
    }

    protected static void applyHighlight(IHighlightHint highlight, FillAppearance fillAppearance) {
        if (highlight != null) {
            fillAppearance.setFillColor(POPlanObject.applyHighlightToFillColor(highlight, fillAppearance.getFillColor()));
        }
    }

    protected static void applyHighlight(IHighlightHint highlight, LineAppearance lineAppearance) {
        if (highlight != null) {
            lineAppearance.setLineColor(POPlanObject.applyHighlightToLineColor(highlight, lineAppearance.getLineColor()));
        }
    }

    protected static void applyHighlight(IHighlightHint highlight, LineMarkerAppearance lineMarkerAppearance) {
        if (highlight != null) {
            lineMarkerAppearance.setLineMarkerColor(POPlanObject.applyHighlightToLineColor(highlight, lineMarkerAppearance.getLineMarkerColor()));
            lineMarkerAppearance.setLineMarkerFillColor(POPlanObject.applyHighlightToFillColor(highlight, lineMarkerAppearance.getLineMarkerFillColor()));
        }
    }

    protected static FillColor applyHighlightToFillColor(IHighlightHint highlight, FillColor oldFillColor) {
        FillColor newFillColor = oldFillColor.changeOpacity(highlight.getFillOpacity());
        Color highlightColor = highlight.getFillColor();
        if (highlightColor != null) {
            newFillColor.foregroundColor = POPlanObject.applyHighlightToFillColor(highlight, highlightColor, oldFillColor.foregroundColor);
            newFillColor.backgroundColor = POPlanObject.applyHighlightToFillColor(highlight, highlightColor, oldFillColor.backgroundColor);
        }
        return newFillColor;
    }

    private static Color applyHighlightToFillColor(IHighlightHint highlight, Color highlightColor, Color oldColor) {
        Color newColor = oldColor.transparent ? highlightColor : (highlightColor.transparent ? oldColor : oldColor.goToColor(highlightColor, highlight.getColorWeight()));
        return newColor;
    }

    protected static Color applyHighlightToLineColor(IHighlightHint highlight, Color oldColor) {
        Color highlightColor = highlight.getLineColor();
        Color newColor = highlightColor != null ? oldColor.goToColor(highlightColor, highlight.getColorWeight()) : oldColor;
        return newColor;
    }
}

