/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.outputupdater;

import com.arcway.planagent.planmodel.access.readonly.IPMFigureDotRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMGraphicalSupplementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.nonpermanent.PMArrow;
import com.arcway.planagent.planmodel.nonpermanent.PMDecorator;
import com.arcway.planagent.planmodel.nonpermanent.PMLegend;
import com.arcway.planagent.planmodel.nonpermanent.PMMarker;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planview.outputupdater.EXOutputUpdaterFactoryException;
import com.arcway.planagent.planview.outputupdater.POArrow;
import com.arcway.planagent.planview.outputupdater.PODecorator;
import com.arcway.planagent.planview.outputupdater.POFigureDot;
import com.arcway.planagent.planview.outputupdater.POFigureLineShape;
import com.arcway.planagent.planview.outputupdater.POFigurePlane;
import com.arcway.planagent.planview.outputupdater.POGraphicalSupplementFactoryDispatcher;
import com.arcway.planagent.planview.outputupdater.POLegend;
import com.arcway.planagent.planview.outputupdater.POMarker;
import com.arcway.planagent.planview.outputupdater.POOutputUpdater;
import com.arcway.planagent.planview.outputupdater.POPlan;
import com.arcway.planagent.planview.outputupdater.POPlanElement;
import com.arcway.planagent.planview.outputupdater.POProjection;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import org.eclipse.core.runtime.CoreException;

public class POOutputUpdaterFactory {
    public POOutputUpdater createOutputUpdater(Object model) {
        POOutputUpdater outputUpdater = null;
        if (model instanceof IPMPlanRO) {
            outputUpdater = new POPlan();
        } else if (model instanceof IPMPlanElementRO) {
            outputUpdater = new POPlanElement();
        } else if (model instanceof IPMFigurePlaneRO) {
            outputUpdater = new POFigurePlane();
        } else if (model instanceof IPMFigureLineShapeRO) {
            outputUpdater = new POFigureLineShape();
        } else if (model instanceof IPMFigureDotRO) {
            outputUpdater = new POFigureDot();
        } else if (model instanceof IPMGraphicalSupplementRO) {
            try {
                outputUpdater = POGraphicalSupplementFactoryDispatcher.getInstance().create((IPMGraphicalSupplementRO)model);
            }
            catch (PlugInClassExtensionFactoryException e) {
                throw new RuntimeException(e);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            catch (EXOutputUpdaterFactoryException e) {
                throw new RuntimeException(e);
            }
        } else if (model instanceof PMProjection) {
            outputUpdater = new POProjection();
        } else if (model instanceof PMLegend) {
            outputUpdater = new POLegend();
        } else if (model instanceof PMMarker) {
            outputUpdater = new POMarker();
        } else if (model instanceof PMDecorator) {
            outputUpdater = new PODecorator();
        } else if (model instanceof PMArrow) {
            outputUpdater = new POArrow();
        } else {
            throw new IllegalArgumentException();
        }
        outputUpdater.setModel(model);
        return outputUpdater;
    }
}

