/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.outputupdater;

import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planview.outputupdater.POFigure;
import com.arcway.planagent.planview.view.HighlightHint;
import com.arcway.planagent.planview.view.PVFigureLineShape;
import com.arcway.planagent.planview.view.PVPlanViewPart;

public class POFigureLineShape
extends POFigure {
    @Override
    public void refreshVisuals(IHighlightHint highlight) {
        IPMFigureLineShapeRO modelFigure = this.getPMFigureLineShapeRO();
        PVFigureLineShape viewFigure = this.getPVFigureLineShape();
        IHighlightHint highlightToUse = highlight;
        if (HighlightHint.isEmpty(highlightToUse)) {
            IPMPointListRO pointList = modelFigure.getPointListRO();
            modelFigure.getPlanElementRO().getEditIPMFiguresRO();
            int pointCount = pointList.getPointCount();
            if (pointCount >= 1) {
                IHighlightHint businessHighlightHintOfStartFigure = POFigureLineShape.getBusinessHighlightOfNeighbourFigure(pointList.getPointRO(0));
                IHighlightHint businessHighlightHintOfEndFigure = POFigureLineShape.getBusinessHighlightOfNeighbourFigure(pointList.getPointRO(pointCount - 1));
                highlightToUse = HighlightHint.min(businessHighlightHintOfStartFigure, businessHighlightHintOfEndFigure);
            }
        }
        LineMarkerAppearance startMarker = new LineMarkerAppearance((ILineMarkerAppearanceRO)modelFigure.getLineStartMarkerAppearanceRO());
        LineMarkerAppearance endMarker = new LineMarkerAppearance((ILineMarkerAppearanceRO)modelFigure.getLineEndMarkerAppearanceRO());
        if (this.isHighlightable() && !HighlightHint.isEmpty(highlightToUse)) {
            POFigureLineShape.applyHighlight(highlightToUse, startMarker);
        }
        if (this.isHighlightable() && !HighlightHint.isEmpty(highlightToUse)) {
            POFigureLineShape.applyHighlight(highlightToUse, endMarker);
        }
        viewFigure.setLineStartMarkerAppearance((ILineMarkerAppearanceRO)startMarker);
        viewFigure.setLineEndMarkerAppearance((ILineMarkerAppearanceRO)endMarker);
        super.refreshVisuals(highlightToUse);
    }

    private static IHighlightHint getBusinessHighlightOfNeighbourFigure(IPMPointRO point) {
        IHighlightRequest highlightRequest = POFigureLineShape.getBusinessHighlightRequestOfNeighbourFigure(point);
        Object highlightHint = highlightRequest != null ? highlightRequest.getHighlightHint() : new HighlightHint();
        return highlightHint;
    }

    private static IHighlightRequest getBusinessHighlightRequestOfNeighbourFigure(IPMPointRO point) {
        PMHighlight pmHighlight;
        IAnchoringSource rootSource = point.getPlanElementRO().getRootSource(point);
        Object anchoring = rootSource != null ? rootSource.getIAnchoring() : point.getAnchoringRO();
        IHighlightRequest highlightRequestOfNeighbourFigure = anchoring != null ? ((pmHighlight = anchoring.getAnchoringDestination().getAnchoringFigure().getPlanElementRO().getHighlight(HighlightLevel.BUSINESS)) != null ? pmHighlight.getHighlightRequest() : null) : null;
        return highlightRequestOfNeighbourFigure;
    }

    @Override
    public PVPlanViewPart createPlanViewPart() {
        this.setView(new PVFigureLineShape());
        return this.getPVFigureLineShape();
    }

    private IPMFigureLineShapeRO getPMFigureLineShapeRO() {
        return (IPMFigureLineShapeRO)this.getPMFigureRO();
    }

    private PVFigureLineShape getPVFigureLineShape() {
        return (PVFigureLineShape)this.getPVFigure();
    }
}

