/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.fmc.bd.view;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linemarkers.LineMarkerRoundedArc;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.FMCBDRequestSymbolAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearanceRO;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementRequestSymbol
extends PVGraphicalSupplement {
    private FMCBDRequestSymbolAppearance requestSymbolAppearance;

    public void setRequestSymbolAppearance(IFMCBDRequestSymbolAppearance requestSymbolAppearance) {
        this.requestSymbolAppearance = new FMCBDRequestSymbolAppearance((IFMCBDRequestSymbolAppearanceRO)requestSymbolAppearance);
    }

    public void drawFigure(Device device) {
        TextAppearance textAppearance = new TextAppearance();
        TextStyle textStyle = textAppearance.getTextStyle();
        Alignment textAlignment = textAppearance.getAlignment();
        textAlignment.h = 2;
        textAlignment.v = 16;
        assert (this.requestSymbolAppearance.getColor() != null) : "getColor returned NULL.";
        Color color = this.requestSymbolAppearance.getColor();
        FillColor fillColor = new FillColor(color);
        double size = this.requestSymbolAppearance.getSize();
        double lineThickness = size / 10.0;
        assert (this.getPoints() != null) : "getPoints returned NULL.";
        Point centerPoint = this.getPoints().get(0);
        assert (centerPoint != null) : "centerPoint is NULL.";
        Direction direction = this.requestSymbolAppearance.getDirection();
        double alphaInDegrees = direction.getAngle();
        GeoVector toRight = new GeoVector(size, direction);
        Point c1 = centerPoint.movePoint(toRight);
        Point tc = centerPoint.movePoint(toRight.scale((double)-0.4f));
        Direction textDirection = direction.isInInvervall(-90.0, 90.0) ? direction : direction.turn180();
        TurnedRectangle bounds = new TurnedRectangle(tc, new Dimension(2.0 * size, 2.0 * size), textDirection);
        device.text(bounds, textAlignment, "R", textStyle, size, color, false);
        LineMarkerRoundedArc lm = new LineMarkerRoundedArc();
        lm.draw(device, c1, color, lineThickness, fillColor, alphaInDegrees, 0.0);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }

    public boolean isInside(Point p, double tolerance) {
        return this.getOuterBoundsWithoutChildrenByDrawing().isInside(p);
    }
}

