/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.cm.view;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementText
extends PVGraphicalSupplement {
    private static final ILogger logger = Logger.getLogger(PVGraphicalSupplementText.class);
    private TextAppearance textAppearance;
    private String text;

    public void setTextAppearance(ITextAppearance textAppearance) {
        this.textAppearance = new TextAppearance((ITextAppearanceRO)textAppearance);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void drawFigure(Device device) {
        assert (this.textAppearance != null) : "textAppearance is NULL.";
        TextStyle textStyle = this.textAppearance.getTextStyle();
        Alignment textAlignment = this.textAppearance.getAlignment();
        Direction direction = this.textAppearance.getDirection();
        Color textColor = this.textAppearance.getTextColor();
        double textHeight = this.textAppearance.getTextLineHeight();
        Insets textInsets = this.textAppearance.getInsets();
        assert (this.getPoints().getBounds() != null) : "getBounds or getPoints returned NULL.";
        assert (textAlignment != null) : "textAlignment is NULL.";
        assert (textStyle != null) : "textStyle is NULL";
        assert (textHeight > 0.0) : "textHeight is zero or less.";
        assert (textColor != null) : "textColor is NULL.";
        this.drawGhostOutline(device);
        TurnedRectangle turnedRectangle = PMGraphicalSupplementText.calculateTextRectangle((Points)this.getPoints(), (Direction)direction, (Insets)textInsets);
        if (!textInsets.isZero()) {
            this.drawGhostRectangle(device, turnedRectangle);
        }
        device.text(turnedRectangle, textAlignment, this.text, textStyle, textHeight, textColor, true);
    }

    public boolean isInside(Point p, double tolerance) {
        Insets textInsets = this.textAppearance.getInsets();
        Rectangle textBoundary = PMGraphicalSupplementText.calculateTextBoundary((Points)this.getPoints(), (Insets)textInsets);
        return textBoundary.isInside(p);
    }
}

