/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACCreate1Point;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPointToFigure;
import com.arcway.planagent.planmodel.actions.ACSetLineForce;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedLengthActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.routing.AbstractElongationToFigureRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import java.util.ArrayList;

public class ElongationToFigureOutlineRouter
extends AbstractElongationToFigureRouter {
    private static final int PREV = 1;
    private static final int NEXT = 2;
    private ActionContext actionContext;
    private IAnchoringSourcePoint sourcePoint;
    private IAnchoringDestinationLine destination;

    public ElongationToFigureOutlineRouter() {
        super(IAnchoringDestinationLine.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionIterator routeWhenClassesAreChecked(IAnchoringSource source, IAnchoringDestination dest, ActionContext actionCntxt, IRoutingParameters routingParameters, IRoutingManager routingManager) {
        boolean nextAnchoringDetected;
        this.sourcePoint = (IAnchoringSourcePoint)source;
        this.destination = (IAnchoringDestinationLine)dest;
        this.actionContext = actionCntxt;
        IAnchoringSourcePoint.Force sourcePointForce = this.sourcePoint.getForce();
        IPMPointRO firstPoint = ((IPMLineRO)this.destination).getPoint1stRO();
        IPMPointRO secondPoint = ((IPMLineRO)this.destination).getPoint2ndRO();
        IPMPointRO prevPoint = this.getDestinationEndPoint((IAnchoringDestinationLine)dest, 1);
        IPMPointRO nextPoint = this.getDestinationEndPoint((IAnchoringDestinationLine)dest, 2);
        IAnchoring prevAnchoring = null;
        IAnchoring nextAnchoring = null;
        if (prevPoint != null) {
            prevAnchoring = prevPoint.getIAnchoring();
        }
        if (nextPoint != null) {
            nextAnchoring = nextPoint.getIAnchoring();
        }
        boolean prevAnchoringDetected = prevAnchoring != null && prevAnchoring instanceof IAnchoringPoint2Figure;
        boolean bl = nextAnchoringDetected = nextAnchoring != null && nextAnchoring instanceof IAnchoringPoint2Figure;
        if (prevAnchoringDetected && nextAnchoringDetected) {
            IPMPointRO point = null;
            if (firstPoint.getPosition().equalsPoint(this.sourcePoint.getAnchoringSourcePosition())) {
                point = firstPoint;
            } else if (secondPoint.getPosition().equalsPoint(this.sourcePoint.getAnchoringSourcePosition())) {
                point = secondPoint;
            }
            if (point != null) {
                IPMLineRO line1st = point.getLine1stRO();
                IPMLineRO line2nd = point.getLine2ndRO();
                int line1stForce = 1;
                int line2ndForce = 1;
                if (line1st != null) {
                    line1stForce = line1st.getForce();
                }
                if (line2nd != null) {
                    line2ndForce = line2nd.getForce();
                }
                IPMLineRO matchingLine = null;
                int direction = 0;
                if (sourcePointForce.equals(IAnchoringSourcePoint.FORCE_HORIZONTAL)) {
                    if (line1stForce == 2) {
                        matchingLine = line1st;
                        direction = 1;
                    } else if (line2ndForce == 2) {
                        matchingLine = line2nd;
                        direction = 2;
                    }
                } else if (sourcePointForce.equals(IAnchoringSourcePoint.FORCE_VERTICAL)) {
                    if (line1stForce == 3) {
                        matchingLine = line1st;
                        direction = 1;
                    } else if (line2ndForce == 3) {
                        matchingLine = line2nd;
                        direction = 2;
                    }
                }
                if (matchingLine == null) return null;
                return new FollowLineActionIterator(matchingLine, direction);
            }
            int direction = -1;
            Point srcPointPos = this.sourcePoint.getAnchoringSourcePosition();
            Point srcPointLineOtherEndPoint = null;
            IPMLineRO srcPointLine1st = ((IPMPointRO)this.sourcePoint).getLine1stRO();
            IPMLineRO srcPointLine2nd = ((IPMPointRO)this.sourcePoint).getLine2ndRO();
            if (srcPointLine1st != null) {
                srcPointLineOtherEndPoint = srcPointLine1st.getPoint1stRO().getPosition();
            } else if (srcPointLine2nd != null) {
                srcPointLineOtherEndPoint = srcPointLine2nd.getPoint2ndRO().getPosition();
            }
            if (srcPointLineOtherEndPoint != null) {
                if (sourcePointForce.equals(IAnchoringSourcePoint.FORCE_HORIZONTAL)) {
                    if (((IPMLineRO)this.destination).getForce() == 2) {
                        double firstPointX = firstPoint.getPosition().x;
                        double srcPointX = srcPointPos.x;
                        double srcPointLineOtherEndPointX = srcPointLineOtherEndPoint.x;
                        double secondPointX = secondPoint.getPosition().x;
                        if (firstPointX < srcPointX && firstPointX < srcPointLineOtherEndPointX || firstPointX > srcPointX && firstPointX > srcPointLineOtherEndPointX) {
                            direction = 1;
                        } else if (secondPointX < srcPointX && secondPointX < srcPointLineOtherEndPointX || secondPointX > srcPointX && secondPointX > srcPointLineOtherEndPointX) {
                            direction = 2;
                        }
                    }
                } else if (sourcePointForce.equals(IAnchoringSourcePoint.FORCE_VERTICAL) && ((IPMLineRO)this.destination).getForce() == 3) {
                    double firstPointY = firstPoint.getPosition().y;
                    double srcPointY = srcPointPos.y;
                    double srcPointLineOtherEndPointY = srcPointLineOtherEndPoint.y;
                    double secondPointY = secondPoint.getPosition().y;
                    if (firstPointY < srcPointY && firstPointY < srcPointLineOtherEndPointY || firstPointY > srcPointY && firstPointY > srcPointLineOtherEndPointY) {
                        direction = 1;
                    } else if (secondPointY < srcPointY && secondPointY < srcPointLineOtherEndPointY || secondPointY > srcPointY && secondPointY > srcPointLineOtherEndPointY) {
                        direction = 2;
                    }
                }
            }
            if (direction != -1) return new FollowLineActionIterator((IPMLineRO)this.destination, direction);
            direction = 1;
            if (prevAnchoring == null) return new FollowLineActionIterator((IPMLineRO)this.destination, direction);
            if (nextAnchoring == null) return new FollowLineActionIterator((IPMLineRO)this.destination, direction);
            Point prevAnchoringPos = ((IAnchoringSourcePoint)prevAnchoring.getAnchoringSource()).getAnchoringSourcePosition();
            Point nextAnchoringPos = ((IAnchoringSourcePoint)nextAnchoring.getAnchoringSource()).getAnchoringSourcePosition();
            GeoVector source2prev = new GeoVector(prevAnchoringPos, this.sourcePoint.getAnchoringSourcePosition());
            GeoVector source2next = new GeoVector(nextAnchoringPos, this.sourcePoint.getAnchoringSourcePosition());
            if (!(source2next.abs() < source2prev.abs())) return new FollowLineActionIterator((IPMLineRO)this.destination, direction);
            direction = 2;
            return new FollowLineActionIterator((IPMLineRO)this.destination, direction);
        }
        if (prevAnchoringDetected) {
            return new FollowLineActionIterator((IPMLineRO)this.destination, 1);
        }
        if (!nextAnchoringDetected) return null;
        return new FollowLineActionIterator((IPMLineRO)this.destination, 2);
    }

    protected Point getFigurePoint(IAnchoringSourcePoint srcPoint, IAnchoringDestination dest) {
        return srcPoint.getAnchoringSourcePosition();
    }

    protected boolean justElongatesForcedLines() {
        return true;
    }

    private IPMPointRO getDestinationEndPoint(IAnchoringDestinationLine dest, int direction) {
        IPMPointRO firstPoint = null;
        if (dest != null) {
            IPMPointListRO pointList;
            IPMLineRO line = (IPMLineRO)dest;
            if (direction == 1) {
                IPMPointListRO pointList2 = line.getPointListRO();
                if (pointList2.getPointCount() > pointList2.getLineCount() && (firstPoint = line.getPoint1stRO()).getLine1stRO() != null) {
                    firstPoint = this.getDestinationEndPoint((IAnchoringDestinationLine)firstPoint.getLine1stRO(), direction);
                }
            } else if (direction == 2 && (pointList = line.getPointListRO()).getPointCount() > pointList.getLineCount() && (firstPoint = line.getPoint2ndRO()).getLine2ndRO() != null) {
                firstPoint = this.getDestinationEndPoint((IAnchoringDestinationLine)firstPoint.getLine2ndRO(), direction);
            }
        }
        return firstPoint;
    }

    private class FollowLineActionIterator
    extends PredeterminedLengthActionIterator {
        private static final int NUMBER_OF_STEPS_NEEDED_PER_POINT = 3;
        private final int direction;
        private final IPMLineRO lineToFollow;
        private Points missingPoints;
        private int noOfActionSteps;

        public FollowLineActionIterator(IPMLineRO line, int direction) {
            this.lineToFollow = line;
            this.direction = direction;
            this.calcMissingPoints();
        }

        public Action createNextAction(ArrayList<Action> previousActions, int n) {
            ACCreate1Point nextAction = null;
            int lineForce = 1;
            IPMLineRW lineToSplit = null;
            if (((IPMPointRW)ElongationToFigureOutlineRouter.this.sourcePoint).getLine1stRW() != null) {
                lineToSplit = ((IPMPointRW)ElongationToFigureOutlineRouter.this.sourcePoint).getLine1stRW();
            } else if (((IPMPointRW)ElongationToFigureOutlineRouter.this.sourcePoint).getLine2ndRW() != null) {
                lineToSplit = ((IPMPointRW)ElongationToFigureOutlineRouter.this.sourcePoint).getLine2ndRW();
            }
            if (lineToSplit != null && n < this.noOfActionSteps) {
                int i = n < 3 ? n : n % 3;
                switch (i) {
                    case 0: {
                        nextAction = new ACCreate1Point(ElongationToFigureOutlineRouter.this.actionContext, (IPMPointRW)ElongationToFigureOutlineRouter.this.sourcePoint, lineToSplit);
                        break;
                    }
                    case 1: {
                        ACCreate1Point create1PointAction = (ACCreate1Point)previousActions.get(n - 1);
                        switch (lineToSplit.getForce()) {
                            case 2: {
                                lineForce = 3;
                                break;
                            }
                            case 3: {
                                lineForce = 2;
                            }
                        }
                        nextAction = new ACSetLineForce(ElongationToFigureOutlineRouter.this.actionContext, create1PointAction.getCreatedLine(), lineForce);
                        break;
                    }
                    case 2: {
                        nextAction = ActionFactory.createACMovePoint((ActionContext)ElongationToFigureOutlineRouter.this.actionContext, (IAnchoringSourcePoint)ElongationToFigureOutlineRouter.this.sourcePoint, (GeoVector)new GeoVector(ElongationToFigureOutlineRouter.this.getFigurePoint(ElongationToFigureOutlineRouter.this.sourcePoint, (IAnchoringDestination)ElongationToFigureOutlineRouter.this.destination), this.missingPoints.get((n + 1) / 3 - 1)), (boolean)true);
                    }
                }
            } else if (n == this.noOfActionSteps) {
                IPMPointRO point = ElongationToFigureOutlineRouter.this.getDestinationEndPoint(ElongationToFigureOutlineRouter.this.destination, this.direction);
                nextAction = new ACCreateAnchoringPointToFigure(ElongationToFigureOutlineRouter.this.actionContext, (IPMPointRW)ElongationToFigureOutlineRouter.this.sourcePoint, (IPMFigureRW)point.getAnchoringRO().getAnchoringDestination().getAnchoringFigure());
            }
            return nextAction;
        }

        public boolean hasNextAfter(int n) {
            return n <= this.noOfActionSteps;
        }

        /*
         * Unable to fully structure code
         */
        private void calcMissingPoints() {
            block2: {
                this.missingPoints = new Points();
                line = this.lineToFollow;
                if (this.direction != 2) ** GOTO lbl13
                while (line != null) {
                    point = line.getPoint2ndRO();
                    this.missingPoints.add(point.getPosition());
                    line = point.getLine2ndRO();
                }
                break block2;
lbl-1000:
                // 1 sources

                {
                    point = line.getPoint1stRO();
                    this.missingPoints.add(point.getPosition());
                    line = point.getLine1stRO();
lbl13:
                    // 2 sources

                    ** while (line != null)
                }
            }
            this.noOfActionSteps = this.missingPoints.size() * 3;
        }
    }
}

