/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACCreate1Point;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ACSetLineForce;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedLengthActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.routing.ICurveLineRouter;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToFigure;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import java.util.ArrayList;
import java.util.Collection;

public class CurveLineRouterInCaseOfMovingProcessor
implements ICurveLineRouter {
    ActionContext actionContext;
    IRoutingParameters routingParameters;
    IPMPointRW endPoint;
    IPMLineRW line = null;
    IAnchoringDestination destination;
    Polygon polygon;
    int lineForce = -1;
    boolean differentDestinationAtBothEdgeEnds;
    boolean isRoutingFromInsideDestinationFigure;
    IPMPointRW startPoint;
    private Collection<? extends IAnchoring> anchorings;
    private boolean endPointMoved = false;

    @Override
    public ActionIterator getRoutProcessingActionIterator(IAnchoringSource src, IAnchoringDestination dest, ActionContext actionCntxt, IRoutingParameters routingPara) {
        if (!(src instanceof IPMPointRW)) {
            return null;
        }
        this.routingParameters = routingPara;
        this.actionContext = actionCntxt;
        this.destination = dest;
        IAnchoringDestinationFigure destinationFigure = (IAnchoringDestinationFigure)dest;
        this.anchorings = destinationFigure.getIAnchorings();
        IAnchoringSourcePoint sourcePoint = (IAnchoringSourcePoint)src;
        this.endPoint = (IPMPointRW)sourcePoint;
        Object actionIterator = null;
        if (!(this.endPoint.getPlanObjectRW() instanceof IPMFigureRW)) {
            return null;
        }
        if (this.endPoint.getLine1stRW() == null) {
            this.line = this.endPoint.getLine2ndRW();
        } else if (this.endPoint.getLine2ndRW() == null) {
            this.line = this.endPoint.getLine1stRW();
        } else assert (false) : "endPoint is not an endpoint!";
        boolean isSingleLineWithTwoPoints = this.isSingleLineWithTwoPoints(this.line);
        if (this.polygon == null) {
            Corners corners = new Corners(destinationFigure.getAnchoringDestinationPosition(), 0.0);
            this.polygon = new Polygon(corners, destinationFigure.isAnchoringDestinationClosedDraw());
        }
        GeoVector distanceOfTargetFigure = this.routingParameters.getDistanceWhenFiguresAreMoved((IPMFigureRW)this.destination.getAnchoringFigure());
        if (isSingleLineWithTwoPoints && this.line.getForce() != 1) {
            GeoVector distance = distanceOfTargetFigure;
            boolean noBending = false;
            if (distance.x == 0.0 && this.line.getForce() == 3 || distance.y == 0.0 && this.line.getForce() == 2) {
                noBending = true;
            }
            if (noBending) {
                actionIterator = new PredeterminedActionIterator(1);
                actionIterator.addAction((Action)ActionFactory.createACMovePoint((ActionContext)actionCntxt, (IAnchoringSourcePoint)this.endPoint, (GeoVector)distanceOfTargetFigure, (boolean)false));
                this.endPointMoved = this.endPointMoved || !distanceOfTargetFigure.isZero();
            } else {
                actionIterator = new PredeterminedLengthActionIterator(){

                    public boolean hasNextAfter(int n) {
                        return n < 6;
                    }

                    public Action createNextAction(ArrayList<Action> previousActions, int n) {
                        return CurveLineRouterInCaseOfMovingProcessor.this.createActionInCaseOfBending(n, previousActions);
                    }
                };
            }
        } else {
            actionIterator = new PredeterminedActionIterator(1);
            actionIterator.addAction((Action)ActionFactory.createACMovePoint((ActionContext)actionCntxt, (IAnchoringSourcePoint)this.endPoint, (GeoVector)distanceOfTargetFigure, (boolean)false));
            this.endPointMoved = this.endPointMoved || !distanceOfTargetFigure.isZero();
        }
        return actionIterator;
    }

    private boolean isSingleLineWithTwoPoints(IPMLineRW ln) {
        IPMLineRW preLine = ln.getPoint1stRW().getLine1stRW();
        IPMLineRW postLine = ln.getPoint2ndRW().getLine2ndRW();
        boolean onlyTwoPoints = false;
        if (preLine == null && postLine == null) {
            onlyTwoPoints = true;
        }
        return onlyTwoPoints;
    }

    /*
     * WARNING - void declaration
     */
    private Action createActionInCaseOfBending(int n, ArrayList<Action> previousActions) {
        ACMovePoint nextAction = null;
        switch (n) {
            case 0: {
                if (this.endPoint.getLine1stRW() == null) {
                    this.startPoint = this.endPoint.getLine2ndRW().getPoint2ndRW();
                } else if (this.endPoint.getLine2ndRW() == null) {
                    this.startPoint = this.endPoint.getLine1stRW().getPoint1stRW();
                } else assert (false) : "endPoint is no endPoint!";
                nextAction = new ACCreate1Point(this.actionContext, this.endPoint, this.line);
                break;
            }
            case 1: {
                ACCreate1Point create1PointAction = (ACCreate1Point)previousActions.get(0);
                this.lineForce = 1;
                switch (this.line.getForce()) {
                    case 2: {
                        this.lineForce = 3;
                        break;
                    }
                    case 3: {
                        this.lineForce = 2;
                    }
                }
                nextAction = new ACSetLineForce(this.actionContext, create1PointAction.getCreatedLine(), this.lineForce);
                break;
            }
            case 2: {
                if (this.endPoint.getLine1stRW() == null) {
                    this.line = this.endPoint.getLine2ndRW();
                } else if (this.endPoint.getLine2ndRW() == null) {
                    this.line = this.endPoint.getLine1stRW();
                } else assert (false) : "endPoint is not an endpoint!";
                nextAction = new ACCreate1Point(this.actionContext, this.endPoint, this.line);
                break;
            }
            case 3: {
                ACCreate1Point create1PointAction = (ACCreate1Point)previousActions.get(2);
                this.lineForce = 1;
                switch (this.line.getForce()) {
                    case 2: {
                        this.lineForce = 3;
                        break;
                    }
                    case 3: {
                        this.lineForce = 2;
                    }
                }
                nextAction = new ACSetLineForce(this.actionContext, create1PointAction.getCreatedLine(), this.lineForce);
                break;
            }
            case 4: {
                GeoVector distanceOfTargetFigure = this.routingParameters.getDistanceWhenFiguresAreMoved((IPMFigureRW)this.destination.getAnchoringFigure());
                nextAction = ActionFactory.createACMovePoint((ActionContext)this.actionContext, (IAnchoringSourcePoint)this.endPoint, (GeoVector)distanceOfTargetFigure, (boolean)false);
                this.endPointMoved = this.endPointMoved || !distanceOfTargetFigure.isZero();
                break;
            }
            case 5: {
                Point newPosition = this.endPoint.getPosition();
                Point targetPoint = null;
                IPMPointRW movePoint = null;
                int lineForceForMoving = 1;
                if (this.endPoint.getLine1stRW() == null) {
                    movePoint = this.endPoint.getLine2ndRW().getPoint2ndRW();
                    lineForceForMoving = this.endPoint.getLine2ndRW().getForce();
                } else if (this.endPoint.getLine2ndRW() == null) {
                    movePoint = this.endPoint.getLine1stRW().getPoint1stRW();
                    lineForceForMoving = this.endPoint.getLine1stRW().getForce();
                } else assert (false) : "endPoint is no endPoint!";
                PMPoint anchorPoint = null;
                IPMLineRW anchorPointLine = null;
                for (IAnchoring iAnchoring : this.anchorings) {
                    if (!(iAnchoring instanceof PMAnchoringPointToFigure)) continue;
                    anchorPoint = (PMPoint)iAnchoring.getAnchoringSource();
                    if (anchorPoint.getLine1stRW() == null) {
                        anchorPointLine = anchorPoint.getLine2ndRW();
                    } else if (anchorPoint.getLine2ndRW() == null) {
                        anchorPointLine = anchorPoint.getLine1stRW();
                    }
                    Point anchorPointPos = anchorPoint.getPosition();
                    Point endPointPos = this.endPoint.getPosition();
                    if (anchorPointPos.equalsPoint(endPointPos) && !anchorPoint.equals(this.endPoint) && !this.isSingleLineWithTwoPoints(anchorPointLine)) break;
                    anchorPoint = null;
                }
                Object var10_18 = null;
                if (anchorPoint != null) {
                    if (anchorPoint.getLine1stRW() == null) {
                        IPMPointRW iPMPointRW = anchorPoint.getLine2ndRW().getPoint2ndRW();
                    } else if (anchorPoint.getLine2ndRW() == null) {
                        IPMPointRW iPMPointRW = anchorPoint.getLine1stRW().getPoint1stRW();
                    }
                    switch (lineForceForMoving) {
                        case 2: {
                            void var10_21;
                            double xPos = var10_21.getPosition().x;
                            targetPoint = new Point(xPos, newPosition.y);
                            break;
                        }
                        case 3: {
                            void var10_21;
                            double yPos = var10_21.getPosition().y;
                            targetPoint = new Point(newPosition.x, yPos);
                        }
                    }
                } else {
                    switch (lineForceForMoving) {
                        case 2: {
                            targetPoint = new Point((newPosition.x + this.startPoint.getPosition().x) / 2.0, newPosition.y);
                            break;
                        }
                        case 3: {
                            targetPoint = new Point(newPosition.x, (newPosition.y + this.startPoint.getPosition().y) / 2.0);
                        }
                    }
                }
                assert (movePoint != null) : "movePoint is null!";
                GeoVector distance = new GeoVector(movePoint.getPosition(), targetPoint);
                nextAction = ActionFactory.createACMovePoint((ActionContext)this.actionContext, (IAnchoringSourcePoint)movePoint, (GeoVector)distance, (boolean)false);
            }
        }
        return nextAction;
    }

    @Override
    public boolean endPointMoved() {
        return this.endPointMoved;
    }
}

