/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.oc.transactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpre.oc.access.readonly.IPMPlanElementBPREOCEdgeRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateBPREOCEdge
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private Points edgePoints;
    private int[] edgeForce;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fill;
    private IPMPlanElementBPREOCEdgeRO createdEdge;

    public TACreateBPREOCEdge(IPMPlanRO plan, ActionParameters actionParameters, Points edgePoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "ILineAppearance is null";
        this.transactionAssertion(edgePoints.size() >= 4, "not enough points describing agent figure");
        this.transactionAssertion(Geo.equals((double)0.0, (double)lineAppearance.getCornerRadius()), "the agent's corner radius is not 0");
        try {
            this.edgePoints = edgePoints;
            this.edgeForce = LineHelper.createAlternatingLineForcesClosed((Points)edgePoints);
            this.lineAppearance = lineAppearance;
            this.fill = fillAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createEdgeAction();
            }
            case 1: {
                this.createdEdge = (IPMPlanElementBPREOCEdgeRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return null;
    }

    private Action createEdgeAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "bpre.oc.edge");
    }

    private Action createOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "outline", previousAction.getCreatedPlanElement(), this.edgePoints, this.edgeForce, this.lineAppearance, this.fill, false);
    }

    public IPMPlanElementBPREOCEdgeRO getCreatedEdge() {
        return this.createdEdge;
    }

    public String toString() {
        return "TACreateBPREOCEdge(Points " + this.edgePoints + ")";
    }
}

