/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.ACNOP;
import com.arcway.planagent.planmodel.actions.ACRemoveGraphicalSupplement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDGatewayRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDGatewayRW;
import com.arcway.planagent.planmodel.bpmn.bpd.appearance.IBPMNBPDLogicalOperatorSymbolAppearanceRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public abstract class TACreateBPMNBPDLogicalOperatorSymbol
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private IBPMNBPDLogicalOperatorSymbolAppearanceRO appearance;
    private final IPMFigureRW logicalOperatorFigure;
    private Points points;
    private int[] force;

    public TACreateBPMNBPDLogicalOperatorSymbol(IPMPlanElementBPMNBPDGatewayRO logicalOperator, ActionParameters actionParameters, Points points, IBPMNBPDLogicalOperatorSymbolAppearanceRO appearance) {
        super(2, (IPMPlanModelObjectRW)logicalOperator, actionParameters);
        assert (appearance != null) : "appearance is null";
        this.transactionAssertion(points.size() == 4, "number of points describing the symbol figure != 4");
        this.logicalOperatorFigure = (IPMFigureRW)logicalOperator.getOutlineFigureRO();
        try {
            this.points = points;
            this.force = LineHelper.createAlternatingLineForcesClosed((Points)points);
            this.appearance = appearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                IPMPlanElementBPMNBPDGatewayRW planElement;
                if (this.logicalOperatorFigure.getPlanElementRW() instanceof IPMPlanElementBPMNBPDGatewayRW && (planElement = (IPMPlanElementBPMNBPDGatewayRW)this.logicalOperatorFigure.getPlanElementRW()).getLogicalOperatorSymbolRW() != null) {
                    return new ACRemoveGraphicalSupplement(this.getActionContext(), (IPMGraphicalSupplementRW)planElement.getLogicalOperatorSymbolRW());
                }
                return new ACNOP((IPMPlanModelObjectRW)this.logicalOperatorFigure, this.getActionContext());
            }
            case 1: {
                return this.createSupplementAction();
            }
        }
        return null;
    }

    protected abstract Action createSupplementAction();

    protected Points getPoints() {
        return this.points;
    }

    protected int[] getForce() {
        return this.force;
    }

    protected IPMFigureRW getLogicalOperatorFigure() {
        return this.logicalOperatorFigure;
    }

    protected IBPMNBPDLogicalOperatorSymbolAppearanceRO getAppearanceRO() {
        return this.appearance;
    }
}

