/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.edit.IZoomMgr;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.Cursors;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseButtonReleased;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.IRectangleFeedback;
import com.arcway.planagent.planeditor.tools.InputEvent;
import com.arcway.planagent.planeditor.tools.RectangleFeedbackFactory;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Cursor;

public class IPMagnifyByClickNDrag
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPMagnifyByClickNDrag.class);
    private static final double BORDER_AFTER_ZOOM_IN_PIXELS = 0.0;
    private final IRectangleFeedback feedback = RectangleFeedbackFactory.createRectangleFeedback();
    IFigure feedbackLayer = null;
    private boolean dragInProgress = false;
    private Point startPoint = null;

    protected IPMagnifyByClickNDrag(GenericTool tool) {
        super(tool);
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (this.dragInProgress) {
            if (this.doesUserWishToCancel(event)) {
                this.cancel();
                return 1;
            }
            if (event instanceof IEMouseMove) {
                IEMouseMove moveEvent = (IEMouseMove)event;
                this.handleDragInProgress(moveEvent.getCurrentPosition());
            } else if (event instanceof IEMouseButtonReleased && !this.getTool().getState().isMouseButtonDown(1)) {
                IEMouseButtonReleased releaseEvent = (IEMouseButtonReleased)event;
                this.handleFinishDrag(releaseEvent.getCurrentPosition());
                return 1;
            }
            return 2;
        }
        if (event instanceof IEMouseButtonClicked) {
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            IInputState state = this.getTool().getState();
            if (clickEvent.getButton() != 1 || clickEvent.getTimes() > 1 || !clickEvent.isButtonStillPressed() || state.isMouseButtonDown(2) || state.isMouseButtonDown(3) || state.isAltKeyDown()) {
                return 0;
            }
            Point position = clickEvent.getCurrentPosition();
            this.handleStartDrag(position);
            return 2;
        }
        return 0;
    }

    @Override
    public void cancel() {
        this.dragInProgress = false;
        this.startPoint = null;
        if (this.feedbackLayer == null) {
            return;
        }
        this.feedback.hideFeedback(this.feedbackLayer);
        this.feedbackLayer = null;
        this.getTool().setCursor(null);
    }

    @Override
    protected Request getRequest() {
        return null;
    }

    private void handleStartDrag(Point position) {
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleStartSelection(Point position = " + position + ") - start");
        }
        assert (position != null) : "position is null";
        this.dragInProgress = true;
        this.startPoint = position.getCopy();
        Point startPointCopy = new Point(this.startPoint);
        Point endPoint = new Point(position);
        this.feedback.translateToRelative(startPointCopy);
        this.feedback.translateToRelative(endPoint);
        this.feedbackLayer = this.getFeedbackLayer();
        if (this.feedbackLayer != null) {
            this.feedback.showFeedback(this.feedbackLayer);
        }
        this.getTool().setCursor(org.eclipse.draw2d.Cursors.CROSS);
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleStartSelection() - end");
        }
    }

    private void handleDragInProgress(Point position) {
        assert (position != null) : "Position is null";
        assert (this.getTool().getState().isMouseButtonDown(1)) : "Mouse button during selection with marquee tool isn't down; probably an event got lost";
        Point startPointCopy = new Point(this.startPoint);
        Point endPoint = new Point(position);
        this.feedback.translateToRelative(startPointCopy);
        this.feedback.translateToRelative(endPoint);
        this.feedback.updateFeedback(startPointCopy, endPoint);
    }

    private void handleFinishDrag(Point position) {
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleFinishSelection(Point position = " + position + ") - start");
        }
        assert (position != null) : "Position is null";
        Rectangle dragRectangle = new Rectangle(this.startPoint, position);
        IZoomMgr zoomMgr = ((PEPlan)this.getTool().getCurrentViewer().getContents()).getViewMgr().getZoomMgr();
        zoomMgr.setCalculatedZoom(dragRectangle.x, dragRectangle.y, dragRectangle.width, dragRectangle.height, 0.0);
        this.getTool().setToolToSwitchTo((GenericTool)this.getTool().getCurrentViewer().getEditDomain().getDefaultTool(), true);
        this.cancel();
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleFinishSelection() - end");
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursors.LENS;
    }
}

