/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.palette;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.eclipse.transfer.TransferContentBackdoorStorage;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.print.IImagePrinterPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planeditor.dnd.PlanTemplateTransfer;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.pagebooks.palette.CanvasItem;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PaletteItem {
    private static final int THUMBNAIL_WIDTH = 36;
    private static final int THUMBNAIL_HEIGHT = 36;
    private static final int THUMBNAIL_MARGIN = 1;
    private final String text;
    private final String description;
    private final Image thumbnail;
    private final IPMPlanRO plan;

    public PaletteItem(String text, String description, Image thumbnail, IPMPlanRO plan) {
        this.text = text;
        this.description = description;
        this.thumbnail = thumbnail;
        this.plan = plan;
    }

    public PaletteItem(String text, String description, IPMPlanRO plan) {
        this(text, description, null, plan);
    }

    public Control createControl(Composite parent) {
        CanvasItem control = new CanvasItem(parent);
        control.setText(this.text);
        control.setToolTipText(this.description);
        final Image controlThumbnail = this.thumbnail == null ? PaletteItem.createThumbnail(this.plan, 36, 36, 1) : new Image(null, this.thumbnail.getImageData());
        if (controlThumbnail != null) {
            control.setImage(controlThumbnail);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    controlThumbnail.dispose();
                }
            });
        }
        int operations = 1;
        DragSource source = new DragSource((Control)control, operations);
        Transfer[] types = new Transfer[]{MultipleObjectTransferAgent.getInstance()};
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TransferContentBackdoorStorage.setContent((Object)this, (MultipleObjectTransferContent)new MultipleObjectTransferContent((Object)PaletteItem.this.createContent(), (AbstractTransferAgentForMultipleObjectTransfer)MultipleObjectTransferAgent.getInstance()));
            }

            public void dragSetData(DragSourceEvent event) {
                if (MultipleObjectTransferAgent.getInstance().isSupportedType(event.dataType)) {
                    event.data = PaletteItem.this.createContent();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                TransferContentBackdoorStorage.clearContent((Object)this);
            }
        });
        return control;
    }

    private Collection<MultipleObjectTransferContent> createContent() {
        return Collections.singleton(new MultipleObjectTransferContent((Object)this.plan, (AbstractTransferAgentForMultipleObjectTransfer)PlanTemplateTransfer.getInstance()));
    }

    private static Image createThumbnail(IPMPlanRO thumbPlan, int width, int height, int margin) {
        Image image = null;
        IImagePrinterPageDescription imageInfo = ImagePrinterPageDescription.createImageInfoInPixels((int)width, (int)height, (int)0, (double)EditMgr.DPI_X, (double)EditMgr.DPI_Y, (Color)Color.WHITE);
        ImagePrinter printer = new ImagePrinter(imageInfo);
        double insetsHInInch = (double)margin / EditMgr.DPI_X;
        double insetsVInInch = (double)margin / EditMgr.DPI_Y;
        double insetsHInMM = insetsHInInch * 25.4;
        double insetsVInMM = insetsVInInch * 25.4;
        Insets insetsInMM = new Insets(insetsVInMM, insetsVInMM, insetsHInMM, insetsHInMM);
        ViewCreator creator = new ViewCreator();
        PVView view = creator.createPVView((Object)thumbPlan, null, null, true, HighlightLevel.BUSINESS, false, false);
        Rectangle bounds = view.getOuterBoundsWithoutChildren();
        double zoom = 0.5;
        boolean doFit = true;
        if (bounds != null && bounds.w() * zoom + insetsInMM.leftInset + insetsInMM.rightInset < printer.getDrawingArea().w() && bounds.h() * zoom + insetsInMM.upperInset + insetsInMM.lowerInset < printer.getDrawingArea().h()) {
            doFit = false;
        }
        PageSetup printerConfig = new PageSetup(1, 1, new Alignment(2, 16), zoom, doFit, doFit, insetsInMM);
        PrintProcessor printProcessor = new PrintProcessor();
        try {
            printProcessor.print((IPrinter)printer, view, printerConfig, thumbPlan.getName());
            assert (printer.getCreatedImages().size() == 1) : "Something went wrong with the scaling or printing. Expected exactly 1 image!";
            Iterator images = printer.getCreatedImages().iterator();
            if (!images.hasNext()) {
                throw new RuntimeException("no image was created");
            }
            image = ((SWTOffscreenBitmap)((com.arcway.lib.graphics.image.Image)images.next()).getOffscreenBitmap()).getWrappedSWTImage();
        }
        catch (PrintingFailure e) {
            throw new RuntimeException(e);
        }
        return image;
    }
}

