/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dnd;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.eclipse.transfer.TransferContentBackdoorStorage;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.RQCreatePlanElementStructureAsCopy;
import com.arcway.planagent.planeditor.dnd.AbstractDNDListener;
import com.arcway.planagent.planeditor.dnd.PlanTemplateTransfer;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.transactions.TACreatePlanElementStructureAsCopy;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;

public class PaletteToEditorDNDListener
extends AbstractDNDListener {
    private static final ILogger logger = Logger.getLogger(PaletteToEditorDNDListener.class);

    public PaletteToEditorDNDListener(EditPartViewer viewer) {
        super(viewer, (Transfer)MultipleObjectTransferAgent.getInstance());
        MultipleObjectTransferAgent.getInstance().getSupportedTypes();
        PlanTemplateTransfer.getInstance().getSupportedTypes();
    }

    protected void updateTargetRequest() {
        RQCreatePlanElementStructureAsCopy request = (RQCreatePlanElementStructureAsCopy)this.getTargetRequest();
        this.getCurrentEvent().detail = 1;
        request.setPosition(this.getScreenCoordinates());
        if (!request.hasPlan()) {
            Object plan;
            Object data = this.getCurrentEvent().data;
            if (data == null) {
                plan = null;
                Collection contents = (Collection)TransferContentBackdoorStorage.getContent((AbstractTransferAgentForMultipleObjectTransfer)((MultipleObjectTransferAgent)this.getTransfer()), (Object)((Object)this));
                if (contents == null) {
                    contents = (Collection)((MultipleObjectTransferAgent)this.getTransfer()).nativeToJava(this.getCurrentEvent().currentDataType);
                }
                plan = contents == null ? null : this.getPlanFromContents(contents);
                request.setNativeContent(contents);
            } else if (data instanceof Collection) {
                Collection contents = (Collection)data;
                plan = this.getPlanFromContents(contents);
                request.setNativeContent(contents);
            } else {
                plan = null;
                logger.error("An object was received via D&D which is not a plan.");
            }
            request.setPlan((PMPlan)plan);
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "DND - set plan, request = " + (Object)((Object)request) + ", plan = " + plan);
            }
        }
    }

    private PMPlan getPlanFromContents(Collection contents) {
        PMPlan plan = null;
        Iterator i = contents.iterator();
        while (plan == null && i.hasNext()) {
            IPMPlanRW targetPlan;
            Object model;
            MultipleObjectTransferContent content = (MultipleObjectTransferContent)i.next();
            if (!(content.getTransferAgent() instanceof PlanTemplateTransfer)) continue;
            PMPlan sourcePlan = (PMPlan)content.getObjectToTransfer();
            EditPart viewerContents = this.getViewer().getContents();
            if (viewerContents == null || (model = this.getViewer().getContents().getModel()) == null || !(model instanceof IPMPlanRW) || !TACreatePlanElementStructureAsCopy.areAllPlanElementTypesSupported((IPMPlanRW)sourcePlan, (IPMPlanRW)(targetPlan = (IPMPlanRW)model))) continue;
            plan = sourcePlan;
        }
        return plan;
    }

    private Point getScreenCoordinates() {
        DropTargetEvent event = this.getCurrentEvent();
        Point point = new Point(event.x, event.y);
        DropTarget target = (DropTarget)this.getCurrentEvent().widget;
        point = target.getControl().toControl(point);
        return point;
    }

    protected Request createTargetRequest() {
        RQCreatePlanElementStructureAsCopy returnRequest = new RQCreatePlanElementStructureAsCopy(1);
        if (logger.isDebugEnabled(74)) {
            logger.debug(74, "DND - create request, request = " + (Object)((Object)returnRequest));
        }
        return returnRequest;
    }
}

