/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditTextDialog
extends TitleAreaDialog {
    private static final int DIALOG_WIDTH = 410;
    private static final int DIALOG_HEIGHT = 250;
    private final String title;
    private final String message;
    private String value = "";
    private final IInputValidator validator;
    private Button okButton;
    private Text text;
    private Label errorMessageLabel;
    private final boolean multiLines;

    public static String request(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, boolean multiLines) {
        EditTextDialog dialog = new EditTextDialog(parentShell, dialogTitle, dialogMessage, initialValue, null, multiLines);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        String newText = result == 0 ? dialog.getValue() : null;
        return newText;
    }

    public EditTextDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, boolean multiLines) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
        this.multiLines = multiLines;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        Point preferredSize = shell.computeSize(410, 250);
        shell.setSize(preferredSize);
        shell.setLocation(Display.getCurrent().getBounds().width / 2 - 205, Display.getCurrent().getBounds().height / 2 - 125);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.message != null) {
            super.setTitle(this.message);
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        int style = 2624;
        style = this.multiLines ? (style |= 2) : (style |= 4);
        this.text = new Text(composite, style);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTextDialog.this.validateInput();
            }
        });
        this.errorMessageLabel = new Label(composite, 0);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
        this.errorMessageLabel.setFont(parent.getFont());
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.errorMessageLabel.setText(errorMessage == null ? "" : errorMessage);
        this.okButton.setEnabled(errorMessage == null);
        this.errorMessageLabel.getParent().update();
    }
}

