/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverMetafile;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.IVariablePageSizeDeviceDriver;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.graphics.print.VariablePageSizePrinter;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionRequest;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planeditor.PlanEditor;
import com.arcway.planagent.planeditor.actions.AbstractUIAction;
import com.arcway.planagent.planeditor.dialogs.SaveAsMetafileDialogSettings;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.nonpermanent.PMLegend;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.print.PageInfo;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import de.plans.lib.eclipse.MultipleObjectSWTTransferContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class UICopyAsMetafileAction
extends AbstractUIAction
implements IAction {
    private static final ILogger logger = Logger.getLogger(UICopyAsMetafileAction.class);
    private static File clipboardFile = null;
    protected static final Insets PAGE_INSETS = new Insets(0.5);
    protected static final Insets FRAME_INSETS = new Insets(10.0);
    protected static final double MIN_LEGEND_DISTANCE = 10.0;
    private IWorkbenchPart part;
    private IPartListener partListener;
    private final IPartService partService;

    private static synchronized File getClipboardFile(String planName, String extension) throws IOException {
        if (clipboardFile == null) {
            String fileName = FileHelper.convertStringToPortableFileName((String)planName);
            clipboardFile = File.createTempFile(fileName, "." + extension);
            clipboardFile.deleteOnExit();
        }
        return clipboardFile;
    }

    @Deprecated
    protected UICopyAsMetafileAction(IPartService service) {
        super((IWorkbenchPart)((IWorkbenchPage)service).getActiveEditor());
        this.partService = service;
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                UICopyAsMetafileAction.super.setWorkbenchPart(part);
                UICopyAsMetafileAction.this.part = part;
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                UICopyAsMetafileAction.this.part = null;
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.partService.addPartListener(this.partListener);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void dispose() {
        if (this.partListener != null) {
            this.partService.removePartListener(this.partListener);
        }
        this.partListener = null;
    }

    protected abstract IDeviceDriverMetafile createDeviceDriver();

    protected abstract String getExtension();

    public void run() {
        UICopyAsMetafileAction.copyAsMetfaile(this.part, this.createDeviceDriver(), this.getExtension(), this.getSettingsFactory());
    }

    protected abstract ISettingsFactory getSettingsFactory();

    public static void copyAsMetfaile(IWorkbenchPart part, IDeviceDriverMetafile deviceDriver, String extension, ISettingsFactory settingsFactory) {
        MultipleObjectSWTTransferContent content;
        GraphicalViewer viewer = null;
        PMPlan plan = null;
        if (part != null) {
            if (part.getAdapter(GraphicalViewer.class) != null) {
                viewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
            }
            if (part.getAdapter(PMPlan.class) != null) {
                plan = (PMPlan)part.getAdapter(PMPlan.class);
            }
        }
        if (viewer != null && plan != null && (content = UICopyAsMetafileAction.copyAsMetafile(part.getSite().getShell(), viewer, ((PlanEditor)part.getAdapter(PlanEditor.class)).getContent(), deviceDriver, extension, settingsFactory)) != null) {
            Clipboard clipboard = new Clipboard(part.getSite().getShell().getDisplay());
            clipboard.setContents(new Object[]{content.getObjectToTransfer()}, new Transfer[]{content.getTransferAgent()});
            clipboard.dispose();
        }
    }

    public static MultipleObjectSWTTransferContent copyAsMetafile(Shell shell, GraphicalViewer viewer, final IEditorContent editorContentSource, IDeviceDriverMetafile deviceDriver, String extension, ISettingsFactory settingsFactory) {
        MultipleObjectSWTTransferContent content = null;
        PMPlan plan = (PMPlan)editorContentSource.getPlanModel();
        if (viewer != null && plan != null) {
            PMPlan planToExportTemp;
            List selectedEditParts = viewer.getSelectedEditParts();
            HashSet<Object> selectedPlanElements = new HashSet<Object>(plan.getPlanElementCount());
            for (EditPart editPart : selectedEditParts) {
                if (editPart instanceof PEPlanElement) {
                    PEPlanElement pePlanElement = (PEPlanElement)editPart;
                    selectedPlanElements.add(pePlanElement.getPMPlanElement());
                    continue;
                }
                if (editPart instanceof PEFigure) {
                    PEFigure peFigure = (PEFigure)editPart;
                    selectedPlanElements.add(peFigure.getPMFigure().getPlanElement());
                    continue;
                }
                if (!(editPart instanceof PEGraphicalSupplement)) continue;
                PEGraphicalSupplement peGraphicalSupplement = (PEGraphicalSupplement)editPart;
                selectedPlanElements.add(peGraphicalSupplement.getPMPlanObject().getPlanElementRO());
            }
            if (selectedPlanElements.isEmpty()) {
                selectedPlanElements = null;
            }
            if (selectedPlanElements != null) {
                try {
                    planToExportTemp = plan.getCut(selectedPlanElements);
                    UICopyAsMetafileAction.project((IPMPlanRO)planToExportTemp, new ArrayList(UICopyAsMetafileAction.getAllProjectionRequests((IPMPlanRO)plan)));
                    UICopyAsMetafileAction.highlightPlanElements((IPMPlanRO)planToExportTemp, HighlightLevel.BUSINESS, UICopyAsMetafileAction.getAllHighlightRequests((IPMPlanRO)plan, HighlightLevel.BUSINESS));
                }
                catch (EXPlanCreationException e) {
                    planToExportTemp = plan;
                }
            } else {
                planToExportTemp = plan;
            }
            final PMPlan planToExport = planToExportTemp;
            IEditorContent editorContent = new IEditorContent(){

                public IPlanInfo getPlanInfo() {
                    return editorContentSource.getPlanInfo();
                }

                public IPMPlanRO getPlanModel() {
                    return planToExport;
                }
            };
            SaveAsMetafileDialogSettings settingsCopy = settingsFactory.createSettingsObject();
            settingsCopy.setIncludeInformation(selectedPlanElements == null);
            settingsCopy.setIncludeHighlights(selectedPlanElements == null);
            settingsCopy.setIncludeProjections(true);
            settingsCopy.setSetMarginsAutomatically(false);
            settingsCopy.setPageSetup(new PageSetup(1, 1, new Alignment(2, 16), 1.0, true, true, PAGE_INSETS));
            PVView view = UICopyAsMetafileAction.getView(settingsCopy, editorContent);
            Rectangle planSize = view.getOuterBoundsWithoutChildren();
            if (planSize != null) {
                planSize = planSize.expand(PAGE_INSETS);
                settingsCopy.setDimension(planSize);
            } else {
                settingsCopy.setDimension(new Rectangle(0.0, 0.0, 0.0, 0.0));
            }
            try {
                String planName = planToExport.getName();
                File file = UICopyAsMetafileAction.getClipboardFile(planName, extension);
                UICopyAsMetafileAction.saveAs(shell, file, planSize, settingsCopy, editorContent, view, deviceDriver);
                String[] fileNames = new String[]{file.getAbsolutePath()};
                content = new MultipleObjectSWTTransferContent((Object)fileNames, (Transfer)FileTransfer.getInstance());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return content;
    }

    protected static void saveAs(Shell shell, File file, Rectangle planSizeInMM, final SaveAsMetafileDialogSettings settings, IEditorContent editorContent, PVView view, IDeviceDriverMetafile deviceDriverWMF) {
        try {
            VariablePageSizePrinter printer = new VariablePageSizePrinter((IVariablePageSizeDeviceDriver)deviceDriverWMF, new IPageDescription(){

                public Dimension getPageDimension() {
                    return settings.getDimension().getDimension();
                }

                public Insets getPrintAreaInsets() {
                    return settings.getPageSetup().getMargin();
                }
            });
            UICopyAsMetafileAction.print(shell, settings, (IPrinter)printer, editorContent, view);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            deviceDriverWMF.saveImageDirectly((OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
        catch (PrintingFailure e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
        catch (EXEmptyResult e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
    }

    public void disposePrinter(IPrinter printer) {
        ((ImagePrinter)printer).disposeImages();
    }

    private static final PrintingFailure print(Shell shell, SaveAsMetafileDialogSettings settingsCopy, IPrinter printer, IEditorContent editorContent, PVView view) {
        PrintingFailure failure = null;
        shell.setCursor(Cursors.WAIT);
        PrintProcessor pp = new PrintProcessor();
        try {
            pp.print(printer, view, settingsCopy.getPageSetup(), editorContent.getPlanInfo().getPlanName());
        }
        catch (PrintingFailure f) {
            failure = f;
        }
        shell.setCursor(Cursors.ARROW);
        return failure;
    }

    private static PVView getView(SaveAsMetafileDialogSettings settingsCopy, IEditorContent editorContent) {
        PVView pVViewCache = null;
        if (pVViewCache == null) {
            ViewCreator creator = new ViewCreator();
            FrameViewConfig frameViewConfig = null;
            if (settingsCopy.isIncludeInformation()) {
                frameViewConfig = UICopyAsMetafileAction.getFrameViewConfig(settingsCopy, null);
            }
            pVViewCache = creator.createPVView(editorContent, null, settingsCopy.isIncludeComments(), (HighlightLevel)(settingsCopy.isIncludeHighlights() ? HighlightLevel.BUSINESS : null), settingsCopy.isIncludeProjections(), frameViewConfig);
        }
        return pVViewCache;
    }

    private static FrameViewConfig getFrameViewConfig(SaveAsMetafileDialogSettings settingsCopy, PageInfo pageInfo) {
        FrameViewConfig frameViewConfig = FrameViewConfig.createFrame((Insets)settingsCopy.getInnerMargins(), (double)10.0, (double)1.0);
        return frameViewConfig;
    }

    protected static final Set getAllHighlightRequests(IPMPlanRO plan, HighlightLevel highlightLevel) {
        HashSet<IHighlightRequest> highlightRequests = new HashSet<IHighlightRequest>();
        int i = 0;
        while (i < plan.getPlanElementCount()) {
            IPMPlanElementRO planElement = plan.getPlanElementRO(i);
            PMHighlight highlight = planElement.getHighlight(highlightLevel);
            if (highlight != null) {
                IHighlightRequest highlightRequest = highlight.getHighlightRequest();
                highlightRequests.add(highlightRequest);
            }
            ++i;
        }
        return highlightRequests;
    }

    protected static final Set getAllProjectionRequests(IPMPlanRO plan) {
        Collection projections = plan.getProjections();
        HashSet<IProjectionRequest> projectionRequests = new HashSet<IProjectionRequest>(projections.size());
        for (PMProjection projection : projections) {
            IProjectionRequest projectionRequest = projection.getProjectionRequest();
            projectionRequests.add(projectionRequest);
        }
        return projectionRequests;
    }

    public static void highlightPlanElements(IPMPlanRO plan, HighlightLevel highlightLevel, Collection highlightRequests) {
        IModelChangeRW modelChange;
        IPMPlanModelObjectFactoryRW planModelObjectFactory;
        PMHighlight highlight;
        IPMPlanElementRO pe;
        assert (highlightRequests != null);
        HashSet<IModelChangeRW> modelChanges = new HashSet<IModelChangeRW>();
        Set oldRequests = UICopyAsMetafileAction.getAllHighlightRequests(plan, highlightLevel);
        HashSet newRequests = new HashSet(highlightRequests);
        HashSet addedRequests = new HashSet(newRequests);
        addedRequests.removeAll(oldRequests);
        HashSet removedRequests = new HashSet(oldRequests);
        removedRequests.removeAll(newRequests);
        for (IHighlightRequest request : removedRequests) {
            pe = plan.getPlanElementRO(request.getPlanElementUID());
            if (pe == null) continue;
            highlight = pe.getHighlight(highlightLevel);
            pe.setHighlight(highlightLevel, null);
            planModelObjectFactory = highlight.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)highlight, 3);
            modelChanges.add(modelChange);
        }
        for (IHighlightRequest request : addedRequests) {
            pe = plan.getPlanElementRO(request.getPlanElementUID());
            if (pe == null) continue;
            highlight = new PMHighlight((PMPlanElement)pe, request);
            pe.setHighlight(highlightLevel, highlight);
            planModelObjectFactory = highlight.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)highlight, 1);
            modelChanges.add(modelChange);
        }
    }

    public static void project(IPMPlanRO plan, List projectionRequests) {
        assert (projectionRequests != null);
        HashSet<IModelChangeRW> modelChanges = new HashSet<IModelChangeRW>();
        Set oldRequests = UICopyAsMetafileAction.getAllProjectionRequests(plan);
        HashSet newRequests = new HashSet(projectionRequests);
        HashSet addedRequests = new HashSet(newRequests);
        addedRequests.removeAll(oldRequests);
        HashSet removedRequests = new HashSet(oldRequests);
        removedRequests.removeAll(newRequests);
        List oldLegends = plan.getLegends();
        ArrayList<PMLegend> newLegends = new ArrayList<PMLegend>();
        ArrayList<PMProjection> projections = new ArrayList<PMProjection>(plan.getProjections());
        for (PMLegend legend : oldLegends) {
            IPMPlanModelObjectFactoryRW planModelObjectFactory = legend.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)legend, 3);
            modelChanges.add(modelChange);
        }
        for (IProjectionRequest request : removedRequests) {
            boolean found = false;
            Iterator j = projections.iterator();
            while (!found && j.hasNext()) {
                PMProjection projection = (PMProjection)j.next();
                if (!projection.getPMPlanElement().getUid().equals(request.getPlanElementUID())) continue;
                j.remove();
                found = true;
                IPMPlanModelObjectFactoryRW planModelObjectFactory = projection.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
                IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)projection, 3);
                modelChanges.add(modelChange);
            }
        }
        for (IProjectionRequest request : addedRequests) {
            if (request.getPlanElementUID() == null) {
                PMLegend legend = new PMLegend((PMPlan)plan, request);
                newLegends.add(legend);
                IPMPlanModelObjectFactoryRW planModelObjectFactory = legend.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
                IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)legend, 1);
                modelChanges.add(modelChange);
                continue;
            }
            IPMPlanElementRO pe = plan.getPlanElementRO(request.getPlanElementUID());
            if (pe == null) continue;
            PMProjection projection = new PMProjection((PMPlanElement)pe, request);
            projections.add(projection);
            IPMPlanModelObjectFactoryRW planModelObjectFactory = projection.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)projection, 1);
            modelChanges.add(modelChange);
        }
        plan.setProjections(projections);
        plan.setLegends(newLegends);
    }

    static interface ISettingsFactory {
        public SaveAsMetafileDialogSettings createSettingsObject();
    }
}

