/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import de.plans.lib.util.LocalisationUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class LineWidthDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static LineWidthDecoration singelton;
    private static ImageDescriptor image;

    static {
        image = ResourceLoader.getImageDescriptor((String)"linewidth.gif", (Plugin)FMCAPlanEditorPlugin.getDefault());
    }

    private LineWidthDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineWidthDecoration getInstance() {
        Class<LineWidthDecoration> clazz = LineWidthDecoration.class;
        synchronized (LineWidthDecoration.class) {
            if (singelton == null) {
                singelton = new LineWidthDecoration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    @Override
    public Class[] getAppearanceClasses() {
        return new Class[]{ILineAppearanceRO.class};
    }

    @Override
    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return new Double(((ILineAppearanceRO)appearance).getLineThickness());
    }

    @Override
    public String getToolTipText(Object state) {
        return this.getMenuEntryText(state);
    }

    @Override
    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return image;
    }

    @Override
    public ImageDescriptor getMenuEntryImage(Object state) {
        return null;
    }

    @Override
    public String getMenuEntryText(Object state) {
        double sizeM = (Double)state / 1000.0;
        return String.valueOf(LocalisationUtils.roundLocalized((double)(sizeM * 1000.0), (int)3, (boolean)true)) + " mm";
    }

    @Override
    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        LineAppearanceTpl template = new LineAppearanceTpl();
        template.setLineThickness(((Double)state).doubleValue());
        return new IAppearanceTpl[]{template};
    }
}

