/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.LineStyleDecoration;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CILineStyle
extends MenuContributionItem {
    private static final String action_id_linestyle_none = "com.arcway.cockpitplanagent.editor.actions.linestyle.01.none";
    private static final String action_id_linestyle_dot = "com.arcway.cockpitplanagent.editor.actions.linestyle.02.dot";
    private static final String action_id_linestyle_dashshort = "com.arcway.cockpitplanagent.editor.actions.linestyle.03.dashshort";
    private static final String action_id_linestyle_dash = "com.arcway.cockpitplanagent.editor.actions.linestyle.04.dash";
    private static final String action_id_linestyle_dashdot = "com.arcway.cockpitplanagent.editor.actions.linestyle.05.dashdot";
    private static final String action_id_linestyle_dashdash = "com.arcway.cockpitplanagent.editor.actions.linestyle.06.dashdash";
    private static final String action_id_linestyle_dashdashdot = "com.arcway.cockpitplanagent.editor.actions.linestyle.07.dashdashdot";
    private static final String action_id_linestyle_dashdotdot = "com.arcway.cockpitplanagent.editor.actions.linestyle.08.dashdotdot";
    private static final String action_id_linestyle_solid = "com.arcway.cockpitplanagent.editor.actions.linestyle.09.solid";
    private static final String action_id_linestyle_doublestroke = "com.arcway.cockpitplanagent.editor.actions.linestyle.10.doublestroke";
    private static final String action_id_linestyle_doublestrokedash = "com.arcway.cockpitplanagent.editor.actions.linestyle.11.doublestrokedash";
    private static final String action_id_linestyle_doublestrokedashshort = "com.arcway.cockpitplanagent.editor.actions.linestyle.12.doublestrokedashshort";
    private static final String action_id_linestyle_triplestroke = "com.arcway.cockpitplanagent.editor.actions.linestyle.13.triplestroke";
    private static final Map<String, LineStyle> styleMaps = new HashMap<String, LineStyle>();
    private static ArrayList<String> sortedStyleIDList;
    private static final IAppearanceButtonDecoration buttonType;
    private static final LineStyle initStyle;

    static {
        styleMaps.put(action_id_linestyle_none, LineStyle.NONE);
        styleMaps.put(action_id_linestyle_dot, LineStyle.DOT);
        styleMaps.put(action_id_linestyle_dashdot, LineStyle.DASHDOT);
        styleMaps.put(action_id_linestyle_dashshort, LineStyle.DASHSHORT);
        styleMaps.put(action_id_linestyle_dash, LineStyle.DASH);
        styleMaps.put(action_id_linestyle_dashdot, LineStyle.DASHDOT);
        styleMaps.put(action_id_linestyle_dashdash, LineStyle.DASHDASH);
        styleMaps.put(action_id_linestyle_dashdashdot, LineStyle.DASHDASHDOT);
        styleMaps.put(action_id_linestyle_dashdotdot, LineStyle.DASHDOTDOT);
        styleMaps.put(action_id_linestyle_solid, LineStyle.SOLID);
        styleMaps.put(action_id_linestyle_doublestroke, LineStyle.DOUBLESTROKE);
        styleMaps.put(action_id_linestyle_doublestrokedash, LineStyle.DOUBLESTROKEDASH);
        styleMaps.put(action_id_linestyle_doublestrokedashshort, LineStyle.DOUBLESTROKEDASHSHORT);
        styleMaps.put(action_id_linestyle_triplestroke, LineStyle.TRIPLESTROKE);
        sortedStyleIDList = new ArrayList();
        Set<String> colorIDList = styleMaps.keySet();
        ArrayList<String> idList = new ArrayList<String>(colorIDList);
        Collections.sort(idList);
        sortedStyleIDList = idList;
        buttonType = LineStyleDecoration.getInstance();
        initStyle = LineStyle.SOLID;
    }

    public CILineStyle() {
    }

    public CILineStyle(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    @Override
    protected IAppearanceButtonDecoration getButtonType() {
        return buttonType;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, initStyle);
        ArrayList<Object> selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : sortedStyleIDList) {
            LineStyle style = styleMaps.get(actionID);
            String styleName = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryText(style);
            UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, actionID, styleName, style, buttonType);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryImage(style);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            boolean checked = false;
            if (enabled) {
                checked = this.isActionChecked(style, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        return items;
    }

    private boolean isActionChecked(LineStyle style, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            String name2;
            if (!(state instanceof LineStyle)) continue;
            LineStyle selectedStyle = (LineStyle)state;
            String name1 = style.getName();
            checked = name1.equals(name2 = selectedStyle.getName());
            if (checked) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }
}

