/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.gui.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.gui.Messages;
import com.arcway.planagent.planeditor.gui.actions.UIAbstractGUICheckBoxAction;
import com.arcway.planagent.planeditor.gui.commands.CMDeleteCheckBoxActiveSupplement;
import com.arcway.planagent.planmodel.gui.access.readonly.IPMPlanElementGUICheckBoxRO;
import com.arcway.planagent.planmodel.gui.access.readwrite.IPMPlanElementGUICheckBoxRW;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class UIDeleteGUICheckBoxActiveSupplementAction
extends UIAbstractGUICheckBoxAction {
    private static final ILogger logger = Logger.getLogger(UIDeleteGUICheckBoxActiveSupplementAction.class);
    private static final String ID = "de.plans.fmca.planagent.planeditor.bpmn.bpd.actions.uideletecheckboxactivesupplementaction";

    public UIDeleteGUICheckBoxActiveSupplementAction(ContextMenuContext context) {
        super(context);
        if (logger.isTraceEnabled()) {
            logger.trace("UIDeleteCheckBoxActiveSupplementAction(ContextMenuContext context = " + context + ") - start");
        }
        this.setText(Messages.getString("UIDeleteCheckBoxActiveSupplement.Delete_ActiveSupplement"));
        this.setToolTipText(Messages.getString("UIDeleteCheckBoxActiveSupplement.Deletes_ActiveSupplement"));
        this.setId(ID);
        if (logger.isTraceEnabled()) {
            logger.trace("UIDeleteCheckBoxActiveSupplementAction(ContextMenuContext) - end");
        }
    }

    protected boolean calculateEnabled() {
        boolean toReturn = false;
        IPMPlanElementGUICheckBoxRO planElement = this.getSelectedCheckBox();
        if (planElement != null && planElement.getCheckBoxActiveSupplementRO() != null) {
            toReturn = true;
        }
        return toReturn;
    }

    protected Command getCommand(List<PEPlanElement> items) {
        Object model;
        assert (items != null) : "items is null";
        if (this.calculateEnabled() && !items.isEmpty() && (model = items.get(0).getModel()) instanceof IPMPlanElementGUICheckBoxRW) {
            IPMPlanElementGUICheckBoxRW planElement = (IPMPlanElementGUICheckBoxRW)model;
            return new CMDeleteCheckBoxActiveSupplement(planElement, super.getCommandContext());
        }
        return null;
    }

    protected boolean isVisibleIfDisabled() {
        return false;
    }

    protected boolean isVisibleInProjectionMode() {
        return false;
    }
}

