/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.stringtools;

import com.arcway.lib.java.collections.IHasher_;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class StringUtil {
    private static final char BLANK = ' ';
    private static final String BLANK_STR = " ";
    private static final char NULL = '\u0000';
    private static final String NULL_STR;
    private static final String NULL_AND_BLANK_STR;
    private static final String NULL_AND_QUOTATIONMARK_STR;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SO = '\u000e';
    public static final String CRLF;
    private static final char FF = '\f';
    private static final char TAB = '\t';
    public static final char HYPHEN = '-';
    public static final char UNDERSCORE = '_';
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    public static final char DOT = '.';
    private static final char COMMA = ',';
    private static final char QUESTIONMARK = '?';
    private static final char EXCLAMATIONMARK = '!';
    private static final char SEMICOLON = ';';
    private static final char DOTS = '\u2026';
    public static final String CONTROL_CHARACTERS_WITHOUT_CR_LF_TAB;
    public static final String CONTROL_CHARACTERS_WITHOUT_TAB;
    public static final String CONTROL_CHARACTERS_WITHOUT_CR_LF;
    public static final String CONTROL_CHARACTERS;
    public static final String DIGITS = "0123456789";
    public static final String CHARACTERS_A_TO_Z_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String CHARACTERS_A_TO_Z_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LINE_SEPARATOR;
    public static final IHasher_<String> EQUALS_IGNORE_CASE_HASHER;
    static final char[][][] replacementTable;

    static {
        String lineSeparator;
        NULL_STR = Character.toString('\u0000');
        NULL_AND_BLANK_STR = String.valueOf(NULL_STR) + BLANK_STR;
        NULL_AND_QUOTATIONMARK_STR = String.valueOf(NULL_STR) + ":";
        CRLF = new String(new char[]{'\r', '\n'});
        StringBuffer controlCharactersWithoutCRLFTab = new StringBuffer();
        char c = '\u0000';
        while (c < ' ') {
            if (c != '\r' && c != '\n' && c != '\t') {
                controlCharactersWithoutCRLFTab.append(c);
            }
            c = (char)(c + 1);
        }
        CONTROL_CHARACTERS_WITHOUT_CR_LF_TAB = controlCharactersWithoutCRLFTab.toString();
        CONTROL_CHARACTERS_WITHOUT_TAB = String.valueOf(CONTROL_CHARACTERS_WITHOUT_CR_LF_TAB) + '\r' + '\n';
        CONTROL_CHARACTERS_WITHOUT_CR_LF = String.valueOf(CONTROL_CHARACTERS_WITHOUT_CR_LF_TAB) + '\t';
        CONTROL_CHARACTERS = String.valueOf(CONTROL_CHARACTERS_WITHOUT_TAB) + '\t';
        try {
            lineSeparator = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException se) {
            lineSeparator = "\n";
        }
        LINE_SEPARATOR = lineSeparator;
        EQUALS_IGNORE_CASE_HASHER = new IHasher_<String>(){

            @Override
            public boolean isEqual(String object1, String object2) {
                return object1.equalsIgnoreCase(object2);
            }

            @Override
            public int getHashCode(String object) {
                return object.toLowerCase().hashCode();
            }
        };
        char[][][] cArrayArray = new char[10][][];
        char[][] cArrayArray2 = new char[2][];
        cArrayArray2[0] = new char[]{'-', '\u000e'};
        cArrayArray[0] = cArrayArray2;
        char[][] cArrayArray3 = new char[2][];
        cArrayArray3[0] = new char[]{'\u000e'};
        cArrayArray[1] = cArrayArray3;
        cArrayArray[2] = new char[][]{{'-', '\r', '\n'}, {'-'}};
        cArrayArray[3] = new char[][]{{'-', '\r'}, {'-'}};
        cArrayArray[4] = new char[][]{{'-', '\n'}, {'-'}};
        cArrayArray[5] = new char[][]{{'\r', '\n'}, {' '}};
        cArrayArray[6] = new char[][]{{'\r'}, {' '}};
        cArrayArray[7] = new char[][]{{'\n'}, {' '}};
        cArrayArray[8] = new char[][]{{'\t'}, {' '}};
        cArrayArray[9] = new char[][]{{'\f'}, {' '}};
        replacementTable = cArrayArray;
    }

    private StringUtil() {
    }

    public static Character checkStringToContainOnlyAllowedCharacters(String stringToBeChecked, String allowedCharacters) {
        char[] stringToBeCheckedChars;
        char[] cArray = stringToBeCheckedChars = stringToBeChecked.toCharArray();
        int n = stringToBeCheckedChars.length;
        int n2 = 0;
        while (n2 < n) {
            boolean characterIsOk;
            char stringToBeCheckedChar = cArray[n2];
            boolean bl = characterIsOk = allowedCharacters.indexOf(stringToBeCheckedChar) >= 0;
            if (!characterIsOk) {
                return Character.valueOf(stringToBeCheckedChar);
            }
            ++n2;
        }
        return null;
    }

    public static Character checkStringToContainNoInvalidCharacters(String stringToBeChecked, String invalidCharacters) {
        char firstInvalidCharacter = '\u0000';
        int firstInvalidCharacterIndex = -1;
        int i = 0;
        while (i < invalidCharacters.length()) {
            char invalidCharacter = invalidCharacters.charAt(i);
            int invalidCharacterIndex = stringToBeChecked.indexOf(invalidCharacter);
            if (invalidCharacter != '\uffffffff' && (firstInvalidCharacterIndex == -1 || invalidCharacterIndex < firstInvalidCharacterIndex)) {
                firstInvalidCharacterIndex = invalidCharacterIndex;
                firstInvalidCharacter = invalidCharacter;
            }
            ++i;
        }
        if (firstInvalidCharacterIndex != -1) {
            return Character.valueOf(firstInvalidCharacter);
        }
        return null;
    }

    public static String getFirstTextLine(String text) {
        List<String> lines = StringUtil.doSplitTextLines(text, true);
        if (lines.isEmpty()) {
            return null;
        }
        return lines.get(0);
    }

    public static List<String> splitTextLines(String text) {
        return StringUtil.doSplitTextLines(text, false);
    }

    private static List<String> doSplitTextLines(String text, boolean breakAfterFirstLine) {
        ArrayList<String> textLines = new ArrayList<String>();
        if (text != null) {
            int start = 0;
            char last = '\u0000';
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                boolean split = false;
                int startNew = -1;
                int end = -1;
                switch (c) {
                    case '\n': {
                        end = i;
                        startNew = i + 1;
                        if (last == '\r') {
                            split = false;
                            start = startNew;
                            break;
                        }
                        split = true;
                        break;
                    }
                    case '\r': {
                        split = true;
                        end = i;
                        startNew = i + 1;
                        break;
                    }
                    case '\f': 
                    case '\u000e': {
                        split = true;
                        end = i;
                        startNew = i + 1;
                    }
                }
                if (split) {
                    textLines.add(text.substring(start, end));
                    if (breakAfterFirstLine) {
                        return textLines;
                    }
                    start = startNew;
                }
                last = c;
                ++i;
            }
            textLines.add(text.substring(start, text.length()));
        }
        return textLines;
    }

    public static List<String> wrapTextLine(String lineToWrap) {
        List<String> retVal;
        if (lineToWrap.length() < 2) {
            retVal = Collections.singletonList(lineToWrap);
        } else {
            char[] lineToWrapChars = lineToWrap.toCharArray();
            int firstWrapPosition = StringUtil.findFirstWrapPosition(lineToWrapChars, 0);
            if (firstWrapPosition == -1 || firstWrapPosition == lineToWrapChars.length) {
                retVal = Collections.singletonList(lineToWrap);
            } else {
                int startPosition = 0;
                int wrapPosition = firstWrapPosition;
                retVal = new ArrayList<String>();
                while (wrapPosition != -1) {
                    retVal.add(lineToWrap.substring(startPosition, wrapPosition));
                    startPosition = wrapPosition;
                    wrapPosition = StringUtil.findFirstWrapPosition(lineToWrapChars, startPosition);
                }
                retVal.add(lineToWrap.substring(startPosition));
            }
        }
        return retVal;
    }

    public static List<String> trimTextLine(String textToTrim) {
        ArrayList<String> lineElements = new ArrayList<String>();
        String lineRest = textToTrim;
        int position = StringUtil.findFirstTrimPosition(lineRest);
        while (position > 0) {
            String lineElement = lineRest.substring(0, position);
            lineRest = lineRest.substring(position);
            lineElements.add(lineElement);
            position = StringUtil.findFirstTrimPosition(lineRest);
        }
        lineElements.add(lineRest);
        return lineElements;
    }

    public static int findFirstTrimPosition(String textToWrap) {
        int firstPos = textToWrap.indexOf(32);
        if (firstPos >= 0) {
            ++firstPos;
        }
        return firstPos;
    }

    public static int findFirstWrapPosition(String textToWrap) {
        int textLength = textToWrap.length();
        int i = 0;
        while (i < textLength) {
            switch (textToWrap.charAt(i)) {
                case ' ': 
                case '!': 
                case ',': 
                case '-': 
                case '/': 
                case ';': 
                case '?': 
                case '\\': {
                    return i + 1;
                }
                case '.': {
                    if (i + 1 < textLength && textToWrap.charAt(i + 1) == '-') {
                        return i + 2;
                    }
                    return i + 1;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int findFirstWrapPosition(char[] textToWrap, int startPos) {
        int textLength = textToWrap.length;
        int i = startPos;
        while (i < textLength) {
            switch (textToWrap[i]) {
                case ' ': 
                case '!': 
                case ',': 
                case '-': 
                case '/': 
                case ';': 
                case '?': 
                case '\\': {
                    return i + 1;
                }
                case '.': {
                    if (i + 1 < textLength && textToWrap[i + 1] == '-') {
                        return i + 2;
                    }
                    return i + 1;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int findLastWrapPosition(String textToWrap) {
        int i = textToWrap.length() - 1;
        while (i >= 0) {
            switch (textToWrap.charAt(i)) {
                case ' ': 
                case '!': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '?': 
                case '\\': {
                    return i;
                }
                case '-': {
                    if (i > 0 && textToWrap.charAt(i - 1) == '.') {
                        return i - 1;
                    }
                    return i;
                }
            }
            --i;
        }
        return -1;
    }

    public static String removeLineBreaksAndControlCharacters(String text) {
        int textLength = text.length();
        StringBuffer filterBuffer = null;
        int bufferpos = 0;
        int i = 0;
        while (i < textLength) {
            int numReplace = 0;
            char[] replacement = null;
            char[][][] cArray = replacementTable;
            int n = replacementTable.length;
            int n2 = 0;
            while (n2 < n) {
                char[][] element = cArray[n2];
                char[] pattern = element[0];
                int pi = 0;
                while (pi < pattern.length && i + pi < textLength) {
                    if (pattern[pi] != text.charAt(i + pi)) break;
                    ++pi;
                }
                if (pi == pattern.length) {
                    numReplace = pattern.length;
                    replacement = element[1];
                    break;
                }
                ++n2;
            }
            char charI = text.charAt(i);
            if (numReplace == 0 && (charI >= '\u0000' && charI <= '\u001f' || charI == '\u007f')) {
                numReplace = 1;
                replacement = null;
            }
            if (numReplace > 0) {
                String replacementString;
                if (filterBuffer == null) {
                    filterBuffer = new StringBuffer(text);
                }
                if (replacement == null || replacement.length == 0) {
                    replacementString = "";
                    filterBuffer.delete(bufferpos, bufferpos + numReplace);
                } else {
                    replacementString = new String(replacement);
                    filterBuffer.replace(bufferpos, bufferpos + numReplace, replacementString);
                }
                i += numReplace;
                bufferpos += replacementString.length();
                continue;
            }
            ++i;
            ++bufferpos;
        }
        String textWithoutControlCharacters = filterBuffer == null ? text : filterBuffer.toString();
        int textWithoutControlCharactersLength = textWithoutControlCharacters.length();
        bufferpos = 0;
        int i2 = 0;
        while (i2 < textWithoutControlCharactersLength) {
            int wi = i2;
            while (wi < textWithoutControlCharactersLength) {
                if (textWithoutControlCharacters.charAt(wi) != ' ') break;
                ++wi;
            }
            int sequenceLength = wi - i2;
            if (sequenceLength > 1) {
                if (filterBuffer == null) {
                    filterBuffer = new StringBuffer(text);
                }
                filterBuffer.delete(bufferpos + 1, bufferpos + sequenceLength);
                i2 += sequenceLength;
                ++bufferpos;
                continue;
            }
            ++i2;
            ++bufferpos;
        }
        String filteredText = filterBuffer != null ? filterBuffer.toString() : text;
        return filteredText;
    }

    public static String normalize(String text, boolean toUpper) {
        StringBuffer filteredText = new StringBuffer();
        String textTemp = text;
        textTemp = StringUtil.removeLineBreaksAndControlCharacters(textTemp);
        if (toUpper) {
            textTemp = textTemp.toUpperCase();
        }
        int i = 0;
        while (i < textTemp.length()) {
            char c = textTemp.charAt(i);
            if (Character.isLetter(c)) {
                filteredText.append(c);
            }
            ++i;
        }
        return filteredText.toString();
    }

    public static boolean equalsNormalized(String text1, String text2) {
        String text1Normalized = StringUtil.normalize(text1, true);
        String text2Normalized = StringUtil.normalize(text2, true);
        return text1Normalized.equals(text2Normalized);
    }

    public static String removeNewlines(String in) {
        if (in.length() == 0) {
            return "";
        }
        boolean stringModified = false;
        char[] buffer = in.toCharArray();
        int readindex = 0;
        int writeindex = 0;
        int next_LF_skip_pos = -1;
        while (readindex < buffer.length) {
            char c = buffer[readindex];
            if (c == '\r') {
                stringModified = true;
                buffer[writeindex] = 32;
                ++writeindex;
                next_LF_skip_pos = readindex + 1;
            } else if (c == '\n') {
                stringModified = true;
                if (next_LF_skip_pos != readindex) {
                    buffer[writeindex] = 32;
                    ++writeindex;
                }
            } else {
                buffer[writeindex] = c;
                ++writeindex;
            }
            ++readindex;
        }
        String result = stringModified ? new String(buffer, 0, writeindex) : in;
        return result;
    }

    public static String removeCarriageReturns(String in) {
        boolean stringModified = false;
        char[] buffer = in.toCharArray();
        int writeIndex = 0;
        int index = 0;
        while (index < buffer.length) {
            if (buffer[index] == '\r') {
                stringModified = true;
            } else {
                if (stringModified) {
                    buffer[writeIndex] = buffer[index];
                }
                ++writeIndex;
            }
            ++index;
        }
        String result = stringModified ? new String(buffer, 0, writeIndex) : in;
        return result;
    }

    public static String removeNewlinesAndTrim(String in) {
        return StringUtil.removeNewlines(in).trim();
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean containsSubstring(String string, String substring) {
        assert (string != null) : "string must not be null";
        assert (substring != null) : "substring must not be null";
        int strLen = string.length();
        int subLen = substring.length();
        int len = strLen - subLen;
        int i = 0;
        while (i <= len) {
            if (string.regionMatches(true, i, substring, 0, subLen)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String appendSpace(String string, int newLength) {
        assert (string != null);
        assert (newLength >= 0);
        char[] chars = new char[string.length() + newLength];
        System.arraycopy(string.toCharArray(), 0, chars, 0, string.length());
        Arrays.fill(chars, string.length(), string.length() + newLength, ' ');
        return new String(chars);
    }

    public static String shrink(String orig, int newLength) {
        if (newLength == 0) {
            return orig;
        }
        assert (newLength >= 2);
        if (newLength < orig.length()) {
            return String.valueOf(orig.substring(0, newLength - 1)) + '\u2026';
        }
        return orig;
    }

    public static String concatWithWindowsLineBreaks(Iterable<? extends String> strings, boolean addDelimiterAfterLastPart) {
        assert (strings != null) : "strings must not be null";
        return StringUtil.concatWithDelimiter(strings, CRLF, addDelimiterAfterLastPart);
    }

    private static String concatWithDelimiter(Iterable<? extends String> strings, String delimiter, boolean addDelimiterAfterLastPart) {
        assert (strings != null) : "strings must not be null";
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String string : strings) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(string);
        }
        if (!first && addDelimiterAfterLastPart) {
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String concatWithLineBreaks(String[] strings, boolean addDelimiterAfterLastPart) {
        assert (strings != null) : "strings must not be null";
        return StringUtil.concatWithDelimiter(strings, '\r', addDelimiterAfterLastPart);
    }

    public static String concatWithDelimiter(String[] strings, char delimiter, boolean addDelimiterAfterLastPart) {
        assert (strings != null) : "strings must not be null";
        int numberOfStrings = strings.length;
        StringBuffer sb = new StringBuffer();
        int index = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            sb.append(element);
            if (addDelimiterAfterLastPart || index < numberOfStrings - 1) {
                sb.append(delimiter);
            }
            ++index;
            ++n2;
        }
        return sb.toString();
    }

    public static String reduceToAllowedCharacters(String stringToReduce, String allowedCharactersFirstChar, String allowedCharactersFollowingChars, char replaceChar) {
        char[] stringAsCharArray = stringToReduce.toCharArray();
        int i = 0;
        while (i < stringAsCharArray.length) {
            boolean stringIsOk;
            String allowedCharacters = i == 0 ? allowedCharactersFirstChar : allowedCharactersFollowingChars;
            boolean bl = stringIsOk = allowedCharacters.indexOf(stringAsCharArray[i]) >= 0;
            if (!stringIsOk) {
                stringAsCharArray[i] = replaceChar;
            }
            ++i;
        }
        return String.valueOf(stringAsCharArray);
    }

    public static String createCanonicalStringConcatenation(String string) {
        StringBuffer sb = new StringBuffer();
        if (string == null) {
            sb.append('\u0000');
        } else {
            sb.append(string.replace(NULL_STR, NULL_AND_BLANK_STR));
        }
        return sb.toString();
    }

    public static String createCanonicalStringConcatenation(String[] elements) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(NULL_AND_QUOTATIONMARK_STR);
            }
            if (element == null) {
                sb.append('\u0000');
            } else {
                sb.append(element.replace(NULL_STR, NULL_AND_BLANK_STR));
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String createCanonicalStringConcatenation(Set<String> elements) {
        ArrayList<String> sortedElements = new ArrayList<String>(elements);
        Collections.sort(sortedElements, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        String[] sortedElementsArray = sortedElements.toArray(new String[sortedElements.size()]);
        return StringUtil.createCanonicalStringConcatenation(sortedElementsArray);
    }

    public static String limitParagraphLength(String message, int lengthBound) {
        boolean firstlengthBoundedSegmentAlreadyAppended = false;
        StringBuilder resultBuilder = new StringBuilder();
        String remainingMessageText = message;
        while (remainingMessageText != null) {
            String originalLine;
            int lfPos = remainingMessageText.indexOf(10);
            if (lfPos < 0) {
                originalLine = remainingMessageText;
                remainingMessageText = null;
            } else {
                originalLine = remainingMessageText.substring(0, lfPos);
                remainingMessageText = remainingMessageText.substring(lfPos + 1);
            }
            String remainingTextOfOriginalLine = originalLine;
            while (remainingTextOfOriginalLine != null) {
                String lengthBoundedSegment;
                if (remainingTextOfOriginalLine.length() > lengthBound) {
                    String prefix = remainingTextOfOriginalLine.substring(0, lengthBound);
                    int lastIndexOfSpaceInPrefix = prefix.lastIndexOf(32);
                    lengthBoundedSegment = lastIndexOfSpaceInPrefix < 0 ? prefix : remainingTextOfOriginalLine.substring(0, lastIndexOfSpaceInPrefix + 1);
                    remainingTextOfOriginalLine = remainingTextOfOriginalLine.substring(lengthBoundedSegment.length());
                } else {
                    lengthBoundedSegment = remainingTextOfOriginalLine;
                    remainingTextOfOriginalLine = null;
                }
                if (firstlengthBoundedSegmentAlreadyAppended) {
                    resultBuilder.append('\n');
                } else {
                    firstlengthBoundedSegmentAlreadyAppended = true;
                }
                resultBuilder.append(lengthBoundedSegment);
            }
        }
        return resultBuilder.toString();
    }

    public static String replaceLineBreaksWithWindowsLineBreaks(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder transformedString = null;
        int index = 0;
        int nextLineFeedIndex = -2;
        int nextCarriageReturnIndex = -2;
        boolean stringModified = false;
        boolean endOfStringReached = false;
        while (!endOfStringReached) {
            if (nextCarriageReturnIndex != -1 && nextCarriageReturnIndex < index) {
                nextCarriageReturnIndex = in.indexOf(13, index);
            }
            if (nextLineFeedIndex != -1 && nextLineFeedIndex < index) {
                nextLineFeedIndex = in.indexOf(10, index);
            }
            if (nextLineFeedIndex != -1 && nextCarriageReturnIndex != -1 && nextLineFeedIndex == nextCarriageReturnIndex + 1) {
                if (stringModified) {
                    transformedString.append(in.substring(index, nextLineFeedIndex + 1));
                }
                index = nextCarriageReturnIndex + 2;
                continue;
            }
            if (nextCarriageReturnIndex != -1 && (nextLineFeedIndex == -1 || nextCarriageReturnIndex < nextLineFeedIndex)) {
                if (!stringModified) {
                    stringModified = true;
                    transformedString = new StringBuilder(in.length() * 2);
                    transformedString.append(in.substring(0, nextCarriageReturnIndex)).append(CRLF);
                } else {
                    transformedString.append(in.substring(index, nextCarriageReturnIndex)).append(CRLF);
                }
                index = nextCarriageReturnIndex + 1;
                continue;
            }
            if (nextLineFeedIndex != -1 && (nextCarriageReturnIndex == -1 || nextLineFeedIndex < nextCarriageReturnIndex)) {
                if (!stringModified) {
                    stringModified = true;
                    transformedString = new StringBuilder(in.length() * 2);
                    transformedString.append(in.substring(0, nextLineFeedIndex)).append(CRLF);
                } else {
                    transformedString.append(in.substring(index, nextLineFeedIndex)).append(CRLF);
                }
                index = nextLineFeedIndex + 1;
                continue;
            }
            if (nextCarriageReturnIndex != -1 || nextLineFeedIndex != -1) continue;
            if (stringModified) {
                transformedString.append(in.substring(index));
            }
            endOfStringReached = true;
        }
        return stringModified ? transformedString.toString() : in;
    }

    public static String multiplicateString(String original, int numberOfMultiplications) {
        StringBuilder resultBuilder = new StringBuilder(original.length() * numberOfMultiplications);
        int index = 0;
        while (index < numberOfMultiplications) {
            resultBuilder.append(original);
            ++index;
        }
        return resultBuilder.toString();
    }

    public static ArrayList<String> split(String string, char delimiter, int limit) {
        int delimiterIdx;
        String string_;
        if (limit == 0) {
            boolean trailingDelimitersDetected = false;
            int pos = string.length() - 1;
            while (pos >= 0 && string.charAt(pos) == delimiter) {
                --pos;
                trailingDelimitersDetected = true;
            }
            string_ = !trailingDelimitersDetected ? string : string.substring(0, pos + 1);
        } else {
            string_ = string;
        }
        ArrayList<String> splitResult = limit > 0 && limit < 40 ? new ArrayList(limit) : new ArrayList<String>(10);
        int startIdx = 0;
        while ((delimiterIdx = limit <= 0 || limit > 0 && splitResult.size() < limit - 1 ? string_.indexOf(delimiter, startIdx) : -1) != -1) {
            splitResult.add(string_.substring(startIdx, delimiterIdx));
            startIdx = delimiterIdx + 1;
        }
        if (startIdx == 0) {
            splitResult.add(string_);
        } else {
            splitResult.add(string_.substring(startIdx));
        }
        return splitResult;
    }

    public static ArrayList<String> split(String string, char delimiter) {
        return StringUtil.split(string, delimiter, 0);
    }
}

