/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.IOException;

public abstract class AbstractStreamDataBuffer {
    private static final ILogger LOGGER = Logger.getLogger(AbstractStreamDataBuffer.class);
    public static final int MaxMemBufSize = 10240;
    public static final long UnknownTotalStreamLength = -1L;
    private final ITempFileManager tempFileManager;
    private File tempfile;
    private boolean isDisposed;

    public AbstractStreamDataBuffer(ITempFileManager tempFileManager) {
        this.tempFileManager = tempFileManager;
        this.isDisposed = false;
    }

    protected File getTempFile() throws IOException {
        assert (!this.isDisposed);
        if (this.tempfile == null) {
            this.tempfile = this.tempFileManager.allocateTempFile();
        }
        return this.tempfile;
    }

    public abstract long getTotalStreamLength();

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        this.isDisposed = true;
        if (this.tempfile != null) {
            try {
                FileHelper.deleteExistingFileOrDirectory((File)this.tempfile);
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.warn("Problem while deleting obslete temp file", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        assert (this.isDisposed);
        super.finalize();
    }

    public static class DefaultTempFileManager
    implements ITempFileManager {
        private static final DefaultTempFileManager singleton = new DefaultTempFileManager();

        public static DefaultTempFileManager getSingleton() {
            return singleton;
        }

        private DefaultTempFileManager() {
        }

        @Override
        public File allocateTempFile() throws IOException {
            return File.createTempFile("StreamBuf", null);
        }
    }

    public static interface IBufferTransferProgressWatchdog {
        public void noteTransferActivity(long var1);
    }

    public static interface ITempFileManager {
        public File allocateTempFile() throws IOException;
    }
}

