/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.lic;

import com.arcway.lib.java.tuples.Tuple;
import java.sql.Timestamp;
import java.util.Collection;

public class ValidityHelper {
    public static final Timestamp EXPIRES_NEVER_TIMESTAMP = new Timestamp(0L);
    public static final Timestamp VALID_SINCE_EVER_TIMESTAMP = new Timestamp(0L);

    public static NrOfLicensesAndValidity getMaximumValidityForAtLeastOneLicense(Collection<NrOfLicensesAndValidity> validityPeriods) {
        long startDate = System.currentTimeMillis() - 86400000L;
        long endDate = System.currentTimeMillis();
        long numberOfLicenses = -1L;
        boolean isFirstLoop = true;
        boolean hasValidityPeriodBeenExtended = true;
        while (hasValidityPeriodBeenExtended) {
            hasValidityPeriodBeenExtended = false;
            for (NrOfLicensesAndValidity nrOfLicensesAndValidity : validityPeriods) {
                if (!(startDate == -1L || nrOfLicensesAndValidity.validFromDate >= startDate && nrOfLicensesAndValidity.validFromDate != -1L || nrOfLicensesAndValidity.expiryDate < startDate && nrOfLicensesAndValidity.expiryDate != -1L)) {
                    startDate = nrOfLicensesAndValidity.validFromDate;
                    numberOfLicenses = ValidityHelper.getMinimumNumberOfUsers(numberOfLicenses, nrOfLicensesAndValidity.nrOfLicenses);
                    hasValidityPeriodBeenExtended = true;
                }
                if (endDate == -1L || nrOfLicensesAndValidity.validFromDate > endDate && nrOfLicensesAndValidity.validFromDate != -1L || nrOfLicensesAndValidity.expiryDate <= endDate && nrOfLicensesAndValidity.expiryDate != -1L) continue;
                endDate = nrOfLicensesAndValidity.expiryDate;
                numberOfLicenses = ValidityHelper.getMinimumNumberOfUsers(numberOfLicenses, nrOfLicensesAndValidity.nrOfLicenses);
                hasValidityPeriodBeenExtended = true;
            }
            if (isFirstLoop && !hasValidityPeriodBeenExtended) {
                return new NrOfLicensesAndValidity(0L, 0L, 0L);
            }
            isFirstLoop = false;
        }
        return new NrOfLicensesAndValidity(numberOfLicenses, startDate, endDate);
    }

    public static final Tuple<Timestamp, Timestamp> getLongestCommonValidityPeriod(Timestamp startDate1, Timestamp endDate1, Timestamp startDate2, Timestamp endDate2) {
        if (ValidityHelper.isBeforeOrEqualTo(endDate1, startDate2) || ValidityHelper.isBeforeOrEqualTo(endDate2, startDate1)) {
            return null;
        }
        Timestamp stricterStartDate = ValidityHelper.isBeforeOrEqualTo(startDate1, startDate2) ? startDate2 : startDate1;
        Timestamp stricterEndDate = ValidityHelper.isBeforeOrEqualTo(endDate1, endDate2) ? endDate1 : endDate2;
        return new Tuple((Object)stricterStartDate, (Object)stricterEndDate);
    }

    private static final boolean isBeforeOrEqualTo(Timestamp timestamp1, Timestamp timestamp2) {
        if (timestamp1 == VALID_SINCE_EVER_TIMESTAMP) {
            return true;
        }
        if (timestamp1 == EXPIRES_NEVER_TIMESTAMP) {
            return timestamp2 == EXPIRES_NEVER_TIMESTAMP;
        }
        if (timestamp2 == VALID_SINCE_EVER_TIMESTAMP) {
            return false;
        }
        if (timestamp2 == EXPIRES_NEVER_TIMESTAMP) {
            return true;
        }
        return timestamp1.before(timestamp2);
    }

    private static final long getMinimumNumberOfUsers(long numberOfLicenses1, long numberOfLicenses2) {
        if (numberOfLicenses1 == -1L) {
            if (numberOfLicenses2 == -1L) {
                return -1L;
            }
            return numberOfLicenses2;
        }
        if (numberOfLicenses2 == -1L) {
            return numberOfLicenses1;
        }
        return Math.min(numberOfLicenses1, numberOfLicenses2);
    }

    public static class NrOfLicensesAndValidity {
        public static final long UNLIMITED = -1L;
        long nrOfLicenses;
        long validFromDate;
        long expiryDate;

        public NrOfLicensesAndValidity(long nrOfLicenses, long validFromDate, long expiryDate) {
            this.nrOfLicenses = nrOfLicenses;
            this.validFromDate = validFromDate;
            this.expiryDate = expiryDate;
        }
    }
}

