/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.lic;

import de.plans.lib.lic.ValidityHelper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModuleLicense {
    public String moduleName;
    private final List<ValidityHelper.NrOfLicensesAndValidity> validityPeriods = new ArrayList<ValidityHelper.NrOfLicensesAndValidity>();

    public ModuleLicense(String moduleName, long validityStartDate, long expiryDate) {
        this.moduleName = moduleName;
        this.validityPeriods.add(new ValidityHelper.NrOfLicensesAndValidity(-1L, validityStartDate, expiryDate));
    }

    public void addLicense(long expiryDate, long validFromDate) {
        this.validityPeriods.add(new ValidityHelper.NrOfLicensesAndValidity(-1L, validFromDate, expiryDate));
    }

    public Timestamp getExpiryDate() {
        ValidityHelper.NrOfLicensesAndValidity validity = this.getValidityForSingleLicense();
        if (validity.expiryDate != -1L) {
            return new Timestamp(validity.expiryDate);
        }
        return ValidityHelper.EXPIRES_NEVER_TIMESTAMP;
    }

    public Timestamp getValidFromDate() {
        ValidityHelper.NrOfLicensesAndValidity validity = this.getValidityForSingleLicense();
        if (validity.validFromDate != -1L) {
            return new Timestamp(validity.validFromDate);
        }
        return ValidityHelper.VALID_SINCE_EVER_TIMESTAMP;
    }

    private ValidityHelper.NrOfLicensesAndValidity getValidityForSingleLicense() {
        this.updateLicenseCount();
        return ValidityHelper.getMaximumValidityForAtLeastOneLicense(this.validityPeriods);
    }

    private void updateLicenseCount() {
        long systemTime = System.currentTimeMillis() - 86400000L;
        Iterator<ValidityHelper.NrOfLicensesAndValidity> iterator = this.validityPeriods.iterator();
        while (iterator.hasNext()) {
            ValidityHelper.NrOfLicensesAndValidity nrOfLicensesAndValidity = iterator.next();
            if (nrOfLicensesAndValidity.expiryDate == -1L || nrOfLicensesAndValidity.expiryDate >= systemTime) continue;
            iterator.remove();
        }
    }
}

