/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.Messages;
import com.arcway.lib.java.locale.LocalisationUtils;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractFreeStringWidgetNumberPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;

public class FreeStringWidgetInteger64BitPropertyWidgetAdapter
extends AbstractFreeStringWidgetNumberPropertyWidgetAdapter {
    private final PropertyPlayground playground;

    public FreeStringWidgetInteger64BitPropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        try {
            this.removeWidgetAdapterError();
            String currentValue = (String)widget.getCurrentValue();
            try {
                Long newValue = LocalisationUtils.parseInteger64Localized((String)currentValue, (Locale)this.getContentLocale());
                Double newValueAsDouble = newValue != null ? Double.valueOf(newValue.doubleValue()) : null;
                this.playground.setValue(newValueAsDouble, this);
            }
            catch (ParseException pE) {
                String errorMessageKey = "FreeStringWidgetIntegerPropertyWidgetAdapter.errorInInput";
                this.setWidgetAdapterError(new ITextProvider(){

                    @Override
                    public String getText(PresentationContext presentationContext) {
                        return Messages.getString("FreeStringWidgetIntegerPropertyWidgetAdapter.errorInInput", presentationContext.getLocale());
                    }
                });
            }
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            this.playground.setError(new PlaygroundError(IMessageLevel.NORMAL, new ConstantTextProvider(e.getLocalizedMessage())));
        }
    }
}

