/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.UITypeID;
import com.arcway.lib.ui.editor.datatype.IComplexWidgetFactory;
import com.arcway.lib.ui.editor.datatype.ICompositeLayoutWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IDataWidgetFactory;
import com.arcway.lib.ui.editor.datatype.ILayoutWidget;
import com.arcway.lib.ui.editor.datatype.ILayoutWidgetFactory;
import com.arcway.lib.ui.editor.datatype.IPageWidget;
import com.arcway.lib.ui.editor.datatype.ITestWidgetFactory;
import com.arcway.lib.ui.editor.datatype.IWidget;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.manager.WidgetFactoryRegistry;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import java.util.Locale;

public class WidgetFactoryController {
    private static final ILogger logger = Logger.getLogger(WidgetFactoryController.class);
    private final UITypeID uiTypeID;

    public WidgetFactoryController(UITypeID uiTypeID) {
        this.uiTypeID = uiTypeID;
    }

    public IDataWidget createDataWidget(IWidgetTypeID widgetTypeID, WidgetParameters parameters, ICompositeWidget parentWidget, IDataWidgetAdapter widgetAdapter) {
        IDataWidget widget = null;
        WidgetFactoryRegistry widgetFactoryRegistry = WidgetFactoryRegistry.getInstance();
        IDataWidgetFactory widgetFactory = widgetFactoryRegistry.findDataWidgetFactory(widgetTypeID, this.uiTypeID);
        if (widgetFactory != null) {
            widget = widgetFactory.createWidget(parameters, parentWidget, widgetAdapter);
        } else {
            logger.error("No widget factory found for data widget of type: " + widgetTypeID.toCanonicalString() + " in ui type: " + this.uiTypeID.getKey());
        }
        return widget;
    }

    public ICompositeLayoutWidget createComplexWidget(IWidgetTypeID widgetTypeID, WidgetParameters parameters, ICompositeWidget parentWidget, IComplexWidgetAdapter widgetAdapter) {
        ICompositeLayoutWidget widget = null;
        WidgetFactoryRegistry widgetFactoryRegistry = WidgetFactoryRegistry.getInstance();
        IComplexWidgetFactory widgetFactory = widgetFactoryRegistry.findComplexWidgetFactory(widgetTypeID, this.uiTypeID);
        if (widgetFactory != null) {
            widget = widgetFactory.createWidget(parameters, parentWidget, widgetAdapter, this);
        } else {
            logger.error("No widget factory found for complex widget of type: " + widgetTypeID.toCanonicalString() + " in ui type: " + this.uiTypeID.getKey());
        }
        return widget;
    }

    public IWidget createLayoutWidget(IWidgetTypeID widgetTypeID, WidgetParameters parameters, Locale userLocale, ICompositeWidget parentWidget) {
        IWidget widget = null;
        WidgetFactoryRegistry widgetFactoryRegistry = WidgetFactoryRegistry.getInstance();
        ILayoutWidgetFactory layoutWidgetFactory = widgetFactoryRegistry.findLayoutWidgetFactory(widgetTypeID, this.uiTypeID);
        if (layoutWidgetFactory != null) {
            widget = layoutWidgetFactory.createWidget(parameters, parentWidget, userLocale);
            assert (widget instanceof IPageWidget || widget instanceof ILayoutWidget);
        } else {
            logger.error("No widget factory found for layout widget of type: " + widgetTypeID.toCanonicalString() + " in ui type: " + this.uiTypeID.getKey());
        }
        return widget;
    }

    public IDataWidget createTestWidget(IWidgetTypeID widgetTypeID, IDataWidgetAdapter widgetAdapter) {
        IDataWidget widget = null;
        WidgetFactoryRegistry widgetFactoryRegistry = WidgetFactoryRegistry.getInstance();
        ITestWidgetFactory testWidgetFactory = widgetFactoryRegistry.findTestWidgetFactory(widgetTypeID);
        if (testWidgetFactory != null) {
            widget = testWidgetFactory.createWidget(widgetAdapter);
        } else {
            logger.error("No widget factory found for test widget of type: " + widgetTypeID.toCanonicalString() + " in ui type: " + this.uiTypeID.getKey());
        }
        return widget;
    }
}

