/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

import com.arcway.lib.graphics.saveimage.ByteBuffer;
import com.arcway.lib.graphics.saveimage.ImageOutputStreamImpl;
import java.io.IOException;

public class ByteBufferImageOutputStream
extends ImageOutputStreamImpl {
    private final ByteBuffer raf;

    public ByteBufferImageOutputStream(ByteBuffer raf) {
        if (raf == null) {
            throw new IllegalArgumentException("raf == null!");
        }
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.raf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int nbytes = this.raf.read(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.raf.write(b);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.raf.write(b, off, len);
        this.streamPos += (long)len;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.raf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.raf.seek(pos);
        this.streamPos = this.raf.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.raf.close();
    }
}

